<?php
session_start();
if (!isset($_SESSION['idUsuarioLogado'])) {
  header("location: ./");
}
include_once("header.php"); //Cabeçalho padrão de todas as páginas
?>
<div class="app-content content" style='background-color:#e1e9e7;'>
  <div class="content-wrapper" style='padding:10px;'>
    <section id="ordering">
      <div class="row">
        <div class="col-12">
          <div class="card" style='border:gray 1px solid;' id="card-tela">
            <div class="card-header titulo-telas">
              <i class="icofont icofont-users" style='margin-top:-15px !important'></i>&nbsp;Cadastro de Usuários do Sistema
              <a class="heading-elements-toggle"><i class="fa fa-ellipsis-v font-medium-3"></i></a>
              <div class="heading-elements">
                <ul class="list-inline mb-0" style="margin-top: -12px; color: #fff;">
                  <li>
                    <a data-action="collapse"><i class="ft-minus"></i></a>
                  </li>
                  <li>
                    <a data-action="expand"><i class="ft-maximize"></i></a>
                  </li>
                </ul>
              </div>
            </div>
            <div class="card-content collapse show">
              <div class="card-body">
                <form class="form" id="formularioUsuario">
                  <div class="form-body">
                    <h4 class="form-section"><i class="ft-user"></i> <b>Dados de Idetificação</b>
                      <input type="hidden" id="idUsuario">
                    </h4>
                    <div class="row">
                      <div class="col-md-5">
                        <div class="form-group">
                          <label for="nomeUsuario">Nome:</label>
                          <input type="text" id="nomeUsuario" class="form-control" autofocus>
                        </div>
                      </div>
                      <div class="col-md-3">
                        <div class="form-group">
                          <label for="cpfUsuario">CPF:</label>
                          <input type="text" id="cpfUsuario" class="form-control cpf-inputmask text-center" onblur="validaCPF(this.value)">
                        </div>
                      </div>
                      <div class="col-md-4">
                        <div class="form-group">
                          <label for="emailUsuario">Email:</label>
                          <input type="mail" id="emailUsuario" class="form-control email-inputmask form-control-email-homepage">
                        </div>
                      </div>
                    </div>
                    <div class="row">
                      <div class="col-md-3">
                        <div class="form-group">
                          <label for="telefoneUsuario">Telefone:</label>
                          <input type="text" id="telefoneUsuario" class="form-control fonecelular-inputmask text-center">
                        </div>
                      </div>
                      <div class="col-md-2">
                        <div class="form-group">
                          <label for="senhaUsuario">Senha:</label>
                          <input type="password" id="senhaUsuario" class="form-control text-center">
                        </div>
                      </div>
                      <div class="col-md-3">
                        <div class="form-group">
                          <label for="usuarioGestor">Usuário Gestor:</label>
                          <select id="usuarioGestor" class="form-control">
                            <option value=''>SELECIONE...</option>
                            <option value='S'>SIM</option>
                            <option value='N'>NÃO</option>
                          </select>
                        </div>
                      </div>
                      <div class="col-md-4">
                        <div class="form-group">
                          <label for="autorizaCNS">Autoriza Cartão SUS:</label>
                          <select id="autorizaCNS" class="form-control">
                            <option value=''>SELECIONE...</option>
                            <option value='S'>SIM</option>
                            <option value='N'>NÃO</option>
                          </select>
                        </div>
                      </div>
                    </div>
                    <div class="row">
                      <div class="col-md-3">
                        <div class="form-group">
                          <label for="statusUsuario">Exibir:</label>
                          <select id="statusUsuario" class="form-control">
                            <option value='1'>ATIVOS</option>
                            <option value='0'>INATIVOS</option>
                            <option value=''>AMBOS</option>
                          </select>
                        </div>
                      </div>
                      <div class="col-md-3">
                        <div class="form-group">
                          <label for="telaInicioUsuario">Tela inicial:</label>
                          <select id="telaInicioUsuario" class="form-control">
                            <option value=''>SELECIONE</option>
                            <option value='tela-padrao'>TELA PADRÃO</option>
                            <option value='painel-inforativo'>PAINEL INFORMATIVO</option>
                            <option value='painel-senha'>PAINEL DE SENHA</option>
                          </select>
                        </div>
                      </div>
                      <div class="col-md-3">
                        <div class="form-group">
                          <label>&nbsp;</label><br>
                          <button type="button" class="btn btn-info" onClick="cadastrarUsuario()" style="width:110px;">
                            <i class="fa fa-check-square-o"></i> Salvar
                          </button>
                          <button type="button" id="btnCancelar" class="btn btn-danger" onClick="cancelarEdicaoCadastro()" style="width:110px;">
                            <i class="fa fa-times"></i> Cancelar
                          </button>
                        </div>
                      </div>
                    </div>
                    <div class="row">
                      <div class="col-md-12">
                        <div class="form-group" style="border-top:1px dotted gray;"></div>
                      </div>
                    </div>
                    <div class="form-body" style="margin-top:-5px">
                      <h4 class="form-section"><i class="ft-list"></i> <b>Lista de usuários cadastrados</b></h4>
                    </div>
                  </div>
                </form>
              </div>
            </div>
            <div class="card-content collapse show" style="margin-top:-55px !important">
              <div class="card-body card-dashboard">
                <table class="table table-striped table-bordered default-ordering table-responsive-xl2" id='dados_dousuarios'>
                  <thead>
                    <th style='text-align:center; width:130px'>&nbsp;OPÇÕES&nbsp;</th>
                    <th>NOME DO USUÁRIO</th>
                    <th style='text-align:center; width:105px'>CPF</th>
                    <th>EMAIL</th>
                    <th style='text-align:center; width:110px'>TELEFONE</th>
                    <th style='text-align:center; width:110px'>GESTOR</th>
                    <th style='text-align:center; width:110px'>AUTORIZA CNS</th>
                    </tr>
                  </thead>
                  <tbody style="background-color:#ececec" id="bady_dados_usuarios">
                    <?php
                    $sqlUsuario = "SELECT reg_tb_usuario.* FROM reg_tb_usuario WHERE (id_usuario!='119') AND (ativo='1') ORDER BY nome_usuario ASC";
                    $stmUsuario  = $rsConexao->prepare($sqlUsuario);
                    $stmUsuario->execute();
                    $totalRegistrosUsuario = $stmUsuario->rowCount();
                    $rsUsuario      = $stmUsuario->fetchAll(PDO::FETCH_ASSOC);
                    if ($totalRegistrosUsuario > 0) {

                      foreach ($rsUsuario as $fieldUsuario) {
                        $idUsuario          = $fieldUsuario['id_usuario'];
                        $nomeUsuario        = mb_strtoupper($fieldUsuario['nome_usuario']);
                        $emailUsuario        = $fieldUsuario['email_usuario'];
                        $telefoneCelular    = $fieldUsuario['fonecelular'];
                        $cpfUsuario          = $fieldUsuario['cpf_usuario'];
                        $usuarioAtivo       = $fieldUsuario['ativo'];
                        $eGestor             = $fieldUsuario['e_gestor'] == "S" ? "SIM" : "NÃO";
                        $autorizaCNS        = $fieldUsuario['autoriza_cns'] == "S" ? "SIM" : "NÃO";
                        $autorizaCNSEditar  = $fieldUsuario['autoriza_cns'];
                        $telaInicial        = $fieldUsuario['telapeinel_inicio'];

                        $conteudoEdicao     = $idUsuario . "#" . $nomeUsuario . "#" . $cpfUsuario . "#" . $emailUsuario . "#" .
                          $telefoneCelular . "#" . $fieldUsuario['e_gestor'] . "#" . $autorizaCNSEditar . "#" . $telaInicial;

                        $linkEditarUsuario    = '"editarDados(' . "'cadastro_usuario','$conteudoEdicao')" . '"';
                        $linkAlteraSenha      = '"gerarNovaSenha(' . "'nova_senha_aleatoria','$idUsuario','$nomeUsuario')" . '"';

                        if ($usuarioAtivo == 0) {
                          $corLinha = "style='background-color:#f3b5b5 !important; color: #700000'";
                          $linkBloqueioUsuario  = '"bloquearDesbloquearUsuario(' . "'$idUsuario','1')" . '"';
                          $botaoBloqueioUsuario  = "<i class='icofont icofont-tick-boxed nova_fonte_blue' title='Ativar usuário.'  onclick=$linkBloqueioUsuario></i>";
                        } else {
                          $corLinha  = "";
                          $linkBloqueioUsuario  = '"bloquearDesbloquearUsuario(' . "'$idUsuario','0')" . '"';
                          $botaoBloqueioUsuario  = "<i class='icofont icofont-not-allowed nova_fonte_delete' title='Bloquear usuário.'  onclick=$linkBloqueioUsuario></i>";
                        }

                        $linkPerfilAcesso  = '"window.open(' . "'usuario_perfilacesso_atribuir?idu=$idUsuario')" . '"';

                        # -- relacionar perfis do usuario --#
                        $sqlPerfil = "SELECT reg_tb_usuario_perfil.id_usuarioperfil,
												reg_rl_usuario_perfil.id_usuario_perfil,
												reg_rl_usuario_perfil.descricao_usuario_perfil,
												tb_estabelecimento.codigoestabelecimento_cnes,
												tb_estabelecimento.nfantasia_estabelecimento,
												reg_tb_usuario_perfil.ibge_municipioacesso	
												FROM reg_tb_usuario_perfil
												INNER JOIN reg_rl_usuario_perfil ON (reg_tb_usuario_perfil.id_pefilusuario = reg_rl_usuario_perfil.id_usuario_perfil)
												INNER JOIN reg_tb_usuario ON (reg_tb_usuario_perfil.id_usuario = reg_tb_usuario.id_usuario)
												INNER JOIN tb_estabelecimento ON (tb_estabelecimento.codigoestabelecimento_cnes = reg_tb_usuario_perfil.id_unidadeassociada)
												WHERE reg_tb_usuario.id_usuario='$idUsuario'
												ORDER BY descricao_usuario_perfil
												LIMIT 4";

                        $stmPerfil  = $rsConexao->prepare($sqlPerfil);
                        $stmPerfil->execute();
                        if ($stmPerfil->rowCount() > 0) {
                          $rsPerfil      = $stmPerfil->fetchAll(PDO::FETCH_ASSOC);
                          $contarPerfil = 0;
                          $nomeUnidade  = "";
                          $nomePerfil    = "";
                          foreach ($rsPerfil as $fieldPerfil) {
                            $contarPerfil  = $contarPerfil + 1;
                            $nomeUnidade  = mb_strtoupper($fieldPerfil['nfantasia_estabelecimento']);

                            if ($contarPerfil <= 3) {
                              if ($nomePerfil == "") {
                                $nomePerfil  = "&bull; " . mb_strtoupper($fieldPerfil['descricao_usuario_perfil']) . " - (Unidade: $nomeUnidade)";
                              } else {
                                $nomePerfil  = "$nomePerfil<br>&bull; " . mb_strtoupper($fieldPerfil['descricao_usuario_perfil']) . " - (Unidade: $nomeUnidade)";
                              }
                            } else {
                              $nomePerfil = "$nomePerfil<br><b><font style='color: #118b01'>Tem mais...</font></b>";
                            }
                          }
                          $corFontPerfil = "#027fbe";
                        } else {
                          $nomePerfil  = "&bull; USUÁRIO SEM PERFIL ASSOCIADO";
                          $corFontPerfil = "#830202";
                        }
                        # --------------- #
                        echo "<tr $corLinha>
														<td style='text-align:center'>																			
															<i class='icofont icofont-id-card nova_fonte' title='Atribuir perfil de acesso.'  onclick=$linkPerfilAcesso style='font-size:16pt; color:#006DB3'></i>
															<i class='ft-edit nova_fonte' title='Editar dados do usuário.'  onclick=$linkEditarUsuario></i>
															<i class='icofont icofont-key nova_fonte' style='color:#147500' title='Gerar uma nova senha.'  onclick=$linkAlteraSenha></i>
															$botaoBloqueioUsuario
														</td>
														<td>
															<b>$nomeUsuario</b>
															<div style='width:auto; padding:2px; color:$corFontPerfil'>
																$nomePerfil
															</div>
														</td>
														<td style='text-align:center'>$cpfUsuario</td>
														<td>$emailUsuario</td>
														<td style='text-align:center'>$telefoneCelular</td>
														<td style='text-align:center'>$eGestor</td>
														<td style='text-align:center'>$autorizaCNS</td>
													</tr>";
                      }
                    }
                    ?>
                  </tbody>
                </table>
              </div>
            </div>
          </div>
        </div>
    </section>
  </div>
</div>

<?php
include_once("footer.php");
?>
<script src="../app-assets/vendors/js/forms/extended/inputmask/jquery.inputmask.bundle.min.js"></script>
<script src="../app-assets/js/scripts/forms/extended/form-inputmask.min.js"></script>
<script src="../app-assets/vendors/js/tables/datatable/datatables.min.js"></script>
<script src="../app-assets/js/scripts/tables/datatables/datatable-basic.min.js"></script>
<script src="../app-assets/js/scripts/ui/jquery-ui/buttons-selects.min.js"></script>

<script>
  $("#liCadastroUsuario").attr('class', 'active');

  function validaCPF(numeroCPF) {

    var numeros, digitos, soma, i, resultado, digitos_iguais;
    digitos_iguais = 1;

    var cpfLimpo = numeroCPF.replace(/[^a-z0-9]/gi, '');

    if (cpfLimpo != "") {
      for (i = 0; i < cpfLimpo.length - 1; i++)
        if (cpfLimpo.charAt(i) != cpfLimpo.charAt(i + 1)) {
          digitos_iguais = 0;
          break;
        }
      if (!digitos_iguais) {
        numeros = cpfLimpo.substring(0, 9);
        digitos = cpfLimpo.substring(9);
        soma = 0;
        for (i = 10; i > 1; i--)
          soma += numeros.charAt(10 - i) * i;
        resultado = soma % 11 < 2 ? 0 : 11 - soma % 11;
        if (resultado != digitos.charAt(0)) {
          $("#cpfUsuario").val("");
          swal("CPF Inválido", "O CPF [ " + numeroCPF + " ] digitado para acessar o sistema não é válido. Digite um CPF válido!", "error");
          return false;
        }
        numeros = cpfLimpo.substring(0, 10);
        soma = 0;
        for (i = 11; i > 1; i--)
          soma += numeros.charAt(11 - i) * i;
        resultado = soma % 11 < 2 ? 0 : 11 - soma % 11;
        if (resultado != digitos.charAt(1)) {
          $("#cpfUsuario").val("");
          swal("CPF Inválido", "O CPF [ " + numeroCPF + " ] digitado para acessar o sistema não é válido. Digite um CPF válido!", "error");
          return false;
        } else {
          return true;
        }
      } else {
        $("#cpfUsuario").val("");
        swal("CPF Inválido", "O CPF [ " + numeroCPF + " ] digitado para acessar o sistema não é válido. Digite um CPF válido!", "error");
        return false;
      }
      return false;
    } else {
      return true;
    }
  }

  function cadastrarUsuario() {

    var idUsuario = $("#idUsuario").val();
    var nomeUsuario = $("#nomeUsuario").val();
    var cpfUsuario = $("#cpfUsuario").val();
    var emailUsuario = $("#emailUsuario").val();
    var telefoneUsuario = $("#telefoneUsuario").val();
    var senhaUsuario = $("#senhaUsuario").val();
    var usuarioGestor = $("#usuarioGestor").val();
    var statusUsuario = $("#statusUsuario").val();
    var autorizaCNS = $("#autorizaCNS").val();
    var telaInicioUsuario = $("#telaInicioUsuario").val();

    if (nomeUsuario == "" || cpfUsuario == "" || emailUsuario == "" || telefoneUsuario == "" || autorizaCNS == "") {
      swal("Dados Obrigatório", "Nome, CPF, Email, Telefone e autorização de CNS externo são obrigatórios.", "error");
      return false;
    }
    $('#embacado').css('display', 'block');

    $.ajax({
      url: 'action/gravar_usuario',
      type: 'post',
      dataType: 'html',
      data: {
        'idUsuario': idUsuario,
        'nomeUsuario': nomeUsuario,
        'cpfUsuario': cpfUsuario,
        'emailUsuario': emailUsuario,
        'telefoneUsuario': telefoneUsuario,
        'senhaUsuario': senhaUsuario,
        'usuarioGestor': usuarioGestor,
        'statusUsuario': statusUsuario,
        'autorizaCNS': autorizaCNS,
        'telaInicioUsuario': telaInicioUsuario
      }
    }).done(function(resultadoRetorno) {
      $('#embacado').css('display', 'none');

      if (resultadoRetorno == "jáExiste") {
        swal("Cadastro Duplicado", "Já existe um usuário cadastrado com este CPF.", "error");
        return false;
      }
      $('#dados_dousuarios').DataTable().destroy();
      $('#dados_dousuarios tbody').empty().append(resultadoRetorno);
      $('#dados_dousuarios').DataTable();

      $("#idUsuario").val('');
      $("#nomeUsuario").val('');
      $("#cpfUsuario").val('');
      $("#emailUsuario").val('');
      $("#telefoneUsuario").val('');
      $("#loginUsuario").val('');
      $("#senhaUsuario").val('');
      $('#senhaUsuario').prop('disabled', false);
      $("#usuarioGestor").val('');
      $("#autorizaCNS").val('');
      $("#telaInicioUsuario").val('');

    });

  }

  function cancelarEdicaoCadastro() {
    $("#idUsuario").val('');
    $("#nomeUsuario").val('');
    $("#cpfUsuario").val('');
    $("#emailUsuario").val('');
    $("#telefoneUsuario").val('');
    $("#loginUsuario").val('');
    $("#senhaUsuario").val('');
    $("#usuarioGestor").val('');
    $("#autorizaCNS").val('');
    $("#telaInicioUsuario").val('');
    $('#senhaUsuario').prop('disabled', false);
    $('#btnCancelar').prop('disabled', true);
    $("#nomeUsuario").focus();
  }

  //função para editar dados da lista no formulário
  function editarDados(opcaoEdicao, conteudoEdicao) {
    var splitConteudo = conteudoEdicao.split("#");

    if (opcaoEdicao == "cadastro_usuario") {
      $("#idUsuario").val(splitConteudo[0]);
      $("#nomeUsuario").val(splitConteudo[1]);
      $("#cpfUsuario").val(splitConteudo[2]);
      $("#emailUsuario").val(splitConteudo[3]);
      $("#telefoneUsuario").val(splitConteudo[4]);
      $("#usuarioGestor").val(splitConteudo[5]);
      $("#autorizaCNS").val(splitConteudo[6]);
      $("#telaInicioUsuario").val(splitConteudo[7]);
      $('#senhaUsuario').prop('disabled', true);
      $('#btnCancelar').prop('disabled', false);
    }

  }

  function bloquearDesbloquearUsuario(idUsuario, valorAtivacao) {

    var tituloMensagem = valorAtivacao == "0" ? "Bloquear Usuário" : "Desbloquear Usuário";
    var textMensagem = valorAtivacao == "0" ? "O usuário bloqueado não poderá mais ter acesso ao sistema. <b>Confirma?</b>" : "O usuário desbloqueado voltará a ter acesso ao sistema. <b>Confirma?</b>";
    var mensagemCancelar = valorAtivacao == "0" ? "O usuário não foi bloqueado." : "O usuário não foi desbloqueado.";
    var mensagemSucesso = valorAtivacao == "0" ? "Usuário bloqueado com sucesso." : "Usuário desbloqueado com sucesso.";
    
    Swal.fire({
      title: tituloMensagem,
      html: "<p style='text-align:justify'>" + textMensagem + "</p>",
      type: "question",
      showCancelButton: !0,
      confirmButtonText: "<i class='icofont icofont-checked'></i> SIM",
      confirmButtonClass: "btn btn-blue botao-confirmacao-swal",
      cancelButtonText: "<i class='fa fa-times'></i> Não",
      cancelButtonClass: "btn btn-danger ml-1 botao-negacao-swal",
      buttonsStyling: !1,
    }).then(function(retornoComando) {
      if (retornoComando.value) {
        $.ajax({
          url: 'action/excluir_registro',
          type: 'post',
          dataType: 'html',
          data: {
            'opcaoExclusao': 'bloquear-usuario',
            'idRegistroExclusao': idUsuario,
            'valorAtivacao': valorAtivacao,
            'statusUsuario': $("#statusUsuario").val()
          }
        }).done(function(resultadoRetorno) {
          $('#dados_dousuarios').DataTable().destroy();
          $('#dados_dousuarios tbody').empty().append(resultadoRetorno);
          $('#dados_dousuarios').DataTable();
          swal(tituloMensagem, mensagemSucesso, "success");
        });
      }
    });

  }

  $("#statusUsuario").change(function() {
    $.ajax({
      url: 'filtros/filtrar_usuario',
      type: 'post',
      dataType: 'html',
      data: {
        'statusUsuario': this.value
      }
    }).done(function(resultadoRetorno) {
      $('#dados_dousuarios').DataTable().destroy();
      $('#dados_dousuarios tbody').empty().append(resultadoRetorno);
      $('#dados_dousuarios').DataTable();
    });
  })
</script>