<?php
session_start();
if (!isset($_SESSION['idUsuarioLogado'])) {
  header("location: ./");
}
include_once("header-clean.php");
require("../database/dbConection.php");

$dataHoje       = date("Y-m-d");
$idPerfilLogado = $_SESSION['idPerfilLogado'];
$idPacienteGet  = $_GET['idpac'];
$opcaoTela      = $_GET['op'];

$sqlPaciente  = "SELECT tb_paciente.*, TIMESTAMPDIFF(YEAR, datanasc, NOW()) AS idadePaciente, tb_cidades.nome_cidade FROM tb_paciente INNER JOIN tb_cidades ON (tb_paciente.codigocidade=tb_cidades.codigoibge_cidade) WHERE tb_paciente.id_paciente='$idPacienteGet'";
$stmPaciente  = $rsConexao->prepare($sqlPaciente);
$stmPaciente->execute();
$rsPaciente    = $stmPaciente->fetch(PDO::FETCH_OBJ);

$idPaciente         = $rsPaciente->id_paciente;
$nomePaciente       = $rsPaciente->nome_paciente;
$idadePaciente      = $rsPaciente->idadePaciente;
$sexoPaciente       = $rsPaciente->sexo;
$cnsPaciente        = $rsPaciente->cns_paciente;
$cpfPaciente        = $rsPaciente->cpf_paciente;
$municipioPaciente  = $rsPaciente->nome_cidade;
$bairrroPaciente    = $rsPaciente->bairro_paciente;
$ibgeCidade          = $rsPaciente->codigocidade;


$idSolicitacao    = $_GET['idsol'];
$sqlSolicitacao  = "SELECT *, date_format(datahora_cadastro,'%d/%m/%Y - %H:%i') AS dataHoraSolicitacao, date_format(datahora_registroagendamento,'%d/%m/%Y - %H:%i') AS dataHoraRegistroAgendamento, date_format(dataprazo_retirada,'%d/%m/%Y') AS dataPrevisaoRetirada, reg_tb_solicitacoes.origem_agendamento, reg_tb_procedimento.nome_procedimento, reg_tb_procedimento.observacao_procedimento, reg_tb_solicitacoes.id_statussolicitacao FROM reg_tb_solicitacoes INNER JOIN reg_rl_statussolicitacao ON (reg_tb_solicitacoes.id_statussolicitacao=reg_rl_statussolicitacao.id_statussolicitacao) INNER JOIN reg_tb_procedimento ON (reg_tb_solicitacoes.id_procedimento=reg_tb_procedimento.id_procedimento) WHERE id_solicitacao='$idSolicitacao'";
$stmSolicitacao  = $rsConexao->prepare($sqlSolicitacao);
$stmSolicitacao->execute();
$rsSolicitacao  = $stmSolicitacao->fetch(PDO::FETCH_OBJ);

$numeroProtocolo        = $rsSolicitacao->numero_procotolo;
$tokenSolicitacao       = $rsSolicitacao->token_solicitacao;
$dataHoraSolicitacao    = $rsSolicitacao->dataHoraSolicitacao;
$nomeProcedimento       = $rsSolicitacao->nome_procedimento;
$observacoesSolicitacao = $rsSolicitacao->observacoes_solicitacao;

$dataHoraRegistro       = date("d/m/Y H:i");
$dataPrevisaoRetirada   = $rsSolicitacao->dataPrevisaoRetirada;
$validarDataRetirada    = $rsSolicitacao->dataprazo_retirada;
$origemAgendamento      = mb_strtoupper($rsSolicitacao->origem_agendamento);
$observacaoAgendamento  = $rsSolicitacao->observacao_agendamento;
$habilitaClassificacao  = $idPerfilLogado != "7" && $idPerfilLogado != "8"  ? " disabled" : "";
$observacoesAnalise     = mb_strtoupper($rsSolicitacao->observacoes_analise) == "<BR>" || $rsSolicitacao->observacoes_analise == "" ? "&nbsp;" : mb_strtoupper($rsSolicitacao->observacoes_analise);
$nomePortador           = mb_strtoupper($rsSolicitacao->nome_portador);
$documentoPortador      = mb_strtoupper($rsSolicitacao->documento_portador);
$telefonePortador       = mb_strtoupper($rsSolicitacao->telefone_portador);
$permitirImpressao      = $rsSolicitacao->id_statussolicitacao == 6 || $rsSolicitacao->id_statussolicitacao == 7 ? "display:inline" : "display:none";
$permitirSalvar         = $rsSolicitacao->id_statussolicitacao == 6 || $rsSolicitacao->id_statussolicitacao == 7 ? "disabled" : "";

$carroPoliclinica      = $rsSolicitacao->carro_policlinica;
$precisaAcompanhanete   = $rsSolicitacao->precisaacompanhante_policlinica;
$nomeAcompanhante       = mb_strtoupper($rsSolicitacao->nomeacompanhante_policlinica);
$documentoAcompanhante  = mb_strtoupper($rsSolicitacao->documentoacompanhante_policlinica);
$maeAcompanhante        = mb_strtoupper($rsSolicitacao->maeacompanhante_policlinica);
$nascimentoAcompanhante = mb_strtoupper($rsSolicitacao->nascimentocompanhante_policlinica);
$localPartidaTranspoete = mb_strtoupper($rsSolicitacao->localpartida_policlinica);

if (isset($_GET['idagdm'])) {
  $liberarBotao           = "";
} else {
  $liberarBotao           = " disabled";
}

$displayCarroPoliclinica  = $origemAgendamento == "POLICLÍNICA" ? " display:block;" : " display:none;";
$marginTopMarcacao        = $origemAgendamento == "POLICLÍNICA" ? "-40px" : "-20px";

?>

<div class="app-content content" style="background-color: #e1e9e7;">
  <div class="content-wrapper" style="padding: 10px;">
    <section id="ordering">
      <div class="row">
        <div class="col-12">
          <div class="card" style="border: gray 1px solid;" id="card-tela">
            <div class="card-header titulo-telas">
              <i class="icofont icofont-checked" style='margin-top:-15px !important'></i>&nbsp;Registrar Entrega de Marcação
              <a class="heading-elements-toggle"><i class="fa fa-ellipsis-v font-medium-3"></i></a>
              <div class="heading-elements">
                <ul class="list-inline mb-0" style="margin-top: -12px; color: #fff;">
                  <li>
                    <a data-action="collapse"><i class="ft-minus"></i></a>
                  </li>
                  <li>
                    <a data-action="expand"><i class="ft-maximize"></i></a>
                  </li>
                </ul>
              </div>
            </div>
            <div class="card-content collapse show">
              <div class="card-body novo-padding-cardbody">
                <div class="row">
                  <div class="col-md-12">
                    <div class="form-group">
                      <ul class="nav nav-tabs nav-topline">
                        <li class="nav-item">
                          <a class="nav-link active" id="base-dadosSolicitacao" data-toggle="tab" aria-controls="dadosSolicitacao" href="#dadosSolicitacao" aria-expanded="true"><b><i class='icofont icofont-edit'></i> DADOS DA SOLICITAÇÃO&nbsp;&nbsp;</b></a>
                        </li>
                        <li class="nav-item">
                          <a class="nav-link" id="base-documentosAnexos" data-toggle="tab" aria-controls="documentosAnexos" href="#documentosAnexos" aria-expanded="true"><b><i class='icofont icofont-files'></i> DOCUMENTOS ANEXOS DA SOLICITAÇÃO&nbsp;&nbsp;</b></a>
                        </li>
                      </ul>
                      <div class="tab-content px-1 pt-1 border-grey border-lighten-2 border-0-top">
                        <div role="tabpanel" class="tab-pane active" id="dadosSolicitacao" aria-expanded="true" aria-labelledby="base-dadosSolicitacao">
                          <form class="form" style='margin-top:-10px'>
                            <div class="form-body">
                              <h4 class="form-section"><i class="ft-user"></i><b>Informações do paciente</b>
                                <input type="hidden" id="idPaciente" value="<?php echo $idPaciente; ?>" disabled />
                                <input type="hidden" id="idSolicitacao" value="<?php echo $idSolicitacao; ?>" />
                                <input type="hidden" id="tokenSolicitacao" value="<?php echo $tokenSolicitacao; ?>" disabled />
                              </h4>
                              <div class="row" style="margin-top: -10px;">
                                <div class="col-md-6">
                                  <div class="form-group">
                                    <label for="nomePaciente">Nome:</label>
                                    <input type="text" id="nomePaciente" class="form-control" value="<?php echo $nomePaciente; ?>" disabled />
                                  </div>
                                </div>
                                <div class="col-md-3">
                                  <div class="form-group">
                                    <label for="cpfPaciente">CPF:</label>
                                    <input type="text" id="cpfPaciente" class="form-control text-center cpf-inputmask" value="<?php echo $cpfPaciente; ?>" disabled />
                                  </div>
                                </div>
                                <div class="col-md-3">
                                  <div class="form-group">
                                    <label for="cnsPaciente">Cartão SUS:</label>
                                    <input type="text" id="cnsPaciente" class="form-control text-center" value="<?php echo $cnsPaciente; ?>" disabled />
                                  </div>
                                </div>
                              </div>
                            </div>
                            <div class="form-body" style="margin-top: -15px;">
                              <h4 class="form-section"><i class="icofont icofont-architecture-alt"></i><b>Informações da Solicitação</b></h4>
                              <div class="row" style="margin-top: -10px;">
                                <div class="col-md-3">
                                  <div class="form-group">
                                    <label for="dataSolicitacao">Data Hora Solicitação:</label>
                                    <input type="text" class="form-control text-center" id="dataSolicitacao" value="<?php echo $dataHoraSolicitacao; ?>" disabled />
                                  </div>
                                </div>
                                <div class="col-md-2">
                                  <div class="form-group">
                                    <label for="numeroProtocolo">Nº Protocolo:</label>
                                    <input type="text" class="form-control text-center" id="numeroProtocolo" value="<?php echo $numeroProtocolo; ?>" disabled />
                                  </div>
                                </div>
                                <div class="col-md-7">
                                  <div class="form-group">
                                    <label for="nomeProcedimento">Nome do Procedimento:</label>
                                    <input type="text" id="nomeProcedimento" class="form-control" value="<?php echo $nomeProcedimento; ?>" disabled />
                                  </div>
                                </div>
                              </div>
                              <div class="row" style='margin-top:-15px'>
                                <div class="col-md-12">
                                  <div class="form-group">
                                    <label for="observacaoSolicitacao">Observações da Solicitação:</label>
                                    <input type="text" id="observacaoSolicitacao" class="form-control" value="<?php echo $observacoesSolicitacao; ?>" disabled />
                                  </div>
                                </div>
                              </div>
                              <div class="row" style='margin-top:-15px'>
                                <div class="col-md-12">
                                  <div class="form-group">
                                    <label for="observacoesAnalise">Observações da Análise:</label>
                                    <label class='label-observacoes' style='padding: 10px'><?php echo $observacoesAnalise ?></label>
                                  </div>
                                </div>
                              </div>
                              <div class="row" style='margin-top:-25px'>
                                <div class="col-md-12">
                                  <div class="form-group">
                                    <label for="observacaoAgendamento">Observações do Agendamento:</label>
                                    <label class='label-observacoes' style='padding: 10px'><?php echo $observacaoAgendamento ?></label>
                                  </div>
                                </div>
                              </div>
                              <div class="form-body" style="background-color:#d2e2e9; border: 1px dotted #8c9ca3; margin-top:-20px">
                                <h4 class="form-section"><i class="icofont icofont-checked"></i><b>Dados do Agendamento</b></h4>
                                <div class="row" style="margin-top: -10px; padding-left:10px; padding-right:10px">
                                  <div class="col-md-3">
                                    <div class="form-group">
                                      <label for="dataHoraRegistro"><b>Data/Hora Registro:</b></label>
                                      <input type='text' class="form-control text-center" id="dataHoraRegistro" value="<?php echo $dataHoraRegistro; ?>" disabled>
                                    </div>
                                  </div>
                                  <div class="col-md-3">
                                    <div class="form-group">
                                      <label for="nomePortador"><b>Nome Protador:</b></label>
                                      <input type='text' class="form-control" id="nomePortador" value="<?php echo $nomePortador; ?>">
                                    </div>
                                  </div>
                                  <div class="col-md-3">
                                    <div class="form-group">
                                      <label for="documentoPortador"><b>Documento:</b></label>
                                      <input type='text' class="form-control" id="documentoPortador" value="<?php echo $documentoPortador; ?>">
                                    </div>
                                  </div>
                                  <div class="col-md-3">
                                    <div class="form-group">
                                      <label for="telefonePortador"><b>Telefone Portador:</b></label>
                                      <input type='text' class="form-control text-center" id="telefonePortador" value="<?php echo $telefonePortador; ?>">
                                    </div>
                                  </div>
                                </div>
                                <!---------------------->
                                <div class="row" style="margin-top: -10px; <?php echo $displayCarroPoliclinica; ?>">
                                  <div class="col-md-12">
                                    <div class="form-group" style='padding-left:11px; padding-right:11px;'>
                                      <h4 class="form-section" style="background-color:#eff5f8;"><i class="icofont icofont-ambulance"></i><b>Informações para Transporte</b></h4>
                                      <div class="row" style="margin-top:-10px;">
                                        <div class="col-md-2">
                                          <div class="form-group">
                                            <label for="carroPoliclinica">Carro Policlínica:</label>
                                            <select id="carroPoliclinica" class="form-control">
                                              <option value=''>SELECIONE...</option>
                                              <option value='S'>SIM</option>
                                              <option value='N'>NÃO</option>
                                            </select>
                                          </div>
                                        </div>
                                        <div class="col-md-2">
                                          <div class="form-group">
                                            <label for="acompanhantePoliclinica">Acompanhante:</label>
                                            <select id="acompanhantePoliclinica" class="form-control" disabled>
                                              <option value=''>SELECIONE...</option>
                                              <option value='S'>SIM</option>
                                              <option value='N'>NÃO</option>
                                            </select>
                                          </div>
                                        </div>
                                        <div class="col-md-5">
                                          <div class="form-group">
                                            <label for="nomeAcompanhante">Nome do Acompanhante:</label>
                                            <input type="text" id="nomeAcompanhante" class="form-control" value="<?php echo $nomeAcompanhante; ?>" disabled>
                                          </div>
                                        </div>
                                        <div class="col-md-3">
                                          <div class="form-group">
                                            <label for="documentoAcompanhante">RG ou CPF:</label>
                                            <input type="text" id="documentoAcompanhante" class="form-control text-center" value="<?php echo $documentoAcompanhante; ?>" disabled>
                                          </div>
                                        </div>
                                      </div>
                                      <div class="row" style="margin-top: -10px;">
                                        <div class="col-md-5">
                                          <div class="form-group">
                                            <label for="maeAcompanhante">Nome da Mãe / Responsável:</label>
                                            <input type="text" id="maeAcompanhante" class="form-control" value="<?php echo $maeAcompanhante; ?>" disabled>
                                          </div>
                                        </div>
                                        <div class="col-md-3">
                                          <div class="form-group">
                                            <label for="dataNascimentoAcompanhanete">Data Nascimento:</label>
                                            <input type="date" id="dataNascimentoAcompanhanete" class="form-control text-center" value="<?php echo $nascimentoAcompanhante; ?>" disabled>
                                          </div>
                                        </div>
                                        <div class="col-md-4">
                                          <div class="form-group">
                                            <label for="localPartidaTransporte">Local de Partida:</label>
                                            <select id="localPartidaTransporte" class="form-control" disabled>
                                              <option value=''>SELECIONE...</option>
                                              <option value='AREIA-BRANCA'>AREIA BRANCA (POSTO DE SAÚDE ACR)</option>
                                              <option value='FINAL-LINHA'>FINAL DE LINHA DE LAURO</option>
                                              <option value='PASSARELA-FLORES'>PASSARELA DAS FLORES - (ANTIGO MAXXI)</option>
                                              <option value='PORTÃO'>PORTÃO</option>
                                              <option value='UPA-ITINGA'>UPA DE ITINGA</option>
                                            </select>
                                          </div>
                                        </div>
                                      </div>
                                    </div>
                                  </div>
                                </div>
                                <!---------------------->
                                <div class="row" style="margin-top:<?php echo $marginTopMarcacao; ?>; padding-left:10px; padding-right:10px">
                                  <div class="col-md-12">
                                    <div class="form-group">
                                      <?php
                                      if (mb_strtoupper($origemAgendamento) != "FILA-G") {
                                        echo "<table class='table table-striped table-bordered default-ordering table-responsive-xl2' id='documentos_agendados'>
                                          <thead>
                                            <tr>
                                              <th style='text-align: center !important;'>OPÇÕES</th>
                                              <th style='width: 200px; text-align:center'>DATA/HORA INCLUSÃO</th>
                                              <th style='width: 200px; text-align:center'>RETIRAR ATÉ</th>
                                              <th style='width: 200px;'>TIPO DE DOCUMENTO</th>
                                              <th>ORIGEM</th>
                                              <th style=''>AGENDADO POR</th>
                                            </tr>
                                          </thead>
                                          <tbody style='background-color: #ececec;'>";
                                        $numeracaoArquivo       = str_pad($idSolicitacao, 10, "0");
                                        $diretorioBaseAgendado  = "docagendamentos/";
                                        $sqlDocumentoAgendado = "SELECT reg_tb_solicitacoes_agendado.id_sca_documentoagendado, date_format(reg_tb_solicitacoes_agendado.datahora_inclusao,'%d/%m/%Y') AS dataInclusao, 
                                            date_format(reg_tb_solicitacoes_agendado.datahora_inclusao,'%H:%i') AS horaInclusao, reg_rl_tipodocumento.nome_tipodocumento, reg_tb_solicitacoes_agendado.pasta_documento, 
                                            reg_tb_solicitacoes_agendado.nomearquivo_documento, reg_tb_solicitacoes_agendado.id_tipodocumento, reg_tb_usuario.nome_usuario, tb_estabelecimento.nfantasia_estabelecimento
                                            FROM reg_tb_solicitacoes_agendado 
                                            INNER JOIN reg_rl_tipodocumento ON (reg_tb_solicitacoes_agendado.id_tipodocumento = reg_rl_tipodocumento.id_tipodocumento) 
                                            INNER JOIN reg_tb_usuario ON (reg_tb_solicitacoes_agendado.id_usuario_cadastrou = reg_tb_usuario.id_usuario) 
                                            INNER JOIN tb_estabelecimento ON (reg_tb_solicitacoes_agendado.id_unidade_cadastrou = tb_estabelecimento.codigoestabelecimento_cnes) 
                                            WHERE id_sca_solicitacao='$idSolicitacao'";

                                        $stmDocumentoAgendado = $rsConexao->prepare($sqlDocumentoAgendado);
                                        $stmDocumentoAgendado->execute();

                                        if ($stmDocumentoAgendado->rowCount() > 0) {
                                          $rsDocumentoAgendado  = $stmDocumentoAgendado->fetchAll(PDO::FETCH_ASSOC);
                                          $contarDocsAgendado   = 0;
                                          foreach ($rsDocumentoAgendado as $fieldDocumentoAgendado) {
                                            $contarDocsAgendado       = $contarDocsAgendado + 1;
                                            $idDocumentoAgendado      = $fieldDocumentoAgendado['id_sca_documentoagendado'];
                                            $dataHoraInclusaoAgendado = $fieldDocumentoAgendado['dataInclusao'] . ' ÀS ' . $fieldDocumentoAgendado['horaInclusao'];
                                            $tipoDocumentoAgendado    = $fieldDocumentoAgendado['nome_tipodocumento'];
                                            $idTipoDocumentoAgendado  = $fieldDocumentoAgendado['id_tipodocumento'];
                                            $pastaDocumentoAgendado   = $fieldDocumentoAgendado['pasta_documento'];
                                            $incluidoPor              = $fieldDocumentoAgendado['nome_usuario'] . "<br>(" . $fieldDocumentoAgendado['nfantasia_estabelecimento'] . ")";
                                            $nomeArquivoAgendado      = mb_strtoupper($fieldDocumentoAgendado['nomearquivo_documento']);

                                            $arquivoAnexoAgendado     = $diretorioBaseAgendado . $pastaDocumentoAgendado . "/$numeracaoArquivo" . "_" . $fieldDocumentoAgendado['nomearquivo_documento'];

                                            $cliqueBotaoVisualizarDocumentoAg = 'onClick="window.open(' . "'$arquivoAnexoAgendado')" . '"';
                                            $botaoVisualizarDocumentoAgendado  = "<i id='imprimirMarcacao$contarDocsAgendado' class='icofont icofont-printer nova_fonte_blue' style='$permitirImpressao' title='Imprimir marcação.' $cliqueBotaoVisualizarDocumentoAg></i>";

                                            $cliqueBotaoQrCode  = 'onClick="window.open(' . "'imprimir_qrcode?idsol=$idSolicitacao&iddoc=$idDocumentoAgendado')" . '"';
                                            $botaoBotaoQrCode   = "<i id='imprimirQrCorde' class='icofont icofont-qr-code nova_fonte_confirma' style='$permitirImpressao' title='Imprimir comprovante QRCode.' $cliqueBotaoQrCode></i>";

                                            echo "<tr>
                                                  <td align='center'>
                                                    $botaoVisualizarDocumentoAgendado
                                                  </td>
                                                  <td style='width: 80px; text-align:center'>$dataHoraInclusaoAgendado</td>
                                                  <td style='width: 80px; text-align:center'>$dataPrevisaoRetirada</td>                                                  
                                                  <td style='width: 200px;'>$tipoDocumentoAgendado</td>
                                                  <td>$origemAgendamento</td>
                                                  <td style='font-size:7pt;'>$incluidoPor</td>
                                                </tr>";
                                          }
                                        }
                                        echo "</tbody>
                                          </table>";
                                      } else {
                                        echo "<table class='table table-striped table-bordered default-ordering table-responsive-xl2' id='documentos_agendados'>
                                          <thead>
                                            <tr>
                                              <th style='text-align: center !important; width:150px'>OPÇÕES</th>
                                              <th style='text-align:center' class='w-25'>DATA DO AGENDAMENTO</th>
                                              <th style='text-align:center' class='w-25'>RETIRAR ATÉ</th>
                                              <th style='' class='w-25'>AGENDADO POR</th>
                                            </tr>
                                          </thead>
                                          <tbody style='background-color: #ececec;'>";
                                        $sqlAgendamento = "SELECT reg_tb_agendamentos.id_agendamento, reg_tb_agendamentos.origem_agendamento,
                                            date_format(reg_tb_agendamentos.datahora_agendamento,'%d/%m/%Y %H:%i') AS dataAgendamento,
                                            date_format(reg_tb_agendamentos.data_atendimento,'%d/%m/%Y') AS dataAtendimento,
                                            date_format(reg_tb_agendamentos.dataprazo_retirada,'%d/%m/%Y') AS dataRetirada,
                                            reg_tb_usuario.nome_usuario
                                            FROM reg_tb_usuario
                                            INNER JOIN reg_tb_agendamentos ON (reg_tb_usuario.id_usuario = reg_tb_agendamentos.id_usuario_agendou)
                                            WHERE reg_tb_agendamentos.id_solicitacao='$idSolicitacao'";

                                        $stmAgendamento = $rsConexao->prepare($sqlAgendamento);
                                        $stmAgendamento->execute();
                                        $rsAgendamento  = $stmAgendamento->fetchAll(PDO::FETCH_ASSOC);
                                        foreach ($rsAgendamento as $fielAgendamento) {
                                          $_SESSION['idAgendamento']      = $fielAgendamento['id_agendamento'];
                                          $_SESSION['origemAgendamento']  = $fielAgendamento['origem_agendamento'];
                                          $dataAgendamento  = $fielAgendamento['dataAgendamento'];
                                          $dataAtendimento  = $fielAgendamento['dataAtendimento'];
                                          $dataRetirada     = $fielAgendamento['dataRetirada'];
                                          $AgendadoPor      = mb_strtoupper($fielAgendamento['nome_usuario']);
                                          $cliqueImprimirAgendamento = 'onClick="window.open(' . "'agendamento_verimpressao?viewheader=falseview')" . '"';
                                          $botaoImprimirAgendamento  = "<i id='imprimirMarcacaoFilaG' class='icofont icofont-printer nova_fonte_blue' title='Imprimir marcação.' style='$permitirImpressao' $cliqueImprimirAgendamento></i>";

                                          echo "<tr>
                                                <td align='center'>
                                                  $botaoImprimirAgendamento
                                                </td>
                                                <td align='center'>$dataAgendamento</td>
                                                <td align='center'>$dataRetirada</td>
                                                <td>$AgendadoPor</td>
                                              </tr>";
                                        }
                                        echo "</tbody>
                                          </table>";
                                      }
                                      ?>
                                    </div>
                                  </div>
                                </div>
                              </div><br>
                            </div>
                          </form>
                        </div>
                        <div class="tab-pane" id="documentosAnexos" aria-labelledby="base-documentosAnexos">
                          <div class="row">
                            <div class='col-md-12'>
                              <table class="table table-striped table-bordered default-ordering table-responsive-xl2" id="documentos_anexos" style='width:100%'>
                                <thead>
                                  <tr>
                                    <th style='text-align: center !important; width:80px'>OPÇÕES</th>
                                    <th style='display:none'>idtipodoc</th>
                                    <th style='width: 200px; text-align:center'>DATA/HORA INCLUSÃO</th>
                                    <th style='width: 250px;'>TIPO DE DOCUMENTO</th>
                                    <th>NOME DO ARQUIVO</th>
                                  </tr>
                                </thead>
                                <tbody style="background-color: #ececec;">
                                  <?php
                                  $diretorioBase      = "docsolicitacoes/";
                                  $diretorioData      = date("Ym");

                                  $sqlDocumento = "SELECT reg_tb_solicitacoes_anexos.id_sca_documentoanexo, date_format(reg_tb_solicitacoes_anexos.datahora_inclusao,'%d/%m/%Y') AS dataInclusao, date_format(reg_tb_solicitacoes_anexos.datahora_inclusao,'%H:%i') AS horaInclusao, reg_rl_tipodocumento.nome_tipodocumento, reg_tb_solicitacoes_anexos.pasta_documento, reg_tb_solicitacoes_anexos.nomearquivo_documento, reg_tb_solicitacoes_anexos.id_tipodocumento FROM reg_tb_solicitacoes_anexos INNER JOIN reg_rl_tipodocumento ON (reg_tb_solicitacoes_anexos.id_tipodocumento = reg_rl_tipodocumento.id_tipodocumento) 
                                    WHERE reg_tb_solicitacoes_anexos.id_sca_solicitacao='$idSolicitacao'";

                                  $stmDocumento = $rsConexao->prepare($sqlDocumento);
                                  $stmDocumento->execute();

                                  if ($stmDocumento->rowCount() > 0) {
                                    $rsDocumento  = $stmDocumento->fetchAll(PDO::FETCH_ASSOC);
                                    $contarDocs   = 0;
                                    foreach ($rsDocumento as $fieldDocumento) {
                                      $contarDocs       = $contarDocs + 1;
                                      $idDocumento      = $fieldDocumento['id_sca_documentoanexo'];
                                      $dataHoraInclusao = $fieldDocumento['dataInclusao'] . ' ÀS ' . $fieldDocumento['horaInclusao'];
                                      $tipoDocumento    = $fieldDocumento['nome_tipodocumento'];
                                      $idTipoDocumento  = $fieldDocumento['id_tipodocumento'];
                                      $pastaDocumento   = $fieldDocumento['pasta_documento'];
                                      $nomeArquivo      = mb_strtoupper($fieldDocumento['nomearquivo_documento']);

                                      $arquivoAnexo     = $nomePastaArquivo = $diretorioBase . $pastaDocumento . "/$tokenSolicitacao" . "_" . $fieldDocumento['nomearquivo_documento'];

                                      $cliqueBotaoVisualizarDocumento = 'onClick="window.open(' . "'$arquivoAnexo')" . '"';
                                      $botaoVisualizarDocumento  = "<i class='icofont icofont-search nova_fonte' title='Visualizar documento anexo.' $cliqueBotaoVisualizarDocumento></i>";;

                                      $cliqueBotaoExcluirAnexo = 'onClick="excluirAnexo(' . "'$idDocumento','../$arquivoAnexo','$tokenSolicitacao')" . '"';
                                      $botaoExcluirAnexo  = "<i class='icofont icofont icofont-close-squared nova_fonte_delete' title='Excluir documento.' $cliqueBotaoExcluirAnexo></i>";;

                                      echo "<tr>
                                          <td style='text-align: center !important; width:20px !important'>$botaoVisualizarDocumento</td>
                                          <td style='display:none' id='idTipoDoc$contarDocs'>$idTipoDocumento</td>
                                          <td style='width: 80px; text-align:center'>$dataHoraInclusao</td>
                                          <td style='width: 200px;'>$tipoDocumento</td>
                                          <td style='width: 60%;'>$nomeArquivo</td>
                                        </tr>";
                                    }
                                  }
                                  ?>
                                </tbody>
                              </table>
                            </div>
                          </div>
                        </div>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </section>
  </div>
</div>

<div class="barra-flutuante" style='margin-left:-150px'>
  <button type="button" class="btn btn-blue" onClick="gravarEntrega()" id='btnConfirmarEntrega' <?php echo $permitirSalvar; ?>>
    <i class="fa fa-check-square-o"></i> Confirmar
  </button>
  <button type="button" class="btn btn-danger" id="btnCancelar" onClick="window.close()"><i class="ft-log-out botaoOk"></i> Fechar</button>
</div>

<?php
include_once("footer.php");
?>

<script src="../app-assets/vendors/js/forms/extended/inputmask/jquery.inputmask.bundle.min.js"></script>
<script src="../app-assets/js/scripts/forms/extended/form-inputmask.min.js"></script>
<script src="../app-assets/vendors/js/tables/datatable/datatables.min.js"></script>
<script src="../app-assets/js/scripts/tables/datatables/datatable-basic.min.js"></script>
<script src="../app-assets/js/scripts/ui/jquery-ui/buttons-selects.min.js"></script>

<script>
  $("#liSolicitacaoEntregar").attr('class', 'active');
  $("#liSolicitacaoEntregar").css("border-bottom", "2px solid #c4c8ca");

  $('#documentos_agendados').DataTable({
    "paging": false,
    "filter": false,
    "lengthChange": false,
    "info": false
  });

  $('#documentos_anexos').DataTable({
    "paging": false,
    "filter": false,
    "lengthChange": false,
    "info": false
  });

  function gravarEntrega() {

    var totalAnexos = $("#documentos_agendados").dataTable().fnSettings().fnRecordsTotal();
    var origemAgendamento   = "<?php echo $origemAgendamento; ?>";

    if ($("#nomePortador").val() == "" || $("#documentoPortador").val() == "" || $("#telefonePortador").val() == "") {
      swal("Dados do Portador", "Os dados do portador são de preenchimento obrigatório.", "error");
      return false;
    }

    if (origemAgendamento == "POLICLÍNICA-XXX") {
      if ($("#carroPoliclinica").val() == "") {
        swal("Carro da Policlínica", "Você deve informar se o paciente precisará carro para a policlínica.", "error");
        return false;
      }
      if ($("#carroPoliclinica").val() == "S" && $("#acompanhantePoliclinica").val() == "") {
        swal("Dados do Acompanhante", "Você deve informar se o paciente precisará de acompanhanete.", "error");
        return false;
      }

      if ($("#acompanhantePoliclinica").val() == "S" && $("#nomeAcompanhante").val() == "" && $("#documentoAcompanhante").val() == "" && $("#maeAcompanhante").val() == "" && $("#dataNascimentoAcompanhanete").val() == "") {
        swal("Dados do Acompanhante", "Todos os dados do acompanhanete são obrigatórios", "error");
        return false;
      }

      if ($("#carroPoliclinica").val() == "S" && $("#localPartidaTransporte").val() == "") {
        swal("Local de Partida", "O preenchimento do local de partida é obrigatório.", "error");
        return false;
      }
    }

    $("#embacado").css("display", "block");

    $.ajax({
      url: 'action/gravar_solicitacao',
      type: 'post',
      dataType: 'html',
      data: {
        'opcaoGravacao': 'solicitacao-entregar-marcacao',
        'idSolicitacao': $("#idSolicitacao").val(),
        'nomePortador': $("#nomePortador").val(),
        'documentoPortador': $("#documentoPortador").val(),
        'telefonePortador': $("#telefonePortador").val(),
        'carroPoliclinica': $("#carroPoliclinica").val(),
        'acompanhantePoliclinica': $("#acompanhantePoliclinica").val(),
        'nomeAcompanhante': $("#nomeAcompanhante").val(),
        'documentoAcompanhante': $("#documentoAcompanhante").val(),
        'maeAcompanhante': $("#maeAcompanhante").val(),
        'dataNascimentoAcompanhanete': $("#dataNascimentoAcompanhanete").val(),
        'localPartidaTransporte': $("#localPartidaTransporte").val()
      }
    }).done(function(resultadoRetorno) {
      $("#btnCancelarSolicitacao").prop("disabled", true);
      $("#btnConfirmarEntrega").prop("disabled", true);
      $("#embacado").css("display", "none");
      swal("Entrega de Marcação", "Entrega de marcação registrado com sucesso. Pode realizar a impressão!", "success");      
      $("#imprimirMarcacaoFilaG").css("display", "block");

      for(contadorAnexos=1; contadorAnexos <= totalAnexos; contadorAnexos++){
        $("#imprimirMarcacao"+contadorAnexos).css("display", "block");
      }
      //$("#imprimirQrCorde").css("display", "block");
    });

  }

  $('#carroPoliclinica').change(function() {

    if (this.value == "S") {
      $("#acompanhantePoliclinica").prop("disabled", false);
      $("#nomeAcompanhante").prop("disabled", false);
      $("#documentoAcompanhante").prop("disabled", false);
      $("#maeAcompanhante").prop("disabled", false);
      $("#dataNascimentoAcompanhanete").prop("disabled", false);
      $("#localPartidaTransporte").prop("disabled", false);
    } else {
      $("#acompanhantePoliclinica").prop("disabled", true);
      $("#nomeAcompanhante").prop("disabled", true);
      $("#documentoAcompanhante").prop("disabled", true);
      $("#maeAcompanhante").prop("disabled", true);
      $("#dataNascimentoAcompanhanete").prop("disabled", true);
      $("#localPartidaTransporte").prop("disabled", true);
    }

    if (this.value == "N") {
      $("#acompanhantePoliclinica").val('');
      $("#nomeAcompanhante").val('');
      $("#documentoAcompanhante").val('');
      $("#maeAcompanhante").val('');
      $("#dataNascimentoAcompanhanete").val('');
      $("#localPartidaTransporte").val('');
    }

  });

  $("#carroPoliclinica").val("<?php echo $carroPoliclinica; ?>");
  $("#acompanhantePoliclinica").val("<?php echo $precisaAcompanhanete; ?>");
  $("#localPartidaTransporte").val("<?php echo $localPartidaTranspoete; ?>");
  $("#carroPoliclinica").trigger("change");

  $('#acompanhantePoliclinica').change(function() {
    if (this.value == 'S') {
      $("#nomeAcompanhante").prop("disabled", false);
      $("#documentoAcompanhante").prop("disabled", false);
      $("#maeAcompanhante").prop("disabled", false);
      $("#dataNascimentoAcompanhanete").prop("disabled", false);
    } else {
      $("#nomeAcompanhante").prop("disabled", true);
      $("#documentoAcompanhante").prop("disabled", true);
      $("#maeAcompanhante").prop("disabled", true);
      $("#dataNascimentoAcompanhanete").prop("disabled", true);
      $("#nomeAcompanhante").val("");
      $("#documentoAcompanhante").val("");
      $("#maeAcompanhante").val("");
      $("#dataNascimentoAcompanhanete").val("");
    }
  });
</script>