<?php
session_start();
if (!isset($_SESSION['idUsuarioLogado'])) {
  header("location: ./");
}
include_once("header-clean.php");
require("../database/dbConection.php");

$idPerfilLogado = $_SESSION['idPerfilLogado'];

$idPacienteGet  = $_GET['idpac'];
$opcaoTela      = $_GET['op'];

$sqlPaciente  = "SELECT tb_paciente.*, TIMESTAMPDIFF(YEAR, datanasc, NOW()) AS idadePaciente, tb_cidades.nome_cidade FROM tb_paciente INNER JOIN tb_cidades ON (tb_paciente.codigocidade=tb_cidades.codigoibge_cidade) WHERE tb_paciente.id_paciente='$idPacienteGet'";
$stmPaciente  = $rsConexao->prepare($sqlPaciente);
$stmPaciente->execute();
$rsPaciente    = $stmPaciente->fetch(PDO::FETCH_OBJ);

$idPaciente         = $rsPaciente->id_paciente;
$nomePaciente       = $rsPaciente->nome_paciente;
$idadePaciente      = $rsPaciente->idadePaciente;
$sexoPaciente       = $rsPaciente->sexo;
$cnsPaciente        = $rsPaciente->cns_paciente;
$cpfPaciente        = $rsPaciente->cpf_paciente;
$municipioPaciente  = $rsPaciente->nome_cidade;
$bairrroPaciente    = $rsPaciente->bairro_paciente;
$ibgeCidade          = $rsPaciente->codigocidade;

$formatarOrigem = array(
  'lista_unica'   => 'LISTA ÚNICA',
  'policlinica'   => 'POLICLÍNICA',
  'sisreg'        => 'SISREG',
  'sistema_vida'  => 'VIDA+'
);

$idSolicitacao    = $_GET['idsol'];
$sqlSolicitacao  = "SELECT *, date_format(reg_tb_solicitacoes.datahora_cadastro,'%d/%m/%Y - %H:%i') AS dataHoraSolicitacao, date_format(datahora_solicitoucancelamento,'%d/%m/%Y - %H:%i') AS dataHoraPedidoCancelamento,
  reg_tb_procedimento.nome_procedimento, reg_tb_usuario.nome_usuario AS quemSolicitouCancelamento, tb_estabelecimento.nfantasia_estabelecimento, date_format(dataprazo_retirada,'%d/%m/%Y') AS prazoRetirada, 
  reg_tb_solicitacoes.dataprazo_retirada,
  reg_tb_solicitacoes.origem_agendamento,
  date_format(datahora_solicitoucancelamento,'%d/%m/%Y às %H:%i') AS quandoSolicitouWhatsapp
  FROM reg_tb_solicitacoes 
  INNER JOIN reg_rl_statussolicitacao ON (reg_tb_solicitacoes.id_statussolicitacao=reg_rl_statussolicitacao.id_statussolicitacao) 
  INNER JOIN reg_tb_procedimento ON (reg_tb_solicitacoes.id_procedimento=reg_tb_procedimento.id_procedimento)
  LEFT OUTER JOIN reg_tb_usuario ON (reg_tb_solicitacoes.id_usuario_solicitoucancelamento=reg_tb_usuario.id_usuario)
  INNER JOIN tb_estabelecimento ON (tb_estabelecimento.codigoestabelecimento_cnes = reg_tb_solicitacoes.id_unidade_cadastrou)
  WHERE id_solicitacao='$idSolicitacao'";

  
$stmSolicitacao  = $rsConexao->prepare($sqlSolicitacao);
$stmSolicitacao->execute();
$rsSolicitacao  = $stmSolicitacao->fetch(PDO::FETCH_OBJ);

$numeroProtocolo            = $rsSolicitacao->numero_procotolo;
$tokenSolicitacao           = $rsSolicitacao->token_solicitacao;
$dataHoraSolicitacao        = $rsSolicitacao->dataHoraSolicitacao;
$dataHoraPedidoCancelamento = $rsSolicitacao->dataHoraPedidoCancelamento == "" ? "NÃO INFORMADO" : $rsSolicitacao->dataHoraPedidoCancelamento;
$nomeProcedimento           = $rsSolicitacao->nome_procedimento;
$idProcedimento             = $rsSolicitacao->id_procedimento;
$justificativaSolicitacaoCancelamento  = $rsSolicitacao->justificativa_solicitacaocancelamento;
$idStatusSolicitacaoAtual   = $rsSolicitacao->id_statussolicitacao;
$observacoesProcedimento    = $rsSolicitacao->observacao_procedimento;
$idClassificacaoRisco       = $rsSolicitacao->id_classificacaorisco;
$habilitaClassificacao      = $idPerfilLogado != "7" && $idPerfilLogado != "8" && $idPerfilLogado != "1"  ? " disabled" : "";
$observacoesAnalise         = $rsSolicitacao->observacoes_analise;

if ($rsSolicitacao->justificativa_solicitacaocancelamento != "SOLICITAÇÃO REALIZADA PELO WHATSAPP") {
  $quemSolicitouCancelamento  = $rsSolicitacao->quemSolicitouCancelamento == "" ? "NÃO INFORMADO" : $rsSolicitacao->quemSolicitouCancelamento . " (" . $rsSolicitacao->nfantasia_estabelecimento . ")";
} else {
  $quemSolicitouCancelamento = "$rsSolicitacao->usuario_solicitou | Nº Whatsapp: $rsSolicitacao->telefone_usuario_solicitou | em $rsSolicitacao->quandoSolicitouWhatsapp";
}

$prazoRetirada              = $rsSolicitacao->prazoRetirada;
$informacoesCancelamento    = $rsSolicitacao->informacoes_cancelamento;
if ($rsSolicitacao->prazoRetirada != "" && ($rsSolicitacao->dataprazo_retirada < date("Y-m-d"))) {
  $prazoVencido = "style='background-color:#860000; color: #fff'";
  $complementoJustificativaSolicitacao  = " - (PRAZO PARA RETIRADA VENCEU)";
} else {
  $prazoVencido = "";
  $complementoJustificativaSolicitacao  = "";
}
$origemAgendamento          = $rsSolicitacao->origem_agendamento;
$dataHoraRegistroCancelamento   = date("d/m/Y H:i");

if ($justificativaSolicitacaoCancelamento == "") {
  $mostrarJustificativaCancelamento =  " display:none";
  $mostrarNovaJusticiativa          =  "style='display:block'";
} else {
  $mostrarJustificativaCancelamento =  "";
  $mostrarNovaJusticiativa          =  "style='display:none'";
}

# -- pegar data do agendamentos -- 
if ($origemAgendamento != "") {
  $sqlAtendimento = "SELECT date_format(data_atendimento,'%d/%m/%Y') As dataAtendimento FROM reg_tb_agendamentos WHERE id_solicitacao='$idSolicitacao'";
  $stmAtendimento = $rsConexao->prepare($sqlAtendimento);
  $stmAtendimento->execute();
  $rsAtendimento    = $stmAtendimento->fetch(PDO::FETCH_OBJ);
  $dataAtendimento  = $rsAtendimento->dataAtendimento;
} else {
  $dataAtendimento  = "";
}

?>
<div class="app-content content" style="background-color: #e1e9e7;">
  <div class="content-wrapper" style="padding: 10px;">
    <section id="ordering">
      <div class="row">
        <div class="col-12">
          <div class="card" style="border: gray 1px solid;" id="card-tela">
            <div class="card-header titulo-telas">
              <i class="icofont icofont-close-squared-alt" style='margin-top:-15px !important'></i>&nbsp;Cancelar Solicitação
              <a class="heading-elements-toggle"><i class="fa fa-ellipsis-v font-medium-3"></i></a>
              <div class="heading-elements">
                <ul class="list-inline mb-0" style="margin-top: -12px; color: #fff;">
                  <li>
                    <a data-action="collapse"><i class="ft-minus"></i></a>
                  </li>
                  <li>
                    <a data-action="expand"><i class="ft-maximize"></i></a>
                  </li>
                </ul>
              </div>
            </div>
            <div class="card-content collapse show">
              <div class="card-body novo-padding-cardbody">
                <div class="row">
                  <div class="col-md-12">
                    <div class="form-group">
                      <ul class="nav nav-tabs nav-topline">
                        <li class="nav-item">
                          <a class="nav-link active" id="base-dadosSolicitacao" data-toggle="tab" aria-controls="dadosSolicitacao" href="#dadosSolicitacao" aria-expanded="true"><b><i class='icofont icofont-edit'></i> DADOS DA SOLICITAÇÃO&nbsp;&nbsp;</b></a>
                        </li>
                        <li class="nav-item">
                          <a class="nav-link" id="base-documentosAnexos" data-toggle="tab" aria-controls="documentosAnexos" href="#documentosAnexos" aria-expanded="true"><b><i class='icofont icofont-files'></i> DOCUMENTOS ANEXOS&nbsp;&nbsp;</b></a>
                        </li>
                      </ul>
                      <div class="tab-content px-1 pt-1 border-grey border-lighten-2 border-0-top">
                        <div role="tabpanel" class="tab-pane active" id="dadosSolicitacao" aria-expanded="true" aria-labelledby="base-dadosSolicitacao">
                          <form class="form">
                            <div class="form-body">
                              <h4 class="form-section"><i class="ft-user"></i><b>Informações do paciente</b>
                                <input type="hidden" id="idPaciente" value="<?php echo $idPaciente; ?>" disabled />
                                <input type="hidden" id="idSolicitacao" value="<?php echo $idSolicitacao; ?>" />
                                <input type="hidden" id="tokenSolicitacao" value="<?php echo $tokenSolicitacao; ?>" disabled />
                              </h4>
                              <div class="row" style="margin-top: -10px;">
                                <div class="col-md-6">
                                  <div class="form-group">
                                    <label for="nomePaciente">Nome:</label>
                                    <input type="text" id="nomePaciente" class="form-control" value="<?php echo $nomePaciente; ?>" disabled />
                                  </div>
                                </div>
                                <div class="col-md-3">
                                  <div class="form-group">
                                    <label for="cpfPaciente">CPF:</label>
                                    <input type="text" id="cpfPaciente" class="form-control text-center cpf-inputmask" value="<?php echo $cpfPaciente; ?>" disabled />
                                  </div>
                                </div>
                                <div class="col-md-3">
                                  <div class="form-group">
                                    <label for="cnsPaciente">Cartão SUS:</label>
                                    <input type="text" id="cnsPaciente" class="form-control text-center cns-inputmask" value="<?php echo $cnsPaciente; ?>" disabled />
                                  </div>
                                </div>
                              </div>
                            </div>
                            <div class="form-body" style="margin-top: -15px;">
                              <h4 class="form-section"><i class="icofont icofont-architecture-alt"></i><b>Informações da Solicitação</b></h4>
                              <div class="row" style="margin-top: -10px;">
                                <div class="col-md-3">
                                  <div class="form-group">
                                    <label for="dataSolicitacao">Data/Hora Solicitação:</label>
                                    <input type="text" class="form-control text-center" id="dataSolicitacao" value="<?php echo $dataHoraSolicitacao; ?>" disabled />
                                  </div>
                                </div>
                                <div class="col-md-2">
                                  <div class="form-group">
                                    <label for="numeroProtocolo">Nº Protocolo:</label>
                                    <input type="text" class="form-control text-center" id="numeroProtocolo" value="<?php echo $numeroProtocolo; ?>" disabled />
                                  </div>
                                </div>
                                <div class="col-md-5">
                                  <div class="form-group">
                                    <label for="nomeProcedimento">Nome de Procedimentos:</label>
                                    <input type="text" id="nomeProcedimento" class="form-control" value="<?php echo $nomeProcedimento; ?>" disabled />
                                  </div>
                                </div>
                                <div class="col-md-2">
                                  <div class="form-group">
                                    <label for="prazoRetirada">Prazo Retirada:</label>
                                    <input type="text" class="form-control text-center" id="prazoRetirada" value="<?php echo $prazoRetirada; ?>" <?php echo $prazoVencido; ?> disabled />
                                  </div>
                                </div>
                              </div>
                              <div class="form-body" style="background-color:#d2e2e9; margin-top:-10px">
                                <h4 class="form-section"><i class="icofont icofont-edit"></i><b>Dados do Cancelamento</b></h4>
                                <div class="row" style="margin-top: -10px; padding-left:10px; padding-right:10px">
                                  <div class="col-md-3">
                                    <div class="form-group">
                                      <label for="dataRegistroCancelamento"><b>Data/Hora do Registro:</b></label>
                                      <input type="text" id="dataRegistroCancelamento" class="form-control text-center" value="<?php echo $dataHoraRegistroCancelamento; ?>" disabled />
                                    </div>
                                  </div>
                                  <div class="col-md-3">
                                    <div class="form-group">
                                      <label for="dataHoraSolicitacaoCancelamento"><b>Data/Hora do Pedido:</b></label>
                                      <input type="text" id="dataHoraSolicitacaoCancelamento" class="form-control text-center" value="<?php echo $dataHoraPedidoCancelamento; ?>" disabled />
                                    </div>
                                  </div>
                                  <?php
                                  if ($origemAgendamento != "") {
                                  ?>
                                    <div class="col-md-3">
                                      <div class="form-group">
                                        <label for="dataAtendimento"><b>Data do Atendimento:</b></label>
                                        <input type="text" id="dataAtendimento" class="form-control form-control-novodisabled text-center" value="<?php echo $dataAtendimento; ?>" disabled />
                                      </div>
                                    </div>
                                    <div class="col-md-3">
                                      <div class="form-group">
                                        <label for="origemAgendamento"><b>Origem do Agendamento:</b></label>
                                        <input type="text" id="origemAgendamento" class="form-control text-center" value="<?php echo $origemAgendamento; ?>" disabled />
                                      </div>
                                    </div>
                                  <?php 
                                    }else{
                                      echo '<div class="col-md-6">
                                      <div class="form-group">
                                        <label for="dataAtendimento"><b>Data do Atendimento:</b></label>
                                        <input type="text" id="dataAtendimento" class="form-control form-control-novodisabled" value="SOLICITAÇÃO SEM AGENDAMENTO REGISTRADO" disabled />
                                      </div>
                                    </div>';
                                    }
                                  ?>
                                </div>
                                <div class="row" style="margin-top: -10px; padding-left:10px; padding-right:10px">
                                  <div class="col-md-12">
                                    <div class="form-group">
                                      <label for="quemSolicitouCancelamento"><b>Quem Solicitou/Registrou:</b></label>
                                      <input type="text" id="quemSolicitouCancelamento" class="form-control" value="<?php echo $quemSolicitouCancelamento; ?>" disabled />
                                    </div>
                                  </div>
                                </div>
                                <div class="row" style="margin-top: -10px; padding-left:10px; padding-right:10px">
                                  <div class="col-md-12">
                                    <div class="form-group">
                                      <label for="justificativaSolicitacaoCancelamento"><b>Justificativa da Solicitação de Cancelamento:</b></label>
                                      <label id="justificativaSolicitacaoCancelamento" class='form-control label-observacoes' style="margin-top:-5px;"><?php echo $justificativaSolicitacaoCancelamento . $complementoJustificativaSolicitacao; ?></label>
                                    </div>
                                  </div>
                                </div>
                                <div class="row" style="margin-top: -10px; padding-left:10px; padding-right:10px">
                                  <div class="col-md-12">
                                    <div class="form-group">
                                      <label for="informacoesCancelamento"><b>Informações sobre o Cancelamento:</b></label>
                                      <textarea id="informacoesCancelamento" class="form-control" rows='3'><?php echo $informacoesCancelamento; ?></textarea>
                                    </div>
                                  </div>
                                </div>
                              </div><br>
                            </div>
                          </form>
                        </div>
                        <div class="tab-pane" id="documentosAnexos" aria-labelledby="base-documentosAnexos">
                          <div class="row" style="margin-top:-10px !important">
                            <div class='col-md-12'>
                              <div class="bs-callout-warning callout-square callout-bordered mt-1">
                                <div class="media align-items-stretch">
                                  <div class="media-left d-flex align-items-center bg-warning p-2" style='padding:7px !important;'>
                                    <i class="icofont icofont-exclamation-tringle white font-medium-5"></i>
                                  </div>
                                  <div class="media-body p-1" style='padding:7px !important; padding-left:10px !important'>
                                    <strong>ATENÇÃO!</strong> <b>São aceitos pelo sistema apenas arquivos em formado PDF. Arquivos aleatórios anexados à solicitação impedirá a realização do agendamento do paciente. Possíveis questionamentos do paciente ou ouvidoria serão direcionados ao responsável pelo registro da solicitação.</b>
                                  </div>
                                </div>
                              </div>
                            </div>
                          </div>
                          <div class="row">
                            <div class='col-md-12'>
                              <table class="table table-striped table-bordered default-ordering table-responsive-xl2" id="documentos_anexos" style='width:100%'>
                                <thead>
                                  <tr>
                                    <th style='text-align: center !important; width:80px'>OPÇÕES</th>
                                    <th style='display:none'>idtipodoc</th>
                                    <th style='width: 200px; text-align:center'>DATA/HORA INCLUSÃO</th>
                                    <th style='width: 250px;'>TIPO DE DOCUMENTO</th>
                                    <th>NOME DO ARQUIVO</th>
                                  </tr>
                                </thead>
                                <tbody style="background-color: #ececec;">
                                  <?php
                                  $diretorioBase  = "docsolicitacoes/";
                                  $diretorioData  = date("Ym");;
                                  $sqlDocumento = "SELECT reg_tb_solicitacoes_anexos.id_sca_documentoanexo, date_format(reg_tb_solicitacoes_anexos.datahora_inclusao,'%d/%m/%Y') AS dataInclusao, 
                                    date_format(reg_tb_solicitacoes_anexos.datahora_inclusao,'%H:%i') AS horaInclusao, reg_rl_tipodocumento.nome_tipodocumento, 
                                    reg_tb_solicitacoes_anexos.pasta_documento, reg_tb_solicitacoes_anexos.nomearquivo_documento, reg_tb_solicitacoes_anexos.id_tipodocumento 
                                    FROM reg_tb_solicitacoes_anexos INNER JOIN reg_rl_tipodocumento ON (reg_tb_solicitacoes_anexos.id_tipodocumento = reg_rl_tipodocumento.id_tipodocumento) 
                                    WHERE reg_tb_solicitacoes_anexos.id_sca_solicitacao='$idSolicitacao'";

                                  $stmDocumento = $rsConexao->prepare($sqlDocumento);
                                  $stmDocumento->execute();

                                  if ($stmDocumento->rowCount() > 0) {
                                    $rsDocumento  = $stmDocumento->fetchAll(PDO::FETCH_ASSOC);
                                    $contarDocs   = 0;
                                    foreach ($rsDocumento as $fieldDocumento) {
                                      $contarDocs       = $contarDocs + 1;
                                      $idDocumento      = $fieldDocumento['id_sca_documentoanexo'];
                                      $dataHoraInclusao = $fieldDocumento['dataInclusao'] . ' ÀS ' . $fieldDocumento['horaInclusao'];
                                      $tipoDocumento    = $fieldDocumento['nome_tipodocumento'];
                                      $idTipoDocumento  = $fieldDocumento['id_tipodocumento'];
                                      $pastaDocumento   = $fieldDocumento['pasta_documento'];
                                      $nomeArquivo      = mb_strtoupper($fieldDocumento['nomearquivo_documento']);

                                      $arquivoAnexo     = $nomePastaArquivo = $diretorioBase . $pastaDocumento . "/$tokenSolicitacao" . "_" . $fieldDocumento['nomearquivo_documento'];

                                      $cliqueBotaoVisualizarDocumento = 'onClick="window.open(' . "'$arquivoAnexo')" . '"';
                                      $botaoVisualizarDocumento  = "<i class='icofont icofont-search nova_fonte' title='Visualizar documento anexo.' $cliqueBotaoVisualizarDocumento></i>";;

                                      $cliqueBotaoExcluirAnexo = 'onClick="excluirAnexo(' . "'$idDocumento','../$arquivoAnexo','$tokenSolicitacao')" . '"';
                                      $botaoExcluirAnexo  = "<i class='icofont icofont icofont-close-squared nova_fonte_delete' title='Excluir documento.' $cliqueBotaoExcluirAnexo></i>";;

                                      echo "<tr>
                                          <td style='text-align: center !important; width:20px !important'>$botaoVisualizarDocumento</td>
                                          <td style='display:none' id='idTipoDoc$contarDocs'>$idTipoDocumento</td>
                                          <td style='width: 80px; text-align:center'>$dataHoraInclusao</td>
                                          <td style='width: 200px;'>$tipoDocumento</td>
                                          <td style='width: 60%;'>$nomeArquivo</td>
                                        </tr>";
                                    }
                                  }
                                  ?>
                                </tbody>
                              </table>
                            </div>
                          </div>
                        </div>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </section>
  </div>
</div>

<div class="barra-flutuante">
  <button type="button" class="btn btn-blue" onClick="cancelarSolicitacao()"><i class="fa fa-check-square-o"></i> Confirmar</button>
  <button type="button" class="btn btn-danger" id="btnCancelar" onClick="window.close()"><i class="ft-log-out botaoOk"></i> Fechar</button>
</div>

<?php
include_once("footer.php");
?>

<script src="../app-assets/vendors/js/forms/extended/inputmask/jquery.inputmask.bundle.min.js"></script>
<script src="../app-assets/js/scripts/forms/extended/form-inputmask.min.js"></script>
<script src="../app-assets/vendors/js/tables/datatable/datatables.min.js"></script>
<script src="../app-assets/js/scripts/tables/datatables/datatable-basic.min.js"></script>
<script src="../app-assets/js/scripts/ui/jquery-ui/buttons-selects.min.js"></script>

<script>
  $("#liSolicitacaoConsultar").attr('class', 'active');
  $("#liSolicitacaoConsultar").css("border-bottom", "2px solid #c4c8ca");

  $('#documentos_anexos').DataTable({
    "paging": false,
    "filter": false,
    "lengthChange": false,
    "info": false
  });


  function cancelarSolicitacao() {

    Swal.fire({
      title: "Cancelar Solicitação",
      html: "<p style='text-align:justify'><font style='font-weight: bold; color: #a00404ff;'>ATENÇÃO!</b></font> Ao cancelar esta solicitação não será possível a impressão de guia de atendimento ou protocolo de solicitação. Confirma?</p>",
      type: "question",
      showCancelButton: !0,
      confirmButtonText: "<i class='icofont icofont-checked'></i> SIM",
      confirmButtonClass: "btn btn-blue botao-confirmacao-swal",
      cancelButtonText: "<i class='fa fa-times'></i> Não",
      cancelButtonClass: "btn btn-danger ml-1 botao-negacao-swal",
      buttonsStyling: !1,
    }).then(function(retornoComando) {
      if (retornoComando.value) {
        $("#embacado").css("display", "block");
        $.ajax({
          url: 'action/gravar_solicitacao',
          type: 'post',
          dataType: 'html',
          data: {
            'opcaoGravacao': 'solicitacao-confirmar-cancelamento',
            'idSolicitacao': $("#idSolicitacao").val(),
            'dataRegistroCancelamento': $("#dataRegistroCancelamento").val(),
            'informacoesCancelamento': $("#informacoesCancelamento").val()
          }
        }).done(function(resultadoRetorno) {
          $("#embacado").css("display", "none");
          swal("Cancelamento de Solicitação", "Solicitação cancelada com sucesso!", "success");
          setTimeout(function() {
            window.close();
          }, 3000);
        });
      }
    });

  }
</script>