<?php
session_start();
if (!isset($_SESSION['idUsuarioLogado']) || ($_SESSION['idPerfilLogado'] != 1 && $_SESSION['idPerfilLogado'] != 4)) {
  header("location: ../sair.php");
}
require("../../database/dbConection.php");
$idUsuarioLogado    = $_SESSION['idUsuarioLogado'];
$nomeUsuarioLogado  = $_SESSION['nomeUsuarioLogado'];
$dataHoje           = date("d/m/Y");
$totalProcedimentos = 0;

$authorizationID      = explode("##",base64_decode($_GET['authorization']));
$autorizacaoAprovada  = $_GET['authorization'];
$explodeDataAgenda    = explode("/",$authorizationID[1]);
$dataAgenda           = $explodeDataAgenda[2].'-'.$explodeDataAgenda[1].'-'.$explodeDataAgenda[0];

ob_start();

echo "<table class='tabela-dados-relatorio'>
  <thead>
  <tr>
    <th style='text-align:left; width:35%; padding-left:5px'>NOME DO PROCEDIMENTO</th>
    <th style='text-align:left; width:250px !important; text-align:center;'>VAGAS DISPONÍVEIS</th>
    <th style='text-align:left; text-align:left;padding-left:5px'>UNIDADE EXECUTANTE</th>
    <th style='text-align:left; text-align:left;padding-left:5px'>PROFISSIONAL EXECUTANTE</th>
  </tr>
  </thead>
<tbody>";

$dataHoje = date('Y-m-d');
$sqlVagas = "SELECT date_format(CONCAT(reg_tb_agenda_sub.ano_agenda,'-',reg_tb_agenda_sub.mes_agenda,'-',LPAD(reg_tb_agenda_sub.dia_agenda, 2, '0')),'%d/%m/%Y') AS dataVaga,
date_format(CONCAT(reg_tb_agenda_sub.ano_agenda,'-',reg_tb_agenda_sub.mes_agenda,'-',LPAD(reg_tb_agenda_sub.dia_agenda, 2, '0')),'%Y-%m-%d') AS dataVagaReferencia,
reg_tb_procedimento.id_procedimento,
reg_tb_procedimento.nome_procedimento,
SUM(reg_tb_agenda_sub.quantidadevagas_pvez)- SUM(reg_tb_agenda_sub.quantidadegendada_pvez)AS saldoVagas,
UCASE(tb_estabelecimento.nfantasia_estabelecimento) AS nomeEstabelecimento,
UCASE(tb_profissional.nome_profissional) AS nomeProfissional,
DATEDIFF(date_format(CONCAT(reg_tb_agenda_sub.ano_agenda,'-',reg_tb_agenda_sub.mes_agenda,'-',LPAD(reg_tb_agenda_sub.dia_agenda, 2, '0')),'%Y-%m-%d'),CURDATE()) AS diasRestantes
FROM reg_tb_agenda
INNER JOIN tb_estabelecimento ON (reg_tb_agenda.codigoestabelecimento_cnes = tb_estabelecimento.codigoestabelecimento_cnes)
INNER JOIN reg_tb_procedimento ON (reg_tb_agenda.id_procedimento = reg_tb_procedimento.id_procedimento)
INNER JOIN reg_tb_agenda_sub ON (reg_tb_agenda_sub.id_agenda = reg_tb_agenda.id_agenda)
INNER JOIN tb_profissional ON (reg_tb_agenda.codigoprofissional_cnes = tb_profissional.codigoprofissional_cnes)
AND (reg_tb_agenda_sub.status_agenda='A')
AND (reg_tb_agenda.status_agenda='A')
AND (reg_tb_agenda_sub.profissional_afastado = 'N')
AND (reg_tb_agenda_sub.unidade_afastada = 'N')
AND (reg_tb_agenda_sub.quantidadevagas_pvez IS NOT NULL and reg_tb_agenda_sub.quantidadevagas_pvez!='')
GROUP BY 
reg_tb_agenda_sub.mes_agenda,
reg_tb_agenda_sub.ano_agenda,
reg_tb_agenda_sub.dia_agenda,
reg_tb_agenda_sub.id_procedimento,
tb_estabelecimento.nfantasia_estabelecimento,
tb_profissional.nome_profissional
HAVING (SUM(reg_tb_agenda_sub.quantidadevagas_pvez)-SUM(reg_tb_agenda_sub.quantidadegendada_pvez)>0 
AND CONCAT(reg_tb_agenda_sub.ano_agenda,'-',reg_tb_agenda_sub.mes_agenda,'-',LPAD(reg_tb_agenda_sub.dia_agenda, 2, '0'))='$dataAgenda') 
ORDER BY CONCAT(reg_tb_agenda_sub.ano_agenda,'-',reg_tb_agenda_sub.mes_agenda,'-',LPAD(reg_tb_agenda_sub.dia_agenda, 2, '0')),
reg_tb_procedimento.nome_procedimento,
tb_estabelecimento.nfantasia_estabelecimento,
tb_profissional.nome_profissional";
$stmlVagas  = $rsConexao->prepare($sqlVagas);
$stmlVagas->execute();


if ($stmlVagas->rowCount() > 0) {
  $totalVagasGrupo = 0;
  $headerDataVaga = "";
  $iniciarContagem        = -1;
  $rsVagas                = $stmlVagas->fetchAll(PDO::FETCH_ASSOC);
  foreach ($rsVagas as $fieldVagas) {
    if ($fieldVagas['dataVaga'] != $headerDataVaga) {
      $dataVaga           = $fieldVagas['dataVaga'];
      $headerDataVaga     = $dataVaga;
      $textoDiasExpirar   = "(DIAS RESTANTES PARA EXPIRAR: " . $fieldVagas['diasRestantes'] . ")";
      $diasRestantes      = $fieldVagas['diasRestantes'];
      $totalVagasGrupo    = ($totalVagasGrupo + $fieldVagas['saldoVagas']);
      $dataVagaReferencia = $fieldVagas['dataVagaReferencia'];
      $iniciarContagem  = $iniciarContagem + 1;
      if ($iniciarContagem != 0) {
        echo "<tr><td colspan='4' style='line-height:1px; font-size:1pt; padding-left:5px;'></td></tr>";
      }
      # -- totalizar vagas por data -- #
      $sqlTotalizaVagas = "SELECT SUM(reg_tb_agenda_sub.quantidadevagas_pvez)- SUM(reg_tb_agenda_sub.quantidadegendada_pvez) AS totalSaldoVagas
      FROM reg_tb_agenda 
      INNER JOIN reg_tb_procedimento ON (reg_tb_agenda.id_procedimento = reg_tb_procedimento.id_procedimento) 
      INNER JOIN reg_tb_agenda_sub ON (reg_tb_agenda_sub.id_agenda = reg_tb_agenda.id_agenda) 
      AND (reg_tb_agenda_sub.status_agenda='A') 
      AND (reg_tb_agenda.status_agenda='A') 
      AND (reg_tb_agenda_sub.profissional_afastado = 'N') 
      AND (reg_tb_agenda_sub.unidade_afastada = 'N') 
      AND (reg_tb_agenda_sub.quantidadevagas_pvez 
      IS NOT NULL and reg_tb_agenda_sub.quantidadevagas_pvez!='') 
      GROUP BY reg_tb_agenda_sub.mes_agenda, reg_tb_agenda_sub.ano_agenda, reg_tb_agenda_sub.dia_agenda
      HAVING (SUM(reg_tb_agenda_sub.quantidadevagas_pvez)-SUM(reg_tb_agenda_sub.quantidadegendada_pvez)>0 AND CONCAT(reg_tb_agenda_sub.ano_agenda,'-',reg_tb_agenda_sub.mes_agenda,'-',LPAD(reg_tb_agenda_sub.dia_agenda, 2, '0'))='$dataVagaReferencia')";

      $stmTotalizaVagas = $rsConexao->prepare($sqlTotalizaVagas);
      $stmTotalizaVagas->execute();
      $rsTotalizaVagas  = $stmTotalizaVagas->fetch(PDO::FETCH_OBJ);
      $totalSaldoVagas  = $rsTotalizaVagas->totalSaldoVagas;
      echo "<tr>                                                  
        <td colspan='4' style='line-height:17px; font-size:9pt; padding:5px; background-color: #e9e9e9;	color: #000;; border: 1px solid'>
          <b>DATA PARA ATENDIMENTO: $dataVaga -> 
            VAGAS DISPONÍVEIS: $totalSaldoVagas - $textoDiasExpirar
          </b>
        </td>       
      </tr>";
      $iniciarContagem = 0;
    }
    $nomeProcedimento     = $fieldVagas['nome_procedimento'];
    $nomeEstabelecimento  = $fieldVagas['nomeEstabelecimento'];
    $nomeProfissional     = $fieldVagas['nomeProfissional'];
    $quantidadeVagas      = $fieldVagas['saldoVagas'];
    echo "<tr>
      <td style='text-align:left; border: 1px solid'>$nomeProcedimento</td>
      <td style='text-align:center; border: 1px solid'>$quantidadeVagas</td>                                      
      <td style='border: 1px solid'>$nomeEstabelecimento</td>
      <td style='border: 1px solid'>$nomeProfissional</td>
    </tr>";
  }
} else {
  echo "<tr><td colspan='5' class='zero-registros-listados'>NENHUM REGISTRO ENCONTRAdO COM O CONJUNTO DE FILTROS SELECIONADOS</td></tr>";
}

echo "</tbody>
</table>";


//require_once __DIR__ . '../../../mpdf/autoload.php';
require_once __DIR__ . '../../../../lib_sistemas/mpdf8/vendor/autoload.php';
$mpdf = new \Mpdf\Mpdf([
  'mode' => 'utf-8',
  'format' => 'A4',
  'orientation' => 'L',
  'margin_header' => 10,
  'margin_top' => 30,
  'default_font' => 'tahoma'
]);

$html = ob_get_clean();
$mpdf->mirrorMargins = 1;
$stylesheet = file_get_contents('relatorio.css');
$mpdf->WriteHTML($stylesheet, 1);

$header = "
  <table align='center' class='tb_header'>
    <tr>
      <td class='logo-rel'>
        <img src='../css/images/logo-dark.png' height='50px'>
      </td>
		  <td class='titulo_relatorio' align='center' style='font-size:10pt'>
        RELATÓRIO DE VAGAS DISPONÍVEIS<br>
      </td>
      <td class='info-emissao-relatorio'>
        EMISSÃO : $dataHoje<br>
        IMPRESSO POR : $nomeUsuarioLogado<br>
      </td>
    </tr>
    </table>
	  <br>
  <div class='sub_titulo_rel'></div><br>";

$headerE = $header;
$footer = "Desenvolvido por: Expansão Tecnologia e Consultoria||Página : {PAGENO} de {nb}";
$footerE = $footer;

$mpdf->SetHTMLHeader($header);
$mpdf->SetHTMLHeader($headerE, 'E');
$mpdf->SetFooter($footer);
$mpdf->SetFooter($footerE, 'E');
$mpdf->SetTitle('Relatório de Vagas');
$mpdf->WriteHTML($html);
$mpdf->Output('RelatorioVagas.pdf', 'I');
exit;
