<?php
session_start();
require("../../database/dbConection.php");
$idUsuarioLogado    = $_SESSION['idUsuarioLogado'];
$nomeUsuarioLogado  = $_SESSION['nomeUsuarioLogado'];
$dataHoje           = date("d/m/Y");
$totalProcedimentos = 0;




ob_start();
/*
echo "<table class='tabela-cabecalho-filtro'>
  <tr><td>PROCEDIMENTO</td><td width='2px' align='center'>:</td><td>$periodoAnalisado</td></tr>
  <tr><td>BAIRRO SELECIONADO</td><td width='2px' align='center'>:</td><td>$bairroAnalisado</td></tr>
  <tr><td>SEXO SELECIONADO</td><td width='2px' align='center'>:</td><td>$sexoAnalisado</td></tr>
  <tr><td>PROCEDIMENTO SELECIONADO</td><td width='2px' align='center'>:</td><td>$procedimentoAnalisado</td></tr>
  <tr><td>STATUS SELECIONADO</td><td width='2px' align='center'>:</td><td>$statusAnalisado</td></tr>
  <tr><td>FAIXA ETÁRIA ANALISADA</td><td width='2px' align='center'>:</td><td>$faixaEtariaAnalisada</td></tr>
</table><br>";
*/

echo "<table class='tabela-dados-relatorio'>
<thead>
  <tr>
    <th scope='col' style='text-align: center' width='100px'>CÓDIGO</th>
    <th scope='col' style='text-align: left; padding-left:2px'>NOME DO PROCEDIMENTO</th>
    <th scope='col' style='text-align: center' width='100px'>VALOR UNITÁRIO</th>
    <th scope='col' style='text-align: center' width='100px'>QUANTIDADE REALIZADA</th>
    <th scope='col' style='text-align: center' width='100px'>VALOR EXECUTADO</th>
  </tr>
</thead>
<tbody>";
$sqlRelatorio = "SELECT 
reg_tb_procedimento.codigo_sus,
reg_tb_procedimento.nome_procedimento,
format(reg_tb_procedimento.valor_vigente, 2, 'de_DE') AS valorUnitario,
reg_tb_procedimento.valor_vigente,
COUNT(reg_zdados_relatorioproducao.id_registroproducao) AS quantidadeRealizada
FROM reg_zdados_relatorioproducao
INNER JOIN reg_tb_procedimento ON (reg_zdados_relatorioproducao.id_procedimento = reg_tb_procedimento.id_procedimento)
WHERE (reg_zdados_relatorioproducao.id_usuario_relatorio='$idUsuarioLogado')
GROUP BY reg_tb_procedimento.codigo_sus, reg_tb_procedimento.nome_procedimento
ORDER BY reg_tb_procedimento.nome_procedimento";
$stmRelatorio = $rsConexao->prepare($sqlRelatorio);
$stmRelatorio ->execute();  
$rsRelatorio  = $stmRelatorio->fetchAll(PDO::FETCH_ASSOC);

if($stmRelatorio->rowCount()>0){
  $valorTotalExecutado  = 0;
  foreach($rsRelatorio as $fieldRelatorio){
    $codigoProcedimento   = $fieldRelatorio['codigo_sus'];
    $nomeProcedimento     = $fieldRelatorio['nome_procedimento'];
    $valorUnitario        = $fieldRelatorio['valorUnitario'];
    $valorVigente         = $fieldRelatorio['valor_vigente'];
    $quantidadeRealizada  = $fieldRelatorio['quantidadeRealizada'];
    $valorExecutado       = number_format($valorVigente*$quantidadeRealizada,2,',','.');
    $valorTotalExecutado  = $valorTotalExecutado + ($valorVigente*$quantidadeRealizada);
    echo "<tr>
      <td align='center'>$codigoProcedimento</td>
      <td>$nomeProcedimento</td>
      <td align='right'>$valorUnitario</td>
      <td align='center'>$quantidadeRealizada</td>
      <td align='right'>$valorExecutado</td>
    </tr>";

  }
  $valorTotalExecutado  = number_format($valorTotalExecutado,2,',','.');
  echo "<tr>
    <td colspan='4' class='total-registros-listados'><b>VALOR TOTAL DA PRODUÇÃO:</b></td>
    <td class='total-registros-listados' align='right'><b>$valorTotalExecutado</b></td>
    </tr>";
}else{
  echo "<tr><td colspan='5' class='zero-registros-listados'>NENHUM REGISTRO ENCONTRAdO COM O CONJUNTO DE FILTROS SELECIONADOS</td></tr>";
}

echo "</tbody>
</table>";


//require_once __DIR__ . '../../../mpdf/autoload.php';
require_once __DIR__ . '../../../../lib_sistemas/mpdf8/vendor/autoload.php';
$mpdf = new \Mpdf\Mpdf([
  'mode' => 'utf-8',
  'format' => 'A4',
  'orientation' => 'L',
  'margin_header' => 15,  
  'margin_top' => 35,
  'default_font' => 'tahoma'
]);

$html = ob_get_clean();
$mpdf->mirrorMargins = 1;
$stylesheet = file_get_contents('relatorio.css');
$mpdf->WriteHTML($stylesheet,1);

$header = "
  <table align='center' class='tb_header'>
    <tr>
      <td class='logo-rel'>
        <img src='../css/images/logo-dark.png' height='50px'>
      </td>
		  <td class='titulo_relatorio' align='center' style='font-size:10pt'>
        RELATÓRIO DE PRODUÇÃO<br>
        SINTÉTICO
      </td>
      <td class='info-emissao-relatorio'>
        EMISSÃO : $dataHoje<br>
        IMPRESSO POR : $nomeUsuarioLogado<br>
      </td>
    </tr>
    </table>
	  <br>
  <div class='sub_titulo_rel'></div><br>";

$headerE = $header;
$footer = "Desenvolvido por: Expansão Tecnologia e Consultoria||Página : {PAGENO} de {nb}";
$footerE = $footer;

$mpdf->SetHTMLHeader($header);
$mpdf->SetHTMLHeader($headerE,'E');
$mpdf->SetFooter($footer);
$mpdf->SetFooter($footerE,'E');
$mpdf->SetTitle('Relatório de Produção - Sintético');
$mpdf->WriteHTML($html);
$mpdf->Output('RelatorioProducao.pdf','I');
exit;

?>