<?php
session_start();
require("../../database/dbConection.php");
$idUsuarioLogado    = $_SESSION['idUsuarioLogado'];
$nomeUsuarioLogado  = $_SESSION['nomeUsuarioLogado'];
$dataHoraImpressao  = date("d/m/Y H:i");

$totalRegistros           = 0;
$opcaoRelatorio           = $_SESSION['opcaoRelatorio'];
$subTituloFiltrosRelatorio = $_SESSION['periodoSelecionado'] . "<br>".$_SESSION['funcionarioSelecionado'];
ob_start();

switch($opcaoRelatorio){
  case "agendamentos":
    $tituloRelatorio      = "RELATÓRIO DE AGENDAMENTOS";
    $colunaUsuarioTitulo  = "QUEM AGENDOU";
  break;
  case "analises":
    $tituloRelatorio      = "RELATÓRIO DE ANÁLISES REALIZADAS";
    $colunaUsuarioTitulo  = "QUEM ANALISOU";
  break;
  case "cancelamentos":
    $tituloRelatorio      = "RELATÓRIO DE CANCELAMENTOS";
    $colunaUsuarioTitulo  = "QUEM CANCELOU";
  break;
  case "entregas":
    $tituloRelatorio      = "RELATÓRIO DE ENTREGAS DE MARCAÇÃO";
    $colunaUsuarioTitulo  = "QUEM ENTREGOU";
  break;
  case "solicitacoes":
    $tituloRelatorio      = "RELATÓRIO DE SOLICITAÇÕES";
    $colunaUsuarioTitulo  = "QUEM SOLICITOU";
  break;  
}

if($_SESSION['mostrarDadosPaciente']=="S"){
  $htmlTabelaRelatorio  = "<table class='tabela-dados-relatorio'>
  <thead>
    <tr>
      <th scope='col' style='text-align: left'>NOME DO PACIENTE</th>
      <th scope='col' style='text-align: center' width='80px'>CNS</th>
      <th scope='col' style='text-align: center' width='50px'>IDADE</th>
      <th scope='col' style='text-align: center' width='100px'>TELEFONES</th>
      <th scope='col' style='text-align: left'>PROCEDIMENTO</th>
      <th scope='col' style='text-align: left'>$colunaUsuarioTitulo</th>
    </tr>
  </thead>
  <tbody>";
  $sqlRelatorio = "SELECT nome_paciente, cns_paciente, idade_paciente, telefones_pacientes, nome_procedimento, nome_usuario_dados FROM reg_dados_relatorio WHERE id_usuario_relatorio='$idUsuarioLogado' ORDER BY  nome_paciente";
  $stmRelatorio   = $rsConexao->prepare($sqlRelatorio);
  $stmRelatorio   ->execute();  
  
  if($stmRelatorio->rowCount()>0){        
    $rsRelatorio  = $stmRelatorio->fetchAll(PDO::FETCH_ASSOC);
    foreach($rsRelatorio as $fieldRelatorio){
      $totalRegistros     = $totalRegistros+1;
      $nomePaciente       = mb_strtoupper($fieldRelatorio['nome_paciente']);
      $cnsPaciente        = $fieldRelatorio['cns_paciente'];
      $idadePaciente      = $fieldRelatorio['idade_paciente'];
      $telefonesPaciente  = str_replace(" | | ","",$fieldRelatorio['telefones_pacientes']);
      $telefonesPaciente  = str_replace("| |","",$telefonesPaciente);
      $nomeProcedimento   = mb_strtoupper($fieldRelatorio['nome_procedimento']);
      $colunaUsuarioDados = mb_strtoupper($fieldRelatorio['nome_usuario_dados']);
      $htmlTabelaRelatorio .= "<tr>
        <td>$nomePaciente</td>
        <td align='center'>$cnsPaciente</td>
        <td align='center'>$idadePaciente</td>
        <td align='center'>$telefonesPaciente</td>
        <td>$nomeProcedimento</td>
        <td>$colunaUsuarioDados</td>
      </tr>";
    }
    $htmlTabelaRelatorio .= "<tr>
      <td align='left' colspan='6' style='line-height: 25px; background:#e7e7e7; font-size:10pt'>TOTAL DE PROCEDIMENTOS: $totalRegistros</td>
    </tr>";
  }else{
    $htmlTabelaRelatorio .= "<tr>
      <td colspan='5' align='center'><b>NENHUM REGISTRO ENCONTRATO</b></td>
    </tr>";
  }
  $htmlTabelaRelatorio .= "</tbody>
    </table>";     

}else{
  $htmlTabelaRelatorio  = "<table class='tabela-dados-relatorio'>
  <thead>
    <tr>
      <th scope='col' style='text-align: left'>PROCEDIMENTO</th>
      <th scope='col' style='text-align: center' width='200px'>QUANTIDADE</th>
    </tr>
  </thead>
  <tbody>";    
  
  $sqlRelatorio = "SELECT reg_dados_relatorio.nome_procedimento, COUNT(reg_dados_relatorio.id_dados_relatorio) AS quantidadeProcedimentos
  FROM reg_dados_relatorio WHERE id_usuario_relatorio='$idUsuarioLogado' GROUP BY reg_dados_relatorio.nome_procedimento ORDER BY COUNT(reg_dados_relatorio.id_dados_relatorio) DESC";
  $stmRelatorio   = $rsConexao->prepare($sqlRelatorio);
  $stmRelatorio   ->execute();  
  
  if($stmRelatorio->rowCount()>0){        
    $rsRelatorio  = $stmRelatorio->fetchAll(PDO::FETCH_ASSOC);
    foreach($rsRelatorio as $fieldRelatorio){
      $nomeProcedimento       = mb_strtoupper($fieldRelatorio['nome_procedimento']);
      $quantidadeProcedimento = $fieldRelatorio['quantidadeProcedimentos'];
      $htmlTabelaRelatorio .= "<tr>
        <td>$nomeProcedimento</td>
        <td align='center'>$quantidadeProcedimento</td>
      </tr>";
      $totalRegistros = $totalRegistros + $quantidadeProcedimento;
    }
    $totalRegistros   = number_format($totalRegistros,0,",",".");
    $htmlTabelaRelatorio .= "<tr>
      <td align='left' colspan='2' style='line-height: 25px; background:#e7e7e7; font-size:10pt'>TOTAL DE PROCEDIMENTOS AGENDADOS: $totalRegistros</td>
    </tr>";
  }else{
    $htmlTabelaRelatorio .= "<tr>
      <td colspan='2' align='center'><b>NENHUM REGISTRO ENCONTRATO</b></td>
    </tr>";
  }
  $htmlTabelaRelatorio .= "</tbody>
    </table>";   

}

echo "<font style='font-size:9pt'><b>$subTituloFiltrosRelatorio</b></font><br><br>$htmlTabelaRelatorio";
//require_once('../../../lib_sistemas/mpdf8/autoload.php');
require_once ('../../../lib_sistemas/mpdf8/vendor/autoload.php'); // SERVIDOR
$mpdf = new \Mpdf\Mpdf([
  'mode' => 'utf-8',
  'format' => 'A4',
  'orientation' => 'L',
  'margin_header' => 15,  
  'margin_top' => 35,
  'default_font' => 'tahoma'
]);

$html = ob_get_clean();
$mpdf->mirrorMargins = 1;
$stylesheet = file_get_contents('relatorio.css');
$mpdf->WriteHTML($stylesheet,1);

$header = "
  <table align='center' class='tb_header'>
    <tr>
      <td class='logo-rel'>
        <img src='../css/images/logo-dark.png' height='50px'>
      </td>
		  <td class='titulo_relatorio' align='center' style='font-size:10pt'>
        SISTEMA DE CONTROLE DE AGENDAMENTOS<br>
        $tituloRelatorio
      </td>
      <td class='info-emissao-relatorio'>
        EMISSÃO : $dataHoraImpressao<br>
        IMPRESSO POR : $nomeUsuarioLogado<br>
      </td>
    </tr>
    </table>
	  <br>
  <div class='sub_titulo_rel'></div><br>";

$headerE = $header;
$footer = "<div>Desenvolvido por: Cláudio Magalhães||Página : {PAGENO} de {nb}";
$footerE = $footer;

$mpdf->SetHTMLHeader($header);
$mpdf->SetHTMLHeader($headerE,'E');
$mpdf->SetFooter($footer);
$mpdf->SetFooter($footerE,'E');
$mpdf->SetTitle('Relatório-gSaúde');
$mpdf->WriteHTML($html);
$mpdf->Output('Relatório-gSaúde.pdf','I');
exit;

?>