<?php
session_start();
require("../../database/dbConection.php");
$idUsuarioLogado    = $_SESSION['idUsuarioLogado'];
$nomeUsuarioLogado  = $_SESSION['nomeUsuarioLogado'];
$dataHoraImpressao  = date("d/m/Y H:i");
$dataHoje           = date("Y-m-d");

$formatarOrigem = array(
	'lista_unica'=>'LISTA ÚNICA',
	'policlinica'=>'POLICLÍNICA',
	'sisreg'=>'SISREG',
	'sistema_vida'=>'VIDA+',
);

$dataInicial  = $_GET['di'];
$dataFinal    = $_GET['df'];

ob_start();

echo "<table class='tabela-dados-relatorio'>
<thead>
  <tr>
    <th scope='col' style='text-align: center' width='80'>Nº SOICITAÇÃO</th>
    <th scope='col' style='text-align: center' width='80'>PRAZO RETIRADA</th>
    <th scope='col' style='text-align: left'>NOME DO PACIENTE</th>
    <th scope='col' style='text-align: center' width='90px'>CNS</th>    
    <th scope='col' style='text-align: left'>PROCEDIMENTO</th>
    <th style='text-align:center' width='80px'>ORIGEM</th>
    <th>OBSERVAÇÕES</th>
  </tr>
</thead>
<tbody>";

$sqlRelatorio = "SELECT reg_tb_agendamentos.numero_solicitacao, date_format(reg_tb_agendamentos.data_retirada,'%d/%m/%Y') AS dataRetirada, tb_paciente.nome_paciente, tb_paciente.cns_paciente, reg_tb_procedimento.nome_procedimento, tb_paciente.celular1,
tb_paciente.celular2, tb_paciente.celular3, reg_tb_agendamentos.origem_agendamento, reg_tb_agendamentos.observacoes_comunicacao,reg_tb_agendamentos.status_agendamento, reg_tb_agendamentos.observacoes_comunicacao, reg_tb_agendamentos.data_retirada FROM (reg_tb_agendamentos INNER JOIN tb_paciente ON (reg_tb_agendamentos.id_paciente = tb_paciente.id_paciente)) 
INNER JOIN reg_tb_procedimento ON (reg_tb_agendamentos.id_procedimento = reg_tb_procedimento.id_procedimento) WHERE (status_agendamento='Cancelar' OR 
(data_retirada<'$dataHoje' AND status_agendamento!='Entregue' AND status_agendamento!='Cancelado')) AND (reg_tb_agendamentos.data_retirada BETWEEN '$dataInicial'
AND '$dataFinal') ORDER BY reg_tb_agendamentos.data_retirada, tb_paciente.nome_paciente ASC";

$stmRelatorio   = $rsConexao->prepare($sqlRelatorio);
$stmRelatorio   ->execute();  
$rsRelatorio    = $stmRelatorio->fetchAll(PDO::FETCH_ASSOC);
$totalRegistros = $stmRelatorio->rowCount();		

if($totalRegistros>0){

  foreach($rsRelatorio as $fieldRelatorio){
    $numeroSolicitacao  = $fieldRelatorio['numero_solicitacao'];
    $dataRetirada       = $fieldRelatorio['dataRetirada'];
    $nomePaciente       = $fieldRelatorio['nome_paciente'];
    $cnsPaciente        = $fieldRelatorio['cns_paciente'];
    $nomeProcedimento   = $fieldRelatorio['nome_procedimento'];
    $dataretiradaEnc  	= $fieldRelatorio['data_retirada'];
    $origemAgendamento	= $formatarOrigem[$fieldRelatorio['origem_agendamento']];
    $obsAgendamento			= mb_strtoupper($fieldRelatorio['observacoes_comunicacao']);

    if($dataHoje>$dataretiradaEnc && $obsAgendamento==""){																		
      $obsAgendamento	= "PRAZO VENCIDO PARA RETIRADA.";
    }else{
      $obsAgendamento = $obsAgendamento;
    }

    $telefonesPaciente  = $fieldRelatorio['celular1'] . " | " . $fieldRelatorio['celular2'] . " | " . $fieldRelatorio['celular3'];
    echo "<tr>
      <td align='center'>$numeroSolicitacao</td>
      <td align='center'>$dataRetirada</td>
      <td>$nomePaciente</td>
      <td align='center'>$cnsPaciente</td>
      <td>$nomeProcedimento</td>
      <td>$origemAgendamento</td>
      <td>$obsAgendamento</td>
    </tr>";
  }

}

echo "</tbody>
</table>";


require_once __DIR__ . '../../../mpdf/autoload.php';
$mpdf = new \Mpdf\Mpdf([
  'mode' => 'utf-8',
  'format' => 'A4',
  'orientation' => 'L',
  'margin_header' => 15,  
  'margin_top' => 35,
  'default_font' => 'tahoma'
]);

$html = ob_get_clean();
$mpdf->mirrorMargins = 1;
$stylesheet = file_get_contents('relatorio.css');
$mpdf->WriteHTML($stylesheet,1);

$header = "
  <table align='center' class='tb_header'>
    <tr>
      <td class='logo-rel'>
        <img src='../css/images/logo-dark.png' height='50px'>
      </td>
		  <td class='titulo_relatorio' align='center' style='font-size:10pt'>
        CONTROLE DE AGENDAMENTOS<br>
        RELAÇÃO DE AGENDAMENTOS PARA CANCELAMENTO
      </td>
      <td class='info-emissao-relatorio'>
        EMISSÃO : $dataHoraImpressao<br>
        IMPRESSO POR : $nomeUsuarioLogado<br>
      </td>
    </tr>
    </table>
	  <br>
  <div class='sub_titulo_rel'></div><br>";

$headerE = $header;
$footer = "<div>Desenvolvido por: Cláudio Magalhães||Página : {PAGENO} de {nb}";
$footerE = $footer;

$mpdf->SetHTMLHeader($header);
$mpdf->SetHTMLHeader($headerE,'E');
$mpdf->SetFooter($footer);
$mpdf->SetFooter($footerE,'E');
$mpdf->SetTitle('Lista para Cancelamento');
$mpdf->WriteHTML($html);
$mpdf->Output('ListaCancelamento.pdf','I');
exit;
?>