<?php
session_start();
if (!isset($_SESSION['idUsuarioLogado'])) {
	header("location: ./");
}
$idPerfilLogado 	= $_SESSION['idPerfilLogado'];
$idUnidadeLogada	= $_SESSION['unidadeLogada'];
$setDisabled			= $idPerfilLogado == 13 ? " disabled" : "";

include_once("header.php");
?>
<div class="app-content content" style='background-color:#e1e9e7;'>
	<div class="content-wrapper" style='padding:10px;'>
		<section id="ordering">
			<div class="row">
				<div class="col-12">
					<div class="card" style='border:gray 1px solid;' id="card-tela">
						<div class="card-header titulo-telas">
							<i class="icofont icofont-file-text" style='margin-top:-15px !important'></i>&nbsp;Relatório de Produção
							<a class="heading-elements-toggle"><i class="fa fa-ellipsis-v font-medium-3"></i></a>
							<div class="heading-elements">
								<ul class="list-inline mb-0" style="margin-top: -12px; color: #fff;">
									<li>
										<a data-action="collapse"><i class="ft-minus"></i></a>
									</li>
									<li>
										<a data-action="expand"><i class="ft-maximize"></i></a>
									</li>
								</ul>
							</div>
						</div>
						<div class="card-content collapse show">
							<div class="card-body">
								<form class="form" style='margin-top:-10px'>
									<div class="form-body">
										<h4 class="form-section"><i class="icofont icofont-filter"></i> <b>Filtro de dados do relatório</b></h4>
										<div class="row" style='margin-top:-10px;'>
											<div class="col-md-5">
												<div class="form-group">
													<label for="unidadeSaude">Unidade Executante:</label>
													<select type="text" id="unidadeSaude" class="form-control" <?php echo $setDisabled; ?>>
														<option value=''>SELECIONE...</option>
														<?php
                            $sqlEstabelecimento = "SELECT * FROM tb_estabelecimento 
                            WHERE (status_estabelecimento='A')
                            AND (codigoestabelecimento_cnes!='9999999999999')
                            AND (perfil_estabelecimento IN('A','E'))
                            ORDER BY nfantasia_estabelecimento";
														$stmUnidadeSaude  = $rsConexao->prepare($sqlEstabelecimento);
														$stmUnidadeSaude->execute();
														if ($stmUnidadeSaude->rowcount() > 0) {
															$rsUnidadeSaude   = $stmUnidadeSaude->fetchAll(PDO::FETCH_ASSOC);
															foreach ($rsUnidadeSaude as $fieldUnidade) {
																$idUnidade    = $fieldUnidade['codigoestabelecimento_cnes'];
																$nomeUnidade  = $fieldUnidade['nfantasia_estabelecimento'];
																echo "<option value='$idUnidade'>$nomeUnidade</option>";
															}
														}
														?>
													</select>

												</div>
											</div>
											<div class="col-md-7">
												<div class="form-group">
													<label for="profissionalSaude">Profissional Executante:</label>
													<select type="text" id="profissionalSaude" class="form-control">
														<option value=''>TODOS...</option>
													</select>
												</div>
											</div>
										</div>
										<div class="row" style="margin-top:-10px;">
											<div class="col-md-5">
												<div class="form-group">
													<label for="grupoProcedimento">Grupo:</label>
													<select class="form-control" id="grupoProcedimento" onchange="filtrarProcedimentos()">
														<option value="">TODOS...</option>
													</select>
												</div>
											</div>
											<div class="col-md-7">
												<div class="form-group">
													<label for="nomeProcedimento">Nome do Procedimento:</label>
													<select class="form-control" id="nomeProcedimento">
														<option value="">TODOS...</option>
													</select>
												</div>
											</div>
										</div>
										<div class="row" style="margin-top:-10px;">
											<div class="col-md-3">
												<div class="form-group">
													<label for="dataInicialRelatorio">Data Inicial:</label>
													<input type="date" id="dataInicialRelatorio" class="form-control text-center">
												</div>
											</div>
											<div class="col-md-3">
												<div class="form-group">
													<label for="dataFinalRelatorio">Data Final:</label>
													<input type="date" id="dataFinalRelatorio" class="form-control text-center">
												</div>
											</div>
											<div class="col-md-6">
												<div class="form-group">
													<label for="tipoRelatorio">Tipo de Relatório:</label>
													<select class="form-control" id="tipoRelatorio">
														<option value="">SELECIONE...</option>
														<option value="analitico">RELATÓRIO ANALÍTICO (INCLUI NOME DO PACIENTE)</option>
														<option value="sintetico">RELATÓRIO SINTÉTICO (SEM NOME DO PACIENTE)</option>
													</select>
												</div>
											</div>
										</div>
										<div class="row" style="margin-top:-17px;">
											<div class="col-md-12">
												<div class="form-group">
													<div class="bs-callout-warning callout-square callout-bordered mt-1" style='margin-top:0px !important'>
														<div class="media align-items-stretch">
															<div class="media-left d-flex align-items-center bg-warning p-2" style='padding:7px !important;'>
																<i class="icofont icofont-exclamation-tringle white font-medium-5"></i>
															</div>
															<div class="media-body p-1" style='padding:7px !important; padding-left:10px !important'>
																<strong>
																	ATENÇÃO! O sistema considerará para efeito de geração do relatório de produção, apenas os atendimentos efetivamente confirmados com a chave fornecida na guia do agendamento.
																</strong>
															</div>
														</div>
													</div>
												</div>
											</div>
										</div>
									</div>
									<div class="form-body">
										<div class="form-actions" style="margin-top:-15px !important"></div>
										<div class="row" style="margin-top:-17px;">
											<div class="col-md-12">
												<div class="form-group">
													<button type="button" class="btn btn-blue" onClick="gerarRelatorio('visualizar-relatorio')">
														<i class="icofont icofont-printer"></i> Visualizar e Imprimir
													</button>
													<!--<button type="button" class="btn btn-success" onClick="gerarRelatorio('gerar-arquivo-excel')">
														<i class="icofont icofont-file-excel"></i> Salvar em Excel
													</button>-->
												</div>
											</div>
										</div>
									</div>
								</form>
							</div>
						</div>
					</div>
				</div>
		</section>
	</div>
</div>


<div class='barra-flutuante' style='display: none'>
	<button type='button' class='btn btn-green' onClick='confirmarChave()' id='btnConfirmarChave'>
		<i class='icofont icofont-checked'></i> Confirmar Chave
	</button>
</div>
<?php
include_once("footer.php");
?>
<script src="../app-assets/vendors/js/forms/extended/inputmask/jquery.inputmask.bundle.min.js"></script>
<script src="../app-assets/js/scripts/forms/extended/form-inputmask.min.js"></script>
<script src="../app-assets/vendors/js/tables/datatable/datatables.min.js"></script>
<script src="../app-assets/js/scripts/tables/datatables/datatable-basic.min.js"></script>
<script src="../app-assets/js/scripts/ui/jquery-ui/buttons-selects.min.js"></script>

<script>
	$("#liRelProducao").attr('class', 'active');
	$("#liRelProducao").css("border-bottom", "2px solid #c4c8ca");

	$("#unidadeSaude").change(function() {

		if (this.value != "") {
			$.ajax({
				url: 'filtros/filtrar_profissionalagenda',
				type: 'post',
				dataType: 'html',
				data: {
					'opcaoFiltro': 'relatorio-producao',
					'idUnidadeSaude': this.value
				}
			}).done(function(resultadoRetorno) {
				$("#profissionalSaude").html(resultadoRetorno);
				$("#profissionalSaude").trigger("change");
			});

		} else {
			$("#profissionalSaude").html("<option value=''>TODOS...</option>");
		}

	})

	function filtrarProcedimentos() {

		if ($("#grupoProcedimento").val() != "") {

			$("#embacado").css("display", "block");

			$.ajax({
				url: 'filtros/filtrar_procedimento',
				type: 'post',
				dataType: 'html',
				data: {
					'opcaoPesquisa': 'relatorio-producao',
					'codigoEstabelecimento': $("#unidadeSaude").val(),
					'codigoProfissional': $("#profissionalSaude").val(),
					'grupoProcedimento': $("#grupoProcedimento").val()
				}
			}).done(function(resultadoRetorno) {
				$("#nomeProcedimento").html("");
				$("#nomeProcedimento").html(resultadoRetorno);
				$("#embacado").css("display", "none");
			});

		} else {
			$("#nomeProcedimento").html("<option value=''>TODOS...</option>");
		}

	}

	$("#opcaoPeriodo").change(function() {

		if (this.value != "") {
			$("#dataInicialPesquisa").prop("disabled", false);
			$("#dataFinalPesquisa").prop("disabled", false);
		} else {
			$("#dataInicialPesquisa").prop("disabled", true);
			$("#dataFinalPesquisa").prop("disabled", true);
			$("#dataInicialPesquisa").val("");
			$("#dataFinalPesquisa").val("");
		}

	})

	$("#profissionalSaude").change(function() {

		$.ajax({
			url: 'filtros/filtrar_grupoprocedimento',
			type: 'post',
			dataType: 'html',
			data: {
				'opcaoFiltro': 'relatorio-producao-profissional',
				'codigoProfissional': this.value,
				'codigoEstabelecimento': $("#unidadeSaude").val()
			}
		}).done(function(resultadoRetorno) {
			$("#grupoProcedimento").html(resultadoRetorno);
			$("#grupoProcedimento").trigger("change");
		});

	});

	function gerarRelatorio(opcaoRelatorio) {

		if ($("#unidadeSaude").val() == "") {
			swal("Dados Obrigatórios", "Você precisa selecionar a unidade de saúde.", "error");
			return false;
		}

		if ($("#dataInicialRelatorio").val() == "" || $("#dataFinalRelatorio").val() == "") {
			swal("Dados Obrigatórios", "Você deve informar o período para análise do relatório.", "error");
			return false;
		}

		if ($("#dataInicialRelatorio").val() > $("#dataFinalRelatorio").val()) {
			swal("Período Inválido", "A data inicial não pode ser maior que a data final.", "error");
			return false;
		}

		if ($("#tipoRelatorio").val() == '') {
			swal("Tipo de Relatorio", "Você deve selecionar o tipo de relatório que deseja visualizar.", "error");
			return false;
		}

		switch (opcaoRelatorio) {
			case 'visualizar-relatorio':
				var tipoRelatorio = $('#tipoRelatorio').val() == 'analitico' ? "relatorioproducao_analitico" : "relatorioproducao_sintetico";
				$("#embacado").css("display", "block");
				$.ajax({
					url: 'action/gerar_relatorioproducao',
					type: 'post',
					dataType: 'html',
					data: {
						'codigoUnidadeSaude': $("#unidadeSaude").val(),
						'nomeUnidadeSaude': $('#unidadeSaude').find(":selected").text(),
						'idProfissionalSaude': $("#profissionalSaude").val(),
						'nomeProfissionalSaude': $('#profissionalSaude').find(":selected").text(),
						'idGrupoProcedimento': $("#grupoProcedimento").val(),
						'nomeGrupoProcedimento': $('#grupoProcedimento').find(":selected").text(),
						'idProcedimento': $("#nomeProcedimento").val(),
						'nomeProcedimento': $('#nomeProcedimento').find(":selected").text(),
						'dataInicialRelatorio': $("#dataInicialRelatorio").val(),
						'dataFinalRelatorio': $("#dataFinalRelatorio").val(),
						'tipoRelatorio': $('#tipoRelatorio').find(":selected").text()
					}
				}).done(function(resultadoRetorno) {
					$("#embacado").css("display", "none");
					window.open("relatorios/" + tipoRelatorio);
				});
				break;
		}

	}

	/** SETAR UNIDADE LOGADA */
	var idPerfilLogado = "<?php echo $idPerfilLogado; ?>";
	var idUnidadeLogada = "<?php echo $idUnidadeLogada; ?>";
	if (idPerfilLogado == 13) {
		$("#unidadeSaude").val(idUnidadeLogada)
		$("#unidadeSaude").trigger("change");
	}
</script>