<?php
session_start();
if(!isset($_SESSION['idUsuarioLogado'])){
	header("location: ./");
}
include_once("header.php");
$idUsuarioLogado  = $_SESSION['idUsuarioLogado'];
?>
<div class="app-content content" style="background-color: #e9e9e7;">
  <div class="content-wrapper" style="padding: 10px;">
    <div class="content-body">
      <div class="row">
        <div class="col-12">
          <div class="card" style='margin-top:-5px'>
            <div class="card-content">
              <div class="card-body">
              <div class="form-body">
                  <h4 class="form-section h4-painel">
                    <i class="icofont icofont-calendar" style='font-size:16pt'></i><b>&nbsp;Seus Registros de Hoje:</b>
                  </h4>
                </div>                
                <div class="row">
                  <div class="col-lg-6 col-sm-12 border-right-blue-grey border-right-lighten-5">
                    <div class="pb-1">
                      <div class="clearfix mb-1" style='border-bottom: 2px solid #2196F3'>
                        <i class="icofont icofont-files font-large-1 blue float-left mt-1 novo-tamanho-icofont"><font class='font-painel'>&nbsp;Solicitações Registradas</font></i>
                        <span class="font-large-2 text-bold-600 blue float-right" id='totalSolicitacoesRegistradas'>&nbsp;</span>
                      </div>
                    </div>
                  </div>
                  <div class="col-lg-6 col-sm-12 border-right-lighten-5">
                    <div class="pb-1">
                      <div class="clearfix mb-1" style='border-bottom: 2px solid #37BC9B'>
                        <i class="icofont icofont-paper font-large-1 success float-left mt-1 novo-tamanho-icofont"><font class='font-painel'>&nbsp;Entregas de Marcação</font></i>
                        <span class="font-large-2 text-bold-600 success float-right" id='totalMarcacoesEntregues'>&nbsp;</span>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
          <div class="card" style='margin-top:-20px'>
            <div class="card-content">
              <div class="card-body">
                <div class="form-body">
                  <h4 class="form-section h4-painel">
                    <i class="icofont icofont-checked" style='font-size:16pt'></i><b>&nbsp;Registros Gerais:</b>
                  </h4>
                  <div class="row">
                    <div class="col-lg-6 col-sm-12 border-right-blue-grey border-right-lighten-5">
                      <div class="pb-1">
                        <div class="clearfix mb-1" style='border-bottom: 2px solid #DA4453'>
                          <i class="icofont icofont-refresh font-large-1 danger float-left mt-1 novo-tamanho-icofont"><font class='font-painel'>&nbsp;Solicitações Devolvidas</font></i>
                          <span class="font-large-2 text-bold-600 danger float-right" id='totalSolicitacoesDevolvidas'>&nbsp;</span>
                        </div>
                      </div>
                    </div>
                    <div class="col-lg-6 col-sm-12 border-right-lighten-5">
                      <div class="pb-1">
                        <div class="clearfix mb-1" style='border-bottom: 2px solid #DA4453'>
                          <i class="icofont icofont-close-squared-alt font-large-1 danger float-left mt-1 novo-tamanho-icofont"><font class='font-painel'>&nbsp;Solicitações Indeferidas</font></i>
                          <span class="font-large-2 text-bold-600 danger float-right" id='totalSolicitacoesIndeferidas'>&nbsp;</span>
                        </div>
                      </div>
                    </div>
                  </div>                  
                </div>
                <div class="row" style='margin-top:-25px'>
                  <div class="col-md-12">
                    <div class="form-group">
                      <table class="table table-striped table-bordered default-ordering table-responsive-xl2" id='dados_solicitacoes'>
                        <thead>
                          <tr>
                            <th>NOME DO USUÁRIO</th>
                            <th>UNIDADE DE LOTAÇÃO</th>
                            <th style="text-align:center; width:100px">SOLICITADOS NO MÊS</th>
                            <th style="text-align:center; width:100px">ENTREGUES NO MÊS</th>
                            <th style="text-align:center; width:100px">TOTAL DEVOLVIDA</th>
                            <th style="text-align:center; width:100px">TOTAL INDEFERIDA</th>
													</tr>
												</thead>
    										<tbody style="background-color:#ececec">
                        <?php
                          $mesAtual = date("Y-m");
                          $sqlSolicitacoes = "SELECT reg_tb_usuario.id_usuario,
                          reg_tb_usuario.nome_usuario,
                          reg_tb_unidade_saude.nome_unidade,
                          COUNT(reg_tb_solicitacoes.id_solicitacao) AS totalSolicitado
                          FROM reg_tb_solicitacoes
                          INNER JOIN reg_tb_usuario ON (reg_tb_solicitacoes.id_usuario_cadastrou = reg_tb_usuario.id_usuario)
                          INNER JOIN reg_tb_unidade_saude ON (reg_tb_unidade_saude.id_unidade = reg_tb_usuario.id_unidade)
                          WHERE (date_format(datahora_cadastro,'%Y-%m')='$mesAtual')
                          GROUP BY (reg_tb_usuario.nome_usuario), (reg_tb_unidade_saude.nome_unidade)
                          ORDER BY COUNT(reg_tb_solicitacoes.id_solicitacao) DESC";
                          $stmSolicitacoes  = $rsConexao->prepare($sqlSolicitacoes);
                          $stmSolicitacoes  -> execute();
                          
                          $totalGeralSolicitacoes     = 0;
                          $totalGeralEntreges         = 0;
                          $totalGeralDevolvidas       = 0;
                          $percentualGeralDevolvido   = 0;
                          $totalGeralIndeferido       = 0;
                          $percentualGeralIndeferidos = 0;

                          if($stmSolicitacoes->rowCount()>0){
                            $rsSolicitacoes = $stmSolicitacoes->fetchAll(PDO::FETCH_ASSOC);                          
                            foreach($rsSolicitacoes AS $fieldSolicitacoes){
                              
                              $idUsuario      = $fieldSolicitacoes['id_usuario'];
                              $nomeUsuario    = mb_strtoupper($fieldSolicitacoes['nome_usuario']);
                              $unidadeLotacao = mb_strtoupper($fieldSolicitacoes['nome_unidade']);
                              $solicitadosMes = number_format($fieldSolicitacoes['totalSolicitado'],0,'','.');
                              
                              // pegar total entregues //                   
                              $sqlEntregues   = "SELECT COUNT(reg_tb_solicitacoes.id_solicitacao) AS totalEntregue FROM reg_tb_solicitacoes WHERE id_statussolicitacao='6' AND id_usuario_entregou='$idUsuario' AND (date_format(datahora_entrega,'%Y-%m')='$mesAtual')";
                              $stmEntregues   = $rsConexao->prepare($sqlEntregues);
                              $stmEntregues   -> execute();
                              $rsEntregues    = $stmEntregues->fetch(PDO::FETCH_OBJ);
                              $entreguesMes   = number_format($rsEntregues->totalEntregue,0,'','.');

                              // pegar total devolvidos //                                                 
                              $sqlSolicitacaoCandidato  = "SELECT COUNT(reg_tb_solicitacoes.id_solicitacao) AS totalSolicitado FROM reg_tb_solicitacoes WHERE id_usuario_cadastrou='$idUsuario'";
                              $stmSolicitacaoCandidato  = $rsConexao->prepare($sqlSolicitacaoCandidato);
                              $stmSolicitacaoCandidato  -> execute();
                              $rsSolicitacaoCandidato   = $stmSolicitacaoCandidato->fetch(PDO::FETCH_OBJ);
                              $totalSolicitadoCandidato = $rsSolicitacaoCandidato->totalSolicitado;

                              $sqlDevolvidos  = "SELECT COUNT(reg_tb_solicitacoes.id_solicitacao) AS totalDevolvido FROM reg_tb_solicitacoes WHERE id_statussolicitacao='10' AND id_usuario_cadastrou='$idUsuario'";
                              $stmDevolvidos        = $rsConexao->prepare($sqlDevolvidos);
                              $stmDevolvidos        -> execute();
                              $rsDevolvidos         = $stmDevolvidos->fetch(PDO::FETCH_OBJ);
                              $totalDevolvido       = number_format($rsDevolvidos->totalDevolvido,0,'','.');
                              $percentualDevolvido  = "- (".number_format((($rsDevolvidos->totalDevolvido/$totalSolicitadoCandidato)*100),1,',','')."%)";

                              // pegar total indeferidos //
                              $sqlIndeferidos  = "SELECT COUNT(reg_tb_solicitacoes.id_solicitacao) AS totalIndeferido FROM reg_tb_solicitacoes WHERE id_statussolicitacao='9' AND id_usuario_cadastrou='$idUsuario'";
                              $stmIndeferidos        = $rsConexao->prepare($sqlIndeferidos);
                              $stmIndeferidos        -> execute();
                              $rsIndeferidos         = $stmIndeferidos->fetch(PDO::FETCH_OBJ);
                              $totalIndeferido       = number_format($rsIndeferidos->totalIndeferido,0,'','.');
                              $percentualIndeferido  = "- (".number_format((($rsIndeferidos->totalIndeferido/$totalSolicitadoCandidato)*100),1,',','')."%)";
                              echo "<tr>
                                <td>$nomeUsuario</td>
                                <td>$unidadeLotacao</td>
                                <td align='center'>$solicitadosMes</td>
                                <td align='center'>$entreguesMes</td>
                                <td align='right'>$totalDevolvido $percentualDevolvido</td>
                                <td align='right'>$totalIndeferido $percentualIndeferido </td>
                              </tr>";

                              $totalGeralSolicitacoes = $totalGeralSolicitacoes+$fieldSolicitacoes['totalSolicitado'];
                              $totalGeralEntreges     = $totalGeralEntreges+$rsEntregues->totalEntregue;
                              $totalGeralDevolvidas   = $totalGeralDevolvidas+$rsDevolvidos->totalDevolvido;
                              $totalGeralIndeferido   = $totalGeralIndeferido+$rsIndeferidos->totalIndeferido;
                            }
                          }
                          if($totalGeralSolicitacoes>0){
                            $percentualGeralDevolvido   = " - (".number_format((($totalGeralDevolvidas/$totalGeralSolicitacoes)*100),1,',','')."%)";
                            $percentualGeralIndeferidos = " - (".number_format((($totalGeralIndeferido/$totalGeralSolicitacoes)*100),1,',','')."%)";
                          }
                        ?>                        
                        </tbody>
                        <tfoot style='background-color:#046b97; color:#fff' id='tfoot-faturamento'>
                          <tr>
                            <th colspan='2'>TOTAL GERAL</th>
                            <th style='text-align:center'><?php echo number_format($totalGeralSolicitacoes,0,'','.');?></th>
                            <th style='text-align:center'><?php echo number_format($totalGeralEntreges,0,'','.');?></th>
                            <th style='text-align:right;' colspan='2'></th>
                          </tr>
                        </tfoot>
                      </table>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>     
      </div>
    </div>
  </div>
</div>
<?php
  include_once("footer.php"); // Rodapé padrão de todoas as páginas
?>

<script src="../app-assets/vendors/js/forms/extended/inputmask/jquery.inputmask.bundle.min.js"></script>
<script src="../app-assets/js/scripts/forms/extended/form-inputmask.min.js"></script>
<script src="../app-assets/vendors/js/tables/datatable/datatables.min.js"></script>        
<script src="../app-assets/js/scripts/tables/datatables/datatable-basic.min.js"></script>
<script src="../app-assets/js/scripts/ui/jquery-ui/buttons-selects.min.js"></script>

<script>
  setClassTable("dados_solicitacoes");

  $('#dados_solicitacoes').DataTable({
    "lengthChange"  : false,
    "filter"        : false,
    "ordering"      : false
  });

  function carregarDadosPainel(opcaoPainel){    
    $.ajax({				
		  url: 'action/carregardados_painel',
		  type: 'post',
		  dataType: 'html',
		  data: {
			  'opcaoPainel' : opcaoPainel
		  }
	  }).done(function(resultadoRetorno){
      switch(opcaoPainel){        
        case "solicitante-solicitacoesregistradas":
          $("#totalSolicitacoesRegistradas").html(resultadoRetorno);
        break;
        case "solicitante-marcaoesentregues":        
          $("#totalMarcacoesEntregues").html(resultadoRetorno);
        break;
        case "solicitante-solicitacoesdevolvidas":
          $("#totalSolicitacoesDevolvidas").html(resultadoRetorno);
        break;
        case "solicitante-solicitacoesindeferidas":
          $("#totalSolicitacoesIndeferidas").html(resultadoRetorno);
        break;
        
      }
    });

  }
  carregarDadosPainel('solicitante-solicitacoesregistradas');
  carregarDadosPainel('solicitante-marcaoesentregues');
  carregarDadosPainel('solicitante-solicitacoesdevolvidas');
  carregarDadosPainel('solicitante-solicitacoesindeferidas');

</script>