<?php
session_start();
if (!isset($_SESSION['idUsuarioLogado']) || $_SESSION['idPerfilLogado'] != 1) {
	header("location: ./");
}
$idPerfilLogado = $_SESSION['idPerfilLogado'];
include_once("header.php");
include_once("include/funcoes_gsaudereg.php");

?>
<div class="app-content content" style='background-color:#e1e9e7;'>
	<div class="content-wrapper" style='padding:10px;'>
		<section id="ordering">
			<div class="row">
				<div class="col-12">
					<div class="card" style='border:gray 1px solid;' id="card-tela">
						<div class="card-header titulo-telas">
							<i class="icofont icofont-monitor" style='margin-top:-15px !important'></i>&nbsp;Cadastrar Painel de Chamada
							<a class="heading-elements-toggle"><i class="fa fa-ellipsis-v font-medium-3"></i></a>
							<div class="heading-elements">
								<ul class="list-inline mb-0" style="margin-top: -12px; color: #fff;">
									<li>
										<a data-action="collapse"><i class="ft-minus"></i></a>
									</li>
									<li>
										<a data-action="expand"><i class="ft-maximize"></i></a>
									</li>
								</ul>
							</div>
						</div>
						<div class="card-content collapse show">
							<div class="card-body">
								<form class="form" style='margin-top:-10px'>
									<div class="form-body">
										<h4 class="form-section"><i class="icofont icofont-edit"></i><b>Informações para pesquisa</b>
											<input type='hidden' id="idPainelChamada" disabled>
										</h4>
										<div class="row" style='margin-top:-10px;'>
											<div class="col-md-6">
												<div class="form-group">
													<label for="unidadeAtendimento">Unidade de Atendimento:</label>
													<select id="unidadeAtendimento" class="form-control">
														<option value=''>TODAS...</option>
														<?php
														$stmUnidadeSaude  = $rsConexao->prepare("SELECT * FROM tb_estabelecimento WHERE (status_estabelecimento='A' AND codigoestabelecimento_cnes!='9999999999999') ORDER BY nfantasia_estabelecimento");
														$stmUnidadeSaude->execute();
														if ($stmUnidadeSaude->rowcount() > 0) {
															$rsUnidadeSaude   = $stmUnidadeSaude->fetchAll(PDO::FETCH_ASSOC);
															foreach ($rsUnidadeSaude as $fieldUnidade) {
																$idUnidade    = $fieldUnidade['codigoestabelecimento_cnes'];
																$nomeUnidade  = $fieldUnidade['nfantasia_estabelecimento'];
																echo "<option value='$idUnidade'>$nomeUnidade</option>";
															}
														}
														?>
													</select>
												</div>
											</div>
											<div class="col-md-6">
												<div class="form-group">
													<label for="nomePainel">Nome/Localização do Painel:</label>
													<input type="text" id="nomePainel" class="form-control">
												</div>
											</div>
										</div>
										<div class="row" style='margin-top:-10px;'>
											<div class="col-md-12">
												<div class="form-group">
													<button type="button" class="btn btn-info" onClick="cadastrarPainel()">
														<i class="icofont icofont-checked"></i> Confirmar
													</button>
													<button type="button" class="btn btn-danger" id="btnCancelarEdicao" style='width:120px' disabled>
														<i class="fa fa-times"></i> Cancelar
													</button>
												</div>
											</div>
										</div>
										<div class="row" style='margin-top:-10px;'>
											<div class="col-md-12">
												<div class="form-group">
													<table class="table table-striped table-bordered default-ordering" id='dados_painelchamada'>
														<thead>
															<th style='text-align:center' width='100px'>OPÇÕES</th>
															<th>NOME DO PAINEL</th>
															<th align='center'>ID DO GET</th>
															<th>UNIDADE DE ATENDIMENTO</th>
															</tr>
														</thead>
														<tbody style="background-color:#ececec">
															<?php
															$sqlListaPaineis = "SELECT reg_tb_painelchamada.id_painelchamada,
																reg_tb_painelchamada.codigoestabelecimento_cnes,
																reg_tb_painelchamada.nome_painel,
																tb_estabelecimento.nfantasia_estabelecimento
																FROM tb_estabelecimento
																INNER JOIN reg_tb_painelchamada ON (tb_estabelecimento.codigoestabelecimento_cnes = reg_tb_painelchamada.codigoestabelecimento_cnes)
																ORDER BY tb_estabelecimento.nfantasia_estabelecimento,reg_tb_painelchamada.nome_painel";
															$stmListaPaineis = $rsConexao->prepare($sqlListaPaineis);
															$stmListaPaineis->execute();

															if ($stmListaPaineis->rowCount()) {
																$rsListaPaineis  = $stmListaPaineis->fetchAll(PDO::FETCH_ASSOC);
																foreach ($rsListaPaineis as $fieldListaPaineis) {
																	$idPainel     	= $fieldListaPaineis['id_painelchamada'];
																	$codigoUnidade	= mb_strtoupper($fieldListaPaineis['codigoestabelecimento_cnes']);
																	$nomePainel   	= mb_strtoupper($fieldListaPaineis['nome_painel']);
																	$nomeUnidade   	= mb_strtoupper($fieldListaPaineis['nfantasia_estabelecimento']);

																	$linkEditarPainel		= '"editarPainel(' . "'$idPainel##$codigoUnidade##$nomePainel')" . '"';
																	$linkExcluirPainel	= '"excluirPainel(' . "'$idPainel')" . '"';
																	$linkAssociarSetor		= '"associarSetorPainel(' . "'$idPainel##$codigoUnidade##$nomePainel##$nomeUnidade')" . '"';

																	echo "<tr>
																				<td align='center'>
																					<i class='icofont icofont-edit nova_fonte' title='Editar registro do painel.' onclick=$linkEditarPainel></i>&nbsp;
																					<i class='icofont icofont-close-squared nova_fonte_delete' title='Excluir registro do painel.' onclick=$linkExcluirPainel></i>&nbsp;
																					<i class='icofont icofont-architecture-alt nova_fonte_blue' title='Associar setores de atendimento.' onclick=$linkAssociarSetor></i>
																				</td>
																				<td>$nomePainel</td>
																				<td style='text-align:center'>$idPainel</td>
																				<td>$nomeUnidade</td>
																			</tr>";
																}
															}
															?>
														</tbody>
													</table>
												</div>
											</div>
										</div>
									</div>
									<div class="form-actions" style="margin-top:-15px !important"></div>
								</form>
							</div>
						</div>
					</div>
				</div>
			</div>
		</section>
	</div>
</div>

<?php
include_once("footer.php");
include_once("include/box_painel_setor.php");
?>
<script src="../app-assets/vendors/js/forms/extended/inputmask/jquery.inputmask.bundle.min.js"></script>
<script src="../app-assets/js/scripts/forms/extended/form-inputmask.min.js"></script>
<script src="../app-assets/vendors/js/tables/datatable/datatables.min.js"></script>
<script src="../app-assets/js/scripts/tables/datatables/datatable-basic.min.js"></script>
<script src="../app-assets/js/scripts/ui/jquery-ui/buttons-selects.min.js"></script>

<script>
	$("#liPainelChamada").attr('class', 'active');
	$("#liPainelChamada").css("border-bottom", "2px solid #c4c8ca");

	$('#dados_painelchamada').DataTable({
		"filter": false,
		"lengthChange": false
	});

	$('#dados_painelsetor').DataTable({
		"filter": false,
		"lengthChange": false
	});

	function cadastrarPainel() {
		if ($("#unidadeAtendimento").val() == "" || $("#nomePainel").val() == "") {
			swal("Dados Obriratórios", "Selecine a unidade e informe o nome/local do painel", "error");
			return false;
		}

		$('#embacado').css('display', 'block');
		$.ajax({
			url: 'action/gravar_painelchamada',
			type: 'post',
			dataType: 'html',
			data: {
				'opcaoCadastro': 'cadastro-painel',
				'unidadeAtendimento': $("#unidadeAtendimento").val(),
				'idPainelChamada': $("#idPainelChamada").val(),
				'nomePainel': $("#nomePainel").val()
			}
		}).done(function(resultadoRetorno) {

			$("#embacado").css("display", "none");

			if (resultadoRetorno == "JaExiste") {
				swal("Painel Duplicado", "Já existe um painel cadastrado com este nome na unidade selecionada.", "error");
				return false;
			}
			$('#dados_painelchamada').DataTable().destroy();
			$('#dados_painelchamada tbody').empty().append(resultadoRetorno);
			$('#dados_painelchamada').DataTable({
				"filter": false,
				"lengthChange": false
			});
			$("#nomePainel").val('');
			$("#idPainelChamada").val('');
		});

	}

	function editarPainel(dadosEdicao) {
		var splideDadosEdicao = dadosEdicao.split("##");
		$("#idPainelChamada").val(splideDadosEdicao[0]);
		$("#unidadeAtendimento").val(splideDadosEdicao[1]);
		$("#nomePainel").val(splideDadosEdicao[2]);
		$("#btnCancelarEdicao").prop("disabled", false);
	}

	$("#btnCancelarEdicao").click(function() {
		$("#idPainelChamada").val('');
		$("#unidadeAtendimento").val('');
		$("#nomePainel").val('');
		$(this).prop("disabled", true);
	})

	function associarSetorPainel(dadosAssociaSetor) {
		var splitDados = dadosAssociaSetor.split("##");
		$("#idPainelChamadaSetor").val(splitDados[0]);
		$("#idUnidadePainel").val(splitDados[1]);
		$("#nomeLocalPainel").val(splitDados[2]);
		$("#nomeUnidadeAtendimento").val(splitDados[3]);

		$('#embacado').css('display', 'block');
		$.ajax({
			url: 'filtros/buscar_dados_edicao',
			type: 'post',
			dataType: 'html',
			data: {
				'opcaoBusca': "preencher-combo-e-listasetor",
				'idPainelChamada': $("#idPainelChamadaSetor").val(),
				'idUnidadePainel': splitDados[1]
			}
		}).done(function(resultadoRetorno) {
			var retornoResultado = resultadoRetorno.split("###");
			$('#setorPainel').html(retornoResultado[0]);
			$('#listaSetoresPainel').html(retornoResultado[1]);
			$("#boxPainelSetores").modal();
			$('#embacado').css('display', 'none');
		});
	}

	$("#btnAdicionarSetorPainel").click(function() {
		if ($("#setorPainel").val() == "") {
			swal("Setor Obrigatório", "Você precisa selecionar o setor que deseja associar ao painel.", "error");
			return false;
		}

		$('#embacado').css('display', 'block');
		$.ajax({
			url: 'action/gravar_painelchamada',
			type: 'post',
			dataType: 'html',
			data: {
				'opcaoCadastro': 'cadastro-painel-setor',
				'idPainelChamada': $("#idPainelChamadaSetor").val(),
				'unidadeAtendimento': $("#idUnidadePainel").val(),
				'setorPainel': $("#setorPainel").val(),
				'idSetorAssociadoPainel': $("#idSetorAssociadoPainel").val()
			}
		}).done(function(resultadoRetorno) {

			$("#embacado").css("display", "none");
			if (resultadoRetorno == "JaExiste") {
				swal("Setor Duplicado", "Setor já cadastrador para este painel na mesma unidade.", "error");
				return false;
			}
			$('#listaSetoresPainel').html(resultadoRetorno);
			$("#idSetorAssociadoPainel").val('');
			$("#setorPainel").val('');
		});

	})


	function excluirPainel(idPainel) {

		swal({
			title: "Exclusão de Registro",
			text: "Confirma exclusão do registro selecionado?",
			icon: "../app-assets/images/question.png",

			buttons: {
				confirm: {
					text: "Sim, Confirmar!",
					value: true,
					visible: true,
					className: "btn-success",
					closeModal: false
				},
				cancel: {
					text: "Não, Foi engano!",
					value: null,
					visible: true,
					className: "btn-danger",
					closeModal: false,
				}
			}

		}).then((isConfirm) => {

			if (isConfirm) {
				$.ajax({
					url: 'action/excluir_registro',
					type: 'post',
					dataType: 'html',
					data: {
						'opcaoExclusao': 'painel-chamada',
						'idRegistroExclusao': idPainel
					}
				}).done(function(resultadoRetorno) {

					$("#embacado").css("display", "none");
					$('#dados_painelchamada').DataTable().destroy();
					$('#dados_painelchamada tbody').empty().append(resultadoRetorno);
					$('#dados_painelchamada').DataTable({
						"filter": false,
						"lengthChange": false
					});
					swal("Exclusão de Registro", "Registro do painel de chamadas excluído com sucesso.", "success");
				});

			} else {
				swal("Operação Cancelada.", "O registro selecionado não foi excluído.", "info");
			}

		});

	}

	function excluirSetorPainel(idSetorPainel) {

		swal({
			title: "Exclusão de Registro",
			text: "Confirma exclusão do registro selecionado?",
			icon: "../app-assets/images/question.png",

			buttons: {
				confirm: {
					text: "Sim, Confirmar!",
					value: true,
					visible: true,
					className: "btn-success",
					closeModal: false
				},
				cancel: {
					text: "Não, Foi engano!",
					value: null,
					visible: true,
					className: "btn-danger",
					closeModal: false,
				}
			}

		}).then((isConfirm) => {

			if (isConfirm) {
				$.ajax({
					url: 'action/excluir_registro',
					type: 'post',
					dataType: 'html',
					data: {
						'opcaoExclusao': 'painel-chamada-setor',
						'idRegistroExclusao': idSetorPainel,
						'idPainelChamada': $("#idPainelChamadaSetor").val(),
						'idUnidadePainel': $("#idUnidadePainel").val()
					}
				}).done(function(resultadoRetorno) {

					$("#embacado").css("display", "none");
					$('#listaSetoresPainel').html(resultadoRetorno);
					$("#idSetorAssociadoPainel").val('');
					$("#setorPainel").val('');
					swal("Exclusão de Registro", "Registro excluído com sucesso.", "success");
				});

			} else {
				swal("Operação Cancelada.", "O registro selecionado não foi excluído.", "info");
			}

		});

	}

</script>