
    SELECT  
        CONCAT(t1.id_solicitacao, t1.numero_procotolo) AS identifier_value,
        t2.cns_paciente,
        t2.cpf_paciente,
        CONCAT(DATE_FORMAT(t1.datahora_cadastro, '%Y-%m-%dT%H:%i:%s'), '-03:00') AS data_registro_criado,
        CONCAT(DATE_FORMAT(COALESCE(t1.datahora_analise, t1.datahora_cadastro), '%Y-%m-%dT%H:%i:%s'), '-03:00') AS data_registro_fim,
        t5.id_rnds,
        'R69' as CID,
                    IFNULL(
                CASE 
                    WHEN REPLACE(t1.observacao_agendamento, '<br>', '') = '' THEN 'Sem observações'
                    ELSE t1.observacao_agendamento
                END, 
                'Sem observações'
            ) AS observacao_agendamento,
            t3.codigo_sus, 
            t4.nome_statusslicitacao as status_agendamento,
        CASE
            WHEN t1.id_statussolicitacao = '1' THEN 'PENDENTE'
            WHEN t1.id_statussolicitacao = '2' THEN 'PENDENTE'
            WHEN t1.id_statussolicitacao = '3' THEN 'AGENDADO'
            WHEN t1.id_statussolicitacao = '4' THEN 'PENDENTE'
            WHEN t1.id_statussolicitacao = '5' THEN 'CANCELADO'
            WHEN t1.id_statussolicitacao = '6' THEN 'AGENDADO'
            WHEN t1.id_statussolicitacao = '7' THEN 'AGENDADO'
            WHEN t1.id_statussolicitacao = '8' THEN 'COMPARECEU'
            WHEN t1.id_statussolicitacao = '9' THEN 'CANCELADO'
            WHEN t1.id_statussolicitacao = '10' THEN 'CANCELADO'
        END AS status_agendamento_2
 FROM
    reg_tb_solicitacoes t1
LEFT JOIN 
    tb_paciente t2 ON t2.id_paciente = t1.id_paciente 
LEFT JOIN 
    reg_tb_procedimento t3 ON t3.id_procedimento = t1.id_procedimento 
    LEFT JOIN 
    reg_rl_statussolicitacao t4 ON t4.id_statussolicitacao= t1.id_statussolicitacao 
LEFT JOIN 
    reg_rl_classificacaorisco t5 ON t5.id_classificacaorisco = t1.id_classificacaorisco 
    where
      (t1.id_statussolicitacao = '1' or t1.id_statussolicitacao = '2' or 
      t1.id_statussolicitacao = '4' or t1.id_statussolicitacao = '5' or 
      t1.id_statussolicitacao = '8' or t1.id_statussolicitacao = '9' or 
      t1.id_statussolicitacao = '10')  