<?php
session_start();
if (!isset($_SESSION['idUsuarioLogado'])) {
  header("location: ./");
}
include_once("header-clean.php");
require("../database/dbConection.php");

$idPacienteGet  = $_GET['idpac'];

$sqlPaciente  = "SELECT tb_paciente.*, 
TIMESTAMPDIFF(YEAR, datanasc, NOW()) AS idadePaciente, 
tb_cidades.nome_cidade ,
date_format(reg_tb_agendamentos.data_atendimento,'%d/%m/%Y') AS dataAtendimento,
reg_tb_agendamentos.horario_atendimento AS horaAtendimento
FROM tb_paciente 
INNER JOIN tb_cidades ON (tb_paciente.codigocidade=tb_cidades.codigoibge_cidade)
INNER JOIN reg_tb_agendamentos ON (reg_tb_agendamentos.id_paciente=tb_paciente.id_paciente)
WHERE tb_paciente.id_paciente='$idPacienteGet'
AND (reg_tb_agendamentos.id_procedimento='350')";
$stmPaciente  = $rsConexao->prepare($sqlPaciente);
$stmPaciente->execute();
$rsPaciente    = $stmPaciente->fetch(PDO::FETCH_OBJ);

$idPaciente         = $rsPaciente->id_paciente;
$nomePaciente       = $rsPaciente->nome_paciente;
$idadePaciente      = $rsPaciente->idadePaciente;
$sexoPaciente       = $rsPaciente->sexo;
$cnsPaciente        = $rsPaciente->cns_paciente;
$cpfPaciente        = $rsPaciente->cpf_paciente;
$municipioPaciente  = $rsPaciente->nome_cidade;
$bairrroPaciente    = $rsPaciente->bairro_paciente;
$ibgeCidade         = $rsPaciente->codigocidade;
$dataAtendimento    = $rsPaciente->dataAtendimento;
$horaAtendimento    = $rsPaciente->horaAtendimento;

?>
<div class="app-content content" style="background-color: #e1e9e7;">
  <div class="content-wrapper" style="padding: 10px;">
    <section id="ordering">
      <div class="row">
        <div class="col-12">
          <div class="card" style="border: gray 1px solid;" id="card-tela">
            <div class="card-header titulo-telas">
              <i class="icofont icofont-prescription" style='margin-top:-15px !important'></i>&nbsp;Confirmar Atendimento em Mutirão
              <a class="heading-elements-toggle"><i class="fa fa-ellipsis-v font-medium-3"></i></a>
              <div class="heading-elements">
                <ul class="list-inline mb-0" style="margin-top: -12px; color: #fff;">
                  <li>
                    <a data-action="collapse"><i class="ft-minus"></i></a>
                  </li>
                  <li>
                    <a data-action="expand"><i class="ft-maximize"></i></a>
                  </li>
                </ul>
              </div>
            </div>
            <div class="card-content collapse show">
              <div class="card-body novo-padding-cardbody">
                <form class="form">
                  <div class="form-body">
                    <h4 class="form-section"><i class="ft-user"></i><b>Informações do paciente</b>
                      <input type="hidden" id="idPaciente" value="<?php echo $idPaciente; ?>" disabled />
                    </h4>
                    <div class="row" style="margin-top: -10px;">
                      <div class="col-md-5">
                        <div class="form-group">
                          <label for="nomePaciente">Nome:</label>
                          <input type="text" id="nomePaciente" class="form-control" value="<?php echo $nomePaciente; ?>" disabled />
                        </div>
                      </div>
                      <div class="col-md-2">
                        <div class="form-group">
                          <label for="cpfPaciente">CPF:</label>
                          <input type="text" id="cpfPaciente" class="form-control text-center cpf-inputmask" value="<?php echo $cpfPaciente; ?>" disabled />
                        </div>
                      </div>
                      <div class="col-md-2">
                        <div class="form-group">
                          <label for="cnsPaciente">Cartão SUS:</label>
                          <input type="text" id="cnsPaciente" class="form-control text-center cns-inputmask" value="<?php echo $cnsPaciente; ?>" disabled />
                        </div>
                      </div>
                      <div class="col-md-3">
                        <div class="form-group">
                          <label for="dataAtendimento">Atendimento no Motirão:</label>
                          <input type="text" id="dataAtendimento" class="form-control text-center" value="<?php echo $dataAtendimento . ' ' . $horaAtendimento; ?>" disabled />
                        </div>
                      </div>
                    </div>
                  </div>
                  <div class="form-body" style="margin-top: -15px;">
                    <h4 class="form-section"><i class="icofont icofont-paper"></i><b>Solicitações na Fila de Espera</b></h4>
                    <div class="row" style="margin-top:-10px;">
                      <div class="col-md-12">
                        <div class="form-group">
                          <table class='table table-striped table-bordered default-ordering table-responsive-xl2' id='procedimentos_fila'>
                            <thead>
                              <tr>
                                <th style='width:300px'>STATUS</th>
                                <th>PROCEDIMENTOS EM ESPERA</th>
                              </tr>
                            </thead>
                            <tbody style='background-color: #ececec;'>
                              <?php
                              $sqlProcedimentosFila = "SELECT reg_tb_solicitacoes.id_solicitacao,
                                reg_tb_procedimento.nome_procedimento,
                                reg_tb_solicitacoes.id_statussolicitacao
                                FROM reg_tb_solicitacoes
                                INNER JOIN reg_tb_procedimento ON (reg_tb_solicitacoes.id_procedimento = reg_tb_procedimento.id_procedimento)
                                INNER JOIN reg_rl_statussolicitacao ON (reg_tb_solicitacoes.id_statussolicitacao = reg_rl_statussolicitacao.id_statussolicitacao)
                                WHERE (reg_tb_solicitacoes.id_statussolicitacao='2' OR reg_tb_solicitacoes.id_statussolicitacao='5' OR reg_tb_solicitacoes.id_statussolicitacao='11')
                                AND (reg_tb_solicitacoes.id_paciente='$idPacienteGet')
                                ORDER BY reg_tb_procedimento.nome_procedimento ASC";
                              $stmProcedimentosFila = $rsConexao->prepare($sqlProcedimentosFila);
                              $stmProcedimentosFila->execute();
                              if ($stmProcedimentosFila->rowCount() > 0) {
                                $rsProcedimentosFila  = $stmProcedimentosFila->fetchAll(PDO::FETCH_ASSOC);
                                foreach ($rsProcedimentosFila as $fieldProcedimentosFila) {
                                  $idSolicitacao      = $fieldProcedimentosFila['id_solicitacao'];
                                  $nomeProcedimento   = mb_strtoupper($fieldProcedimentosFila['nome_procedimento']);
                                  $statusSolicitacao  = mb_strtoupper($fieldProcedimentosFila['id_statussolicitacao']);

                                  switch ($statusSolicitacao) {
                                    case "2":
                                      $selecionaAguardando  = "selected";
                                      $selecionaAgendado    = "";
                                      $selecionaCancelar    = "";
                                      break;
                                    case "11":
                                      $selecionaAguardando  = "";
                                      $selecionaAgendado    = "selected";
                                      $selecionaCancelar    = "";
                                      break;
                                    case "5":
                                      $selecionaAguardando  = "";
                                      $selecionaAgendado    = "";
                                      $selecionaCancelar    = "selected";
                                      break;
                                  }

                                  if ($statusSolicitacao == '5') {
                                    $setCorLinha = "style='background-color:#fcdfdf !important; color: #700000'";
                                  } else if ($statusSolicitacao == '11') {
                                    $setCorLinha = "style='background-color:#e6ffe2 !important;'";
                                  } else {
                                    $setCorLinha = "";
                                  }

                                  $linkAtualizarStatus = 'onChange="atualizarStatus(' . "'$idSolicitacao',this.value)" . '"';
                                  $comboStatus = "<select id='setStatus$idSolicitacao' class='form-control-personalizado' $linkAtualizarStatus>
                                    <option value='2' $selecionaAguardando>AGUARDANDO AGENDAMENTO</option>
                                    <option value='11' $selecionaAgendado>ATENDIDO EM MUTIRÃO</option>
                                    <option value='5' $selecionaCancelar>CANCELADO</option>
                                  </select>";
                                  echo "<tr $setCorLinha id='linha$idSolicitacao'>
                                      <td style='padding:1px'>
                                        $comboStatus
                                      </td>
                                      <td>$nomeProcedimento</td>
                                    </tr>";
                                }
                              }
                              ?>
                            </tbody>
                          </table>
                        </div>
                      </div>
                    </div>
                  </div>
                </form>
              </div>
            </div>
          </div>
        </div>
      </div>
    </section>
  </div>
</div>
<div class="barra-flutuante">
  <button type="button" class="btn btn-danger" id="btnFechar" onClick="window.close()"><i class="ft-log-out botaoOk"></i> Fechar</button>
</div>

<?php
include_once("footer.php");
?>

<script src="../app-assets/vendors/js/forms/extended/inputmask/jquery.inputmask.bundle.min.js"></script>
<script src="../app-assets/js/scripts/forms/extended/form-inputmask.min.js"></script>
<script src="../app-assets/vendors/js/tables/datatable/datatables.min.js"></script>
<script src="../app-assets/js/scripts/tables/datatables/datatable-basic.min.js"></script>
<script src="../app-assets/js/scripts/ui/jquery-ui/buttons-selects.min.js"></script>

<script>
  $('#procedimentos_fila').DataTable({
    "paging": false,
    "filter": false,
    "lengthChange": false,
    "info": false
  });

  /* atualizar status do agendamento*/
  function atualizarStatus(idSolicitacao, valorStatus) {

    $.ajax({
      url: 'action/gravar_atualizacaostatus',
      type: 'post',
      dataType: 'html',
      data: {
        'opcaoAtualizacao': 'status-agendamento-mutirao',
        'idSolicitacao': idSolicitacao,
        'valorStatus': valorStatus
      }
    }).done(function(resultadoRetorno) {

      switch (valorStatus) {
        case "5":
          $("#linha" + idSolicitacao).css({
            color: "#700000",
            backgroundColor: "background-color: #fcdfdf"
          });
          break;
        case "11":
          $("#linha" + idSolicitacao).css({
            backgroundColor: "background-color:#e6ffe2 !important;"
          });
          break;
        default:
          $("#linha" + idSolicitacao).css({
            color: "#5a5a5a",
            backgroundColor: ""
          });
          break;
      }
    });

  }
</script>