<?php
session_start();
if (!isset($_SESSION['idUsuarioLogado'])) {
  header("location: ./");
}
include_once("header-clean.php");
$dataHoje   = date("Y-m-d");
$idProcedimentoOCI  = $_GET['idp'];

$sqlProcedimentoOCI = "SELECT
reg_tb_procedimento.id_procedimento,
reg_tb_procedimento.codigo_sus,
reg_tb_procedimento.nome_procedimento,
reg_tb_procedimento.id_grupo_procedimento,
format(reg_tb_procedimento.valor_vigente, 2, 'de_DE') AS valorVigenteOCI,
reg_tb_procedimento.sexo_permitido,
reg_tb_procedimento.faixaetaria_idadeinicial,
reg_tb_procedimento.faixaetaria_idadefinal,
reg_tb_procedimento_grupo.nome_grupo_procedimento
FROM reg_tb_procedimento_grupo
INNER JOIN reg_tb_procedimento ON (reg_tb_procedimento_grupo.id_grupo_procedimento = reg_tb_procedimento.id_grupo_procedimento)
WHERE reg_tb_procedimento.id_procedimento='$idProcedimentoOCI'";
$stmProcedimentoOCI = $rsConexao->prepare($sqlProcedimentoOCI);
$stmProcedimentoOCI->execute();
$rsProcedimentoOCI  = $stmProcedimentoOCI->fetch(PDO::FETCH_OBJ);
$idGrupoProcedimentoOCI   = $rsProcedimentoOCI->id_grupo_procedimento;
$nomeGrupoProcedimentoOCI  = $rsProcedimentoOCI->nome_grupo_procedimento;
$idProcedimentoOCI        = $rsProcedimentoOCI->id_procedimento;
$nomeProcedimentoOCI      = $rsProcedimentoOCI->codigo_sus.' - '.$rsProcedimentoOCI->nome_procedimento;
$valorVigenteOCI          = $rsProcedimentoOCI->valorVigenteOCI;
$sexoPermitidoOCI         = $rsProcedimentoOCI->sexo_permitido == "M" ? "MASCULINA" : "FEMININO";
$faixaEtariaPermitidaOCI  = "DE: " . $rsProcedimentoOCI->faixaetaria_idadeinicial . " A " . $rsProcedimentoOCI->faixaetaria_idadefinal;
# --- --- --- --- --- --- --- --- --- --- --- --- --- --- --- --- --- --#
?>

<div class="app-content content" style="background-color: #e1e9e7;">
  <div class="content-wrapper" style="padding: 10px;">
    <section id="ordering">
      <div class="row">
        <div class="col-12">
          <div class="card" style="border: gray 1px solid;" id="card-tela">
            <div class="card-header titulo-telas">
              <i class="icofont icofont-prescription" style='margin-top:-15px !important'></i>&nbsp;Cadastrar procedimentos associados da OCI
              <a class="heading-elements-toggle"><i class="fa fa-ellipsis-v font-medium-3"></i></a>
              <div class="heading-elements">
                <ul class="list-inline mb-0" style="margin-top: -12px; color: #fff;">
                  <li>
                    <a data-action="collapse"><i class="ft-minus"></i></a>
                  </li>
                  <li>
                    <a data-action="expand"><i class="ft-maximize"></i></a>
                  </li>
                </ul>
              </div>
            </div>
            <div class="card-content collapse show">
              <div class="card-body">
                <form class="form">
                  <div class="form-body">
                    <h4 class="form-section" style='margin-top:-10px'>
                      <i class="icofont icofont-edit"></i><b>Dados do Procedimento</b>
                    </h4>
                    <div class="row" style="margin-top:-5px;">
                      <div class="col-md-6">
                        <div class="form-group">
                          <label for="nomeProcedimentoOCI">Nome Procedimento OCI:</label>
                          <input type="text" id="nomeProcedimentoOCI" class="form-control" value="<?php echo $nomeProcedimentoOCI; ?>" disabled>
                        </div>
                      </div>
                      <div class="col-md-2">
                        <div class="form-group">
                          <label for="valorVigenteOCI">Valor Vigente:</label>
                          <input type="text" id="nomeProcedimentoOCI" class="form-control text-right" value="<?php echo $valorVigenteOCI; ?>" disabled>
                        </div>
                      </div>
                      <div class="col-md-2">
                        <div class="form-group">
                          <label for="sexoPermitidoOCI">Sexo Permitido:</label>
                          <input type="text" id="sexoPermitidoOCI" class="form-control text-center" value="<?php echo $sexoPermitidoOCI; ?>" disabled>
                        </div>
                      </div>
                      <div class="col-md-2">
                        <div class="form-group">
                          <label for="faixaEtariaPermitidaOCI">Faixa Etária:</label>
                          <input type="text" id="faixaEtariaPermitidaOCI" class="form-control text-center" value="<?php echo $faixaEtariaPermitidaOCI; ?>" disabled>
                        </div>
                      </div>
                    </div>
                    <div class="row" style="margin-top:-5px;">
                      <div class="col-md-5">
                        <div class="form-group">
                          <label for="cboProfissional" id='lblcboProfissional'>Procedimento Associado:</label>
                          <fieldset>
                            <div class="input-group">
                              <div class="input-group-prepend">
                                <button class="btn btn-blue" type="button" onClick="abrirPesquisaProcedimento()" title="Consultar procedimento"><i class="ft-search"></i></button>
                              </div>
                              <input type="text" id="nomeProcedimentoAssociado" class="form-control" disabled>
                            </div>
                            <input type="hidden" id="idProcedimentoAssociado" disabled>
                            <input type="hidden" id="idRegistroChave" disabled>
                          </fieldset>
                        </div>
                      </div>
                      <div class="col-md-2">
                        <div class="form-group">
                          <label for="procedimentoObrigatorio">Obrigatório:</label>
                          <select id="procedimentoObrigatorio" class="form-control">
                            <option value=''>SELECIONE...</option>
                            <option value='S'>SIM</option>
                            <option value='N'>NÃO</option>
                          </select>
                        </div>
                      </div>
                      <div class="col-md-4">
                        <div class="form-group">
                          <label>&nbsp;</label><br>
                          <button type="button" class="btn btn-blue" onClick="incluirItemLista()" style='width:120px'>
                            <i class="icofont icofont-checked"></i> Incluir
                          </button>
													<button type="button" class="btn btn-danger" id="btnCancelar" style='width:120px' disabled>
														<i class="fa fa-times"></i> Cancelar
													</button>
                        </div>
                      </div>
                    </div>
                    <hr style='margin-top:-10px'>
                    <div class="row" style="margin-top:-15px;">
                      <div class="col-md-12">
                        <div class="form-group">
                          <table class="table table-striped table-bordered default-ordering" id="dados_procedimento" style="font-size: 9pt !important;">
                            <thead>
                              <tr style="background-repeat: repeat-x; height: 30px !important;">
                                <th style="text-align: center; width:8%">OPÇÕES</th>
                                <th style='width:8%; text-align:center'>CÓDIGO</th>
                                <th>NOME DO PROCEDIMENTO</th>
                                <th style='width:8%; text-align:center'>OBRIGATÓRIO</th>
                              </tr>
                            </thead>
                            <tbody style="background-color: #f6f6f6;">
                              <?php
                                $sqlProcedimentoAssociado = "SELECT reg_tb_procedimentos_oci.id_automatico_chave,
                                reg_tb_procedimento.codigo_sus,
                                ucase(reg_tb_procedimento.nome_procedimento) AS nomeProcedimento,
                                reg_tb_procedimentos_oci.procedimento_obrigatorio,
                                reg_tb_procedimentos_oci.id_procedimento_associado
                                FROM reg_tb_procedimento 
                                INNER JOIN reg_tb_procedimentos_oci ON (reg_tb_procedimento.id_procedimento = reg_tb_procedimentos_oci.id_procedimento_associado)
                                WHERE (id_procedimento_oci='$idProcedimentoOCI')
                                ORDER BY reg_tb_procedimentos_oci.id_automatico_chave ASC";
                                $stmProcedimentoAssociado = $rsConexao->prepare($sqlProcedimentoAssociado);
                                $stmProcedimentoAssociado->execute();
                                if ($stmProcedimentoAssociado->rowCount() > 0) {
                                  $rsProcedimentoAssociado  = $stmProcedimentoAssociado->fetchAll(PDO::FETCH_ASSOC);
                                  foreach ($rsProcedimentoAssociado as $fieldProcedimentoAssociado) {
                                    $idRegistroChave  = $fieldProcedimentoAssociado['id_automatico_chave'];
                                    $idProcedimentoAssociado = $fieldProcedimentoAssociado['id_procedimento_associado'];
                                    $codigoSUS        = $fieldProcedimentoAssociado['codigo_sus'];
                                    $nomeProcedimento = $fieldProcedimentoAssociado['nomeProcedimento'];
                                    $procedimentoObrigatorio = $fieldProcedimentoAssociado['procedimento_obrigatorio']=="S" ? "SIM" : "NÃO";
                                    $eObrigatorio     = $fieldProcedimentoAssociado['procedimento_obrigatorio'];
                                    $linkExcluirItem  = '"excluirItemLista(' . "'$idRegistroChave')" . '"';
                                    $linkEditarProcedimento  = '"editarProcedimentoOCI(' . "'$idRegistroChave##$idProcedimentoAssociado##$nomeProcedimento##$eObrigatorio')" . '"';
                                    echo "<tr>
                                      <td style='text-align:center; font-size:9pt; width:8%'>
                                        <i class='icofont icofont-edit nova_fonte' title='Editar procedimento.' onclick=$linkEditarProcedimento></i>&nbsp;                                      
                                        <i class='icofont icofont-close-squared nova_fonte_delete' title='Excluir item da lista.' onclick=$linkExcluirItem></i>
                                      </td>
                                      <td style='text-align:center; font-size:9pt;width:8%'>$codigoSUS</td>
                                      <td style='font-size:9pt'>$nomeProcedimento</td>
                                      <td style='font-size:9pt; text-align:center'>$procedimentoObrigatorio</td>
                                    </tr>";
                                  }
                                }
                              ?>
                            </tbody>
                          </table>
                        </div>
                      </div>
                    </div>
                  </div>
                </form>
              </div>
            </div>
          </div>
        </div>
      </div>
    </section>
  </div>
</div>
<div class="barra-flutuante">
  <button type='button' class='btn btn-danger' id='btnFechar' onClick='window.close()'>
    <i class='icofont icofont-exit'></i> Fechar
  </button>
</div>
<?php
include_once("footer.php");
include_once("include/box_pesquisa_procedimento.php");
?>
<script src="../app-assets/vendors/js/forms/extended/inputmask/jquery.inputmask.bundle.min.js"></script>
<script src="../app-assets/js/scripts/forms/extended/form-inputmask.min.js"></script>
<script src="../app-assets/vendors/js/tables/datatable/datatables.min.js"></script>
<script src="../app-assets/js/scripts/tables/datatables/datatable-basic.min.js"></script>
<script src="../app-assets/js/scripts/ui/jquery-ui/buttons-selects.min.js"></script>

<script>
  $('#dados_procedimento').DataTable({
    "paging": false,
    "filter": false,
    "lengthChange": false,
    "info": false
  });

  function pesquisaProcedimento() {

    if ($("#conteudoPesquisa").val() == "") {
      swal("Informação Obrigatória", "Você deve informar o procedimento que deseja pesquisar. Você pode digitaro código ou até parte do nome do procedimento.", 'error');
      return false;
    }
    $("#embacado").css("display", "block");
    $.ajax({
      url: 'filtros/filtrar_procedimento',
      type: 'post',
      dataType: 'html',
      data: {
        'opcaoPesquisa': 'cadastro-procedimento-oci',
        'conteudoPesquisa': $("#conteudoPesquisa").val()
      }
    }).done(function(resultadoRetorno) {
      $("#resultadoRetornoProcedimento").html(resultadoRetorno);
      $("#embacado").css("display", "none");
    });
  }

  function incluirItemLista() {

    if ($("#idProcedimentoAssociado").val() == "" || $("#procedimentoObrigatorio").val() == "") {
      swal("Dados Obrigatórios.", "Você deve informar o porcedimento que deseja associar à OCI e informar se é obrigatório para faturamento.", "error");
      return false;
    }

    $("#embacado").css("display", "block");
    $.ajax({
      url: 'action/gravar_procedimento_oci',
      type: 'post',
      dataType: 'html',
      data: {
        'idRegistroChave' : $("#idRegistroChave").val(),
        'idGrupoProcedimentoOCI': "<?php echo $idGrupoProcedimentoOCI; ?>",
        'idProcedimentoOCI': "<?php echo $idProcedimentoOCI; ?>",
        'idProcedimentoAssociado': $("#idProcedimentoAssociado").val(),
        'procedimentoObrigatorio' : $("#procedimentoObrigatorio").val()
      }
    }).done(function(resultadoRetorno) {
      $("#embacado").css("display", "none");
      if (resultadoRetorno == "jáExiste") {
        swal("Cadastro Duplicado.", "O procedimento selecionado já foi incluído na lista.", "error");
        return false;
      }

      $('#dados_procedimento').DataTable().destroy();
      $('#dados_procedimento tbody').empty().append(resultadoRetorno);
      $('#dados_procedimento').DataTable({
        "paging": false,
        "filter": false,
        "lengthChange": false,
        "info": false
      });
      $("#idRegistroChave").val('');
      $("#nomeProcedimentoAssociado").val('');      
      $("#idProcedimentoAssociado").val('');
      $("#procedimentoObrigatorio").val('');
      $("#btnCancelar").prop("disabled", true);
    });

  }

  function excluirItemLista(idItemLista) {


    Swal.fire({
      title: "Excluir Procedimento",
      html: "<p><font style='font-weight: bold; color: #a00404ff;'>ATENÇÃO!</font> Confirma exclusão do procedimento associado à OCI?</p>",      
      type: "question",
      showCancelButton: !0,
      confirmButtonText: "<i class='icofont icofont-checked'></i> SIM",
      confirmButtonClass: "btn btn-blue botao-confirmacao-swal",
      cancelButtonText: "<i class='fa fa-times'></i> Não",
      cancelButtonClass: "btn btn-danger ml-1 botao-negacao-swal",
      buttonsStyling: !1,
    }).then(function(retornoComando) {
      if (retornoComando.value) {
        $("#embacado").css("display", "block");
				$.ajax({
					url: 'action/excluir_registro',
					type: 'post',
					dataType: 'html',
					data: {
            'opcaoExclusao': 'procedimento-oci-associado',
            'idRegistroExclusao': idItemLista,
            'idProcedimentoOCI': "<?php echo $idProcedimentoOCI; ?>"
					}
				}).done(function(resultadoRetorno) {
          $("#embacado").css("display", "none");
          $('#dados_procedimento').DataTable().destroy();
          $('#dados_procedimento tbody').empty().append(resultadoRetorno);
          $('#dados_procedimento').DataTable({
            "paging": false,
            "filter": false,
            "lengthChange": false,
            "info": false
          });
          swal("Excluir Procedimento", "O procedimento selecionado foi excluído com sucesso.", "success");
				});
      }
    });
  }

  function abrirPesquisaProcedimento(){
    $("#conteudoPesquisa").val('');
    $("#resultadoRetornoProcedimento").html('');
    $('#box_pesquisa_procedimento').modal()
    setTimeout(() => {
      $("#conteudoPesquisa").focus();
    }, 500);
  }

  function editarProcedimentoOCI(conteudoEdicao){
    splitConteudoEdicao = conteudoEdicao.split("##");
    $("#idRegistroChave").val(splitConteudoEdicao[0]);
    $("#idProcedimentoAssociado").val(splitConteudoEdicao[1]);    
    $("#nomeProcedimentoAssociado").val(splitConteudoEdicao[2]);
    $("#procedimentoObrigatorio").val(splitConteudoEdicao[3]);
    $("#btnCancelar").prop("disabled", false);
  }

  $("#btnCancelar").click(function() {
    $("#idRegistroChave").val('');
    $("#nomeProcedimentoAssociado").val('');      
    $("#idProcedimentoAssociado").val('');
    $("#procedimentoObrigatorio").val('');
    $("#btnCancelar").prop("disabled", true);
  });

</script>