<?php
session_start();
if (!isset($_SESSION['idUsuarioLogado'])) {
	header("location: ./");
}
include_once("header.php"); //Cabeçalho padrão de todas as páginas
require("../database/dbConection.php");
?>
<div class="app-content content" style='background-color:#e1e9e7;'>
	<div class="content-wrapper" style='padding:10px;'>
		<section id="ordering">
			<div class="row">
				<div class="col-12">
					<div class="card" style='border:gray 1px solid;' id="card-tela">
						<div class="card-header titulo-telas">
							<i class="icofont icofont-stethoscope" style='margin-top:-15px !important'></i>&nbsp;Cadastro de Procedimentos
							<a class="heading-elements-toggle"><i class="fa fa-ellipsis-v font-medium-3"></i></a>
							<div class="heading-elements">
								<ul class="list-inline mb-0" style="margin-top: -12px; color: #fff;">
									<li>
										<a data-action="collapse"><i class="ft-minus"></i></a>
									</li>
									<li>
										<a data-action="expand"><i class="ft-maximize"></i></a>
									</li>
								</ul>
							</div>
						</div>
						<div class="card-content collapse show">
							<div class="card-body">
								<form class="form" style='margin-top:-10px'>
									<div class="form-body">
										<h4 class="form-section"><i class="ft-info"></i> <b>Dados de Idetificação</b>
											<input type="hidden" id="idProcedimento">
										</h4>
										<div class="row">
											<div class="col-md-5">
												<div class="form-group">
													<label for="grupoProcedimento">Grupo de Procedimentos:</label>
													<select class="form-control" id="grupoProcedimento" OnChange="filtrarProcedimentos()" autofocus>
														<option value=''>SELECIONE...</option>
														<?php
														$sqlGrupoProcedimentos	= "SELECT * FROM reg_tb_procedimento_grupo ORDER BY nome_grupo_procedimento";
														$stmGrupoProcedimentos  = $rsConexao->prepare($sqlGrupoProcedimentos);
														$stmGrupoProcedimentos->execute();
														$rsGrupoProcedimentos		= $stmGrupoProcedimentos->fetchAll(PDO::FETCH_ASSOC);
														foreach ($rsGrupoProcedimentos as $fieldGrupoProcedimentos) {
															$cogidoGrupo	= $fieldGrupoProcedimentos['id_grupo_procedimento'];
															$nomeGrupo		= $fieldGrupoProcedimentos['nome_grupo_procedimento'];
															echo "<option value='$cogidoGrupo'>$nomeGrupo</option>";
														}
														?>
													</select>
												</div>
											</div>
											<div class="col-md-7">
												<div class="form-group">
													<fieldset id='field-cbo'>
														<label for="procedimentoSIGTAP">Procedimento SIGTAP:</label>
														<div class="input-group">
															<input type="text" id="procedimentoSIGTAP" class="form-control" disabled>
															<div class="input-group-prepend">
																<button class="btn btn-blue" type="button" onclick="abrirJanelaSIGTAP()">
																	<i class="icofont icofont-search"></i>
																</button>
															</div>
														</div>
													</fieldset>
												</div>
											</div>
										</div>
										<div class="row">
											<div class="col-md-3">
												<div class="form-group">
													<label for="codigoSIGTAP">Código SIGTAP:</label>
													<input type="text" id="codigoSIGTAP" class="form-control text-center" disabled>
												</div>
											</div>
											<div class="col-md-3">
												<div class="form-group">
													<label for="codigoESUS">Código e-SUS PEC:</label>
													<input type="text" id="codigoESUS" class="form-control text-center">
												</div>
											</div>
											<div class="col-md-3">
												<div class="form-group">
													<label for="valorSUS">Valor SUS:</label>
													<input type="text" id="valorSUS" class="form-control text-right" disabled>
												</div>
											</div>
											<div class="col-md-3">
												<div class="form-group">
													<label for="valorVigente">Valor Vigente:</label>
													<input type="text" id="valorVigente" class="form-control text-right">
												</div>
											</div>
										</div>
										<div class="row" style='margin-top:-10px'>
											<div class="col-md-12">
												<div class="form-group">
													<label for="nomeProcedimentoGSaude">Nome no G-Saúde Regulação:</label>
													<input type="text" id="nomeProcedimentoGSaude" class="form-control">
												</div>
											</div>
										</div>
										<div class="row" style='margin-top:-5px'>
											<div class="col-md-3">
												<div class="form-group">
													<label for="sexoPermitido">Sexo Permitido:</label>
													<select id="sexoPermitido" class="form-control">
														<option value="">SELECIONE...</option>
														<option value="I">INDIFERENTE</option>
														<option value="M">MASCULINO</option>
														<option value="F">FEMININO</option>
													</select>
												</div>
											</div>
											<div class="col-md-6">
												<div class="form-group">
													<label for="idadeInicialPermitida">Faixa Etária Permitida (Idade Inicial e Idade Final):</label>
													<table width='100%'>
														<tr>
															<td>
																<input type='text' id="idadeInicialPermitida" class="form-control text-center">
															</td>
															<td>
																<input type='text' id="idadeFinalPermitida" class="form-control text-center">
															</td>
														</tr>
													</table>
												</div>
											</div>
											<div class="col-md-3">
												<div class="form-group">
													<label for="procedimentoDisponivelGuiche">Disponível no Guichê/Unidade:</label>
													<select id="procedimentoDisponivelGuiche" class="form-control">
														<option value="">SELECIONE...</option>
														<option value="S">SIM</option>
														<option value="N">NÃO</option>
													</select>
												</div>
											</div>
										</div>
										<div class="row" style='margin-top:-5px'>
											<div class="col-md-12">
												<div class="form-group">
													<label for="preparoProcedimento">Preparos:</label>
													<textarea id="preparoProcedimento" class="form-control" rows='4'></textarea>
												</div>
											</div>
										</div>
										<div class="row" style='margin-top:-5px'>
											<div class="col-md-12">
												<div class="form-group">
													<label for="observacaoProcedimento">Observações:</label>
													<textarea id="observacaoProcedimento" class="form-control" rows='4'></textarea>
												</div>
											</div>
										</div>
									</div>
									<div class="row" style='margin-top:-35px'>
										<div class="col-md-4">
											<label></label><br>
											<button type="button" class="btn btn-info" onClick="cadastrarProcedimento()">
												<i class="icofont icofont-checked"></i> Confirmar
											</button>
											<button type="button" class="btn btn-danger" id="btnCancelar" onClick="cancelarAlteracao()" disabled>
												<i class="fa fa-times"></i> Cancelar
											</button>
										</div>
									</div>
									<br>
									<div class="form-body" style="border-top:1px dotted gray;">
										<h4 class="form-section"><i class="ft-list"></i> <b>Lista de procedimentos cadastrados</b></h4>
										<div class="form-actions" style="margin-top:-15px !important"></div>
								</form>
							</div>
						</div>
						<div class="card-content collapse show" style="margin-top:-65px !important">
							<div class="card-body card-dashboard">
								<table class="table table-striped table-bordered default-ordering" id='dados_procedimentos'>
									<thead>
										<th style='text-align:center' width='100px'>OPÇÕES</th>
										<th>NOME DO PROCEDIMENTO</th>
										<th style='text-align:center' width='150px'>CÓD. SIGTAP</th>
										<th style='text-align:center' width='150px'>CÓD E-SUS</th>
										<th style='text-align:center' width='150px'>SEXO</th>
										<th style='text-align:center' width='100px'>FX ETÁRIA</th>
										<th style='text-align:center' width='100px'>VALOR VIGENTE</th>
										<th style='text-align:center' width='100px'>GUICHÊ</th>
										</tr>
									</thead>
									<tbody style="background-color:#ececec">
									</tbody>
								</table>
							</div>
						</div>
					</div>
				</div>
		</section>
	</div>
</div>
<?php
include_once("footer.php");
include_once("include/box_pesquisa_procedimento.php");
?>
<script src="../app-assets/vendors/js/forms/extended/inputmask/jquery.inputmask.bundle.min.js"></script>
<script src="../app-assets/js/scripts/forms/extended/form-inputmask.min.js"></script>
<script src="../app-assets/vendors/js/tables/datatable/datatables.min.js"></script>
<script src="../app-assets/js/scripts/tables/datatables/datatable-basic.min.js"></script>
<script src="../app-assets/js/scripts/ui/jquery-ui/buttons-selects.min.js"></script>

<script>
	$("#liProcedimentos").attr('class', 'active');
	$("#liProcedimentos").css("border-bottom", "2px solid #c4c8ca");

	new nicEditor({
		buttonList: ['bold', 'italic', 'underline', 'left', 'center', 'right', 'indent', 'outdent', 'ol', 'ul', 'hr', 'forecolor']
	}).panelInstance('observacaoProcedimento');

	function abrirJanelaSIGTAP() {
		$("#conteudoPesquisa").val('')
		$("#resultadoRetornoProcedimento").html('');
		$('#box_pesquisa_procedimento').modal();
		setTimeout(function(){ 
			$("#conteudoPesquisa").focus();
		}, 600);
	}

	function pesquisaProcedimento() {
		if ($("#conteudoPesquisa").val() == "") {
			swal("Informação Obrigatória", "Você deve informar o procedimento que deseja pesquisar. Você pode digitaro código ou até parte do nome do procedimento.", 'error');
			return false;
		}
		$("#embacado").css("display", "block");
		$.ajax({
			url: 'filtros/filtrar_procedimento',
			type: 'post',
			dataType: 'html',
			data: {
				'opcaoPesquisa': 'cadastro-procedimento-sigtap',
				'conteudoPesquisa': $("#conteudoPesquisa").val()
			}
		}).done(function(resultadoRetorno) {
			$("#resultadoRetornoProcedimento").html(resultadoRetorno);
			$("#embacado").css("display", "none");
		});
	}

	function cadastrarProcedimento() {

		if ($("#grupoProcedimento").val() == "" || $("#procedimentoSIGTAP").val() == "" || $("#valorVigente").val() == "" || $("#nomeProcedimentoGSaude").val() == "" || $("#codigoSIGTAP").val() == "" || $("#sexoPermitido").val() == "" || $("#idadeInicialPermitida").val() == "" || $("#procedimentoDisponivelGuiche").val() == "" || $("#procedimentoDisponivelGuiche").val() == "") {
			swal("Dados Obrigatórios", "Você deve preencher todos os campos para cadastrar o procedimento.", "error");
			return false;
		}

		$("#embacado").css("display", "block");

		$.ajax({
			url: 'action/gravar_procedimento',
			type: 'post',
			dataType: 'html',
			data: {
				'idProcedimento': $("#idProcedimento").val(),
				'grupoProcedimento': $("#grupoProcedimento").val(),
				'nomeProcedimento': $("#nomeProcedimentoGSaude").val(),
				'codigoSIGTAP': $("#codigoSIGTAP").val(),
				'codigoESUS'	: $("#codigoESUS").val(),
				'valorVigente': $("#valorVigente").val(),
				'sexoPermitido': $("#sexoPermitido").val(),
				'idadeInicialPermitida': $("#idadeInicialPermitida").val(),
				'idadeFinalPermitida': $("#idadeFinalPermitida").val(),
				'procedimentoDisponivelGuiche': $("#procedimentoDisponivelGuiche").val(),
				'preparoProcedimento': $("#preparoProcedimento").val(),
				'observacaoProcedimento': nicEditors.findEditor('observacaoProcedimento').getContent()
			}
		}).done(function(resultadoRetorno) {

			$("#embacado").css("display", "none");

			if (resultadoRetorno == "JaExiste") {
				swal("Registro Existente", "Já existe um procedimento cadastrado com o nome informado.", "info");
				return false;
			} else {

				$('#dados_procedimentos').DataTable().destroy();
				$('#dados_procedimentos tbody').empty().append(resultadoRetorno);
				$('#dados_procedimentos').DataTable();

				$("#idProcedimento").val('');
				$("#procedimentoSIGTAP").val('');
				$("#codigoSIGTAP").val('');
				$("#codigoESUS").val('');
				$('#valorSUS').val('');
				$("#valorVigente").val('');
				$("#nomeProcedimentoGSaude").val('');
				$("#sexoPermitido").val('');
				$("#idadeInicialPermitida").val('');
				$("#idadeFinalPermitida").val('');
				$("#procedimentoDisponivelGuiche").val('');
				$("#preparoProcedimento").val('');
				nicEditors.findEditor('observacaoProcedimento').setContent('');
				$('#btnCancelar').prop('disabled', true);

			}

		});

	}

	function editarProcedimento(conteudoEdicao) {

		var splitConteudo = conteudoEdicao.split("#");
		$("#idProcedimento").val(splitConteudo[0]);
		$("#procedimentoSIGTAP").val(splitConteudo[1]);
		$("#codigoSIGTAP").val(splitConteudo[2]);
		$("#codigoESUS").val(splitConteudo[3]);
		$('#valorSUS').val(splitConteudo[4]);
		$("#valorVigente").val(splitConteudo[5]);
		$("#nomeProcedimentoGSaude").val(splitConteudo[6]);
		$("#sexoPermitido").val(splitConteudo[7]);
		$("#idadeInicialPermitida").val(splitConteudo[8]);
		$("#idadeFinalPermitida").val(splitConteudo[9]);
		$("#procedimentoDisponivelGuiche").val(splitConteudo[10]);
		$('#btnCancelar').prop('disabled', false);

		$.ajax({
			url: 'filtros/filtrar_procedimento',
			type: 'post',
			dataType: 'html',
			data: {
				'opcaoPesquisa': 'buscar_observacao',
				'idProcedimento': splitConteudo[0]
			}
		}).done(function(resultadoRetorno) {
			if (resultadoRetorno != "NÃOEXISTE" && resultadoRetorno != "NãoExiste") {
				nicEditors.findEditor('observacaoProcedimento').setContent(resultadoRetorno);
			}
		});

		$.ajax({
			url: 'filtros/filtrar_procedimento',
			type: 'post',
			dataType: 'html',
			data: {
				'opcaoPesquisa': 'buscar_preparo',
				'idProcedimento': splitConteudo[0]
			}
		}).done(function(resultadoRetorno) {
			$("#preparoProcedimento").val(resultadoRetorno);
		});

	}


	function cancelarAlteracao() {
		$("#idProcedimento").val('');
		$("#procedimentoSIGTAP").val('');
		$("#codigoSIGTAP").val('');
		$("#codigoESUS").val('');
		$('#valorSUS').val('');
		$("#valorVigente").val('');
		$("#nomeProcedimentoGSaude").val('');
		$("#sexoPermitido").val('');
		$("#idadeInicialPermitida").val('');
		$("#idadeFinalPermitida").val('');
		$("#procedimentoDisponivelGuiche").val('');
		$("#preparoProcedimento").val('');
		$('#btnCancelar').prop('disabled', true);
		nicEditors.findEditor('observacaoProcedimento').setContent('');
	}

	function filtrarProcedimentos() {

		var grupoProcedimento = $("#grupoProcedimento").val();

		$("#embacado").css("display", "block");

		$.ajax({
			url: 'filtros/filtrar_procedimento',
			type: 'post',
			dataType: 'html',
			data: {
				'opcaoPesquisa': 'cadastrar-procedimento',
				'grupoProcedimento': grupoProcedimento
			}
		}).done(function(resultadoRetorno) {
			$('#dados_procedimentos').DataTable().destroy();
			$('#dados_procedimentos tbody').empty().append(resultadoRetorno);
			$('#dados_procedimentos').DataTable();
			$("#embacado").css("display", "none");

		});

		$("#idProcedimento").val('');
		$("#procedimentoSIGTAP").val('');
		$("#codigoSIGTAP").val('');
		$('#valorSUS').val('');
		$("#valorVigente").val('');
		$("#nomeProcedimentoGSaude").val('');
		$("#sexoPermitido").val('');
		$("#idadeInicialPermitida").val('');
		$("#idadeFinalPermitida").val('');
		$("#procedimentoDisponivelGuiche").val('');
		$("#preparoProcedimento").val('');
		nicEditors.findEditor('observacaoProcedimento').setContent('');

	}

	function excluirProcedimento(idProcedimento) {

		swal({
			title: "Exclusão de Registro",
			text: "Confirma exclusão do procedimento selecionado?",
			icon: "../app-assets/images/question.png",

			buttons: {
				confirm: {
					text: "Sim, Confirmar!",
					value: true,
					visible: true,
					className: "btn-success",
					closeModal: false
				},
				cancel: {
					text: "Não, Foi engano!",
					value: null,
					visible: true,
					className: "btn-danger",
					closeModal: false,
				}
			}

		}).then((isConfirm) => {

			if (isConfirm) {
				$.ajax({
					url: 'action/excluir_registro',
					type: 'post',
					dataType: 'html',
					data: {
						'opcaoExclusao': 'procedimento_cadastrado',
						'idRegistroExclusao': idProcedimento,
						'grupoProcedimento': $("#grupoProcedimento").val()
					}
				}).done(function(resultadoRetorno) {

					if (resultadoRetorno == "ExisteDemanda") {
						swal("Registro Existente", "Não é possível excluir o cadastro do procedimento. Já existe registro de agendamento para este procedimento.", "info");
						return false;
					} else {
						$('#dados_procedimentos').DataTable().destroy();
						$('#dados_procedimentos tbody').empty().append(resultadoRetorno);
						$('#dados_procedimentos').DataTable();
						$("#embacado").css("display", "none");
						swal("Exclusão de Registro.", "Exclusão de procedimento realizada com sucesso.", "info");
					}
				});

			} else {
				swal("Operação Cancelada.", "O registro selecionado não foi excluído.", "info");
			}

		});

	}

  function procedimentoAssociadoOCI(idProcedimento){
    window.open("cadastrar_procedimento_oci?idp="+idProcedimento);
  }

	$('#valorSUS').mask('#.##0,00', {
		reverse: true
	});
	$('#valorVigente').mask('#.##0,00', {
		reverse: true
	});
</script>