<?php
session_start();
if (!isset($_SESSION['idUsuarioLogado']) || $_SESSION['idPerfilLogado'] != '1') {
	header("location: ./");
}
include_once("header-clean.php");
$dataHoje   = date("Y-m-d");

$formatarPerfil = array(
	'A'	=> 'AMBOS',
	'E'	=> 'EXECUTANTE',
	'S'	=> 'SOLICITANTE',
	''	=> 'NÃO INFORMADO'
);

$idEstabelecimento				= $_GET['id'];
$stmDadosEstabelecimento	=	$rsConexao->prepare("SELECT * FROM tb_estabelecimento WHERE codigoestabelecimento_cnes='$idEstabelecimento'");
$stmDadosEstabelecimento->execute();
$rsDadosEstabelecimento		= $stmDadosEstabelecimento->fetch(PDO::FETCH_OBJ);
$nomeEstabelecimento			= mb_strtoupper($rsDadosEstabelecimento->nfantasia_estabelecimento);
$cnesEstabelecimento			= $rsDadosEstabelecimento->cnes_estabelecimento;
$bairroEstabelecimento		= mb_strtoupper($rsDadosEstabelecimento->bairro_estabelecimento);
$perfilEstabelecimento		= $formatarPerfil[$rsDadosEstabelecimento->perfil_estabelecimento];
# --- --- --- --- --- --- --- --- --- --- --- --- --- --- --- --- --- --#
?>

<div class="app-content content" style="background-color: #e1e9e7;">
	<div class="content-wrapper" style="padding: 10px;">
		<section id="ordering">
			<div class="row">
				<div class="col-12">
					<div class="card" style="border: gray 1px solid;" id="card-tela">
						<div class="card-header titulo-telas">
							<i class="icofont icofont-building-alt" style='margin-top:-15px !important'></i>&nbsp;Cadastro de Unidades de Referência
							<a class="heading-elements-toggle"><i class="fa fa-ellipsis-v font-medium-3"></i></a>
							<div class="heading-elements">
								<ul class="list-inline mb-0" style="margin-top: -12px; color: #fff;">
									<li>
										<a data-action="collapse"><i class="ft-minus"></i></a>
									</li>
									<li>
										<a data-action="expand"><i class="ft-maximize"></i></a>
									</li>
								</ul>
							</div>
						</div>
						<div class="card-content collapse show">
							<div class="card-body">
								<form class="form">
									<div class="form-body">
										<h4 class="form-section" style='margin-top:-10px'>
											<i class="icofont icofont-edit"></i><b>Dados do Setor</b>
										</h4>
										<div class="row">
											<div class="col-md-4">
												<div class="form-group">
													<label for="nomeEstabelecimento">Nome do Estabelecimento:</label>
													<input type="text" id="nomeEstabelecimento" class="form-control text-uppercase" value="<?php echo $nomeEstabelecimento; ?>" disabled />
												</div>
											</div>
											<div class="col-md-2">
												<div class="form-group">
													<label for="cnesEstabelecimento">Nº do CNES:</label>
													<input type="text" id="cnesEstabelecimento" class="form-control text-center" value="<?php echo $cnesEstabelecimento; ?>" disabled />
												</div>
											</div>
											<div class="col-md-3">
												<div class="form-group">
													<label for="bairroEstabelecimento">Bairro/Localidade:</label>
													<input type="text" id="bairroEstabelecimento" class="form-control" value="<?php echo $bairroEstabelecimento; ?>" disabled />
												</div>
											</div>
											<div class="col-md-3">
												<div class="form-group">
													<label for="perfilEstabelecimento">Perfil do Estabelecimento:</label>
													<input type="text" id="perfilEstabelecimento" class="form-control" value="<?php echo $perfilEstabelecimento; ?>" disabled />
												</div>
											</div>
										</div>
										<div class="row" style="margin-top:-5px;">
											<div class="col-md-5">
												<div class="form-group">
													<label for="unidadeReferencia">Unidade de Referência:</label>
													<select type="text" id="unidadeReferencia" class="form-control">
														<option value=''>SELECIONE A UNIDADE DE SAÚDE...</option>
														<?php
														$sqlEstabelecimento = "SELECT * FROM tb_estabelecimento 
														WHERE (status_estabelecimento='A') 
														AND (codigoestabelecimento_cnes!='9999999999999')
														AND (perfil_estabelecimento='A' OR perfil_estabelecimento='E')
														ORDER BY nfantasia_estabelecimento";
														$stmUnidadeSaude  = $rsConexao->prepare($sqlEstabelecimento);
														$stmUnidadeSaude->execute();
														if ($stmUnidadeSaude->rowcount() > 0) {
															$rsUnidadeSaude   = $stmUnidadeSaude->fetchAll(PDO::FETCH_ASSOC);
															foreach ($rsUnidadeSaude as $fieldUnidade) {
																$idUnidade    = $fieldUnidade['codigoestabelecimento_cnes'];
																$nomeUnidade  = $fieldUnidade['nfantasia_estabelecimento'];
																echo "<option value='$idUnidade'>$nomeUnidade</option>";
															}
														}
														?>
													</select>
												</div>
											</div>
											<div class="col-md-7">
												<div class="form-group">
													<label for="enderecoUnidade">Endereço:</label>
													<input type="text" id="enderecoUnidade" class="form-control" disabled />
												</div>
											</div>
										</div>
										<div class="row" style="margin-top:-5px;">
											<div class="col-md-4">
												<div class="form-group">
													<button type="button" class="btn btn-blue" onClick="salvarUnidade()"><i class="icofont icofont-checked"></i> Incluir</button>
												</div>
											</div>
										</div>
										<hr style='margin-top:-10px'>
										<div class="row" style="margin-top:-15px;">
											<div class="col-md-12">
												<div class="form-group">
													<table class="table table-striped table-bordered default-ordering" id="dados_unidadesreferencia" style="font-size: 9pt !important;">
														<thead>
															<tr style="background-repeat: repeat-x; height: 30px !important;">
																<th style="text-align: center; width:5%">OPÇÃO</th>
																<th style="width:25%">NOME DA UNIDADE DE REFERÊNCIA</th>
																<th style="width:100px; text-align:center">CNES</th>
																<th>ENDEREÇO COMPLETO</th>
															</tr>
														</thead>
														<tbody style="background-color: #f6f6f6;">
															<?php
															$sqlUnidadeReferencia = "SELECT reg_tb_unidadereferencia.id_unidadereferencia,
															reg_tb_unidadereferencia.codigo_estabelecimento_referencia,
															tb_estabelecimento.nfantasia_estabelecimento,
															tb_estabelecimento.cnes_estabelecimento,
															concat(endereco_estabelecimento,', ',numeroend_estabelecimento,', ',bairro_estabelecimento,' -> MUNICÍPIO: ',nome_cidade) as enderecoUnidade
															FROM reg_tb_unidadereferencia
															INNER JOIN tb_estabelecimento ON (reg_tb_unidadereferencia.codigo_estabelecimento_referencia =tb_estabelecimento.codigoestabelecimento_cnes)
															INNER JOIN tb_cidades ON (tb_cidades.codigoibge_cidade = tb_estabelecimento.codigoibge_cidade)
															WHERE (reg_tb_unidadereferencia.codigo_estabelecimento_base = '$idEstabelecimento')";

															$stmUnidadeReferencia	= $rsConexao->prepare($sqlUnidadeReferencia);
															$stmUnidadeReferencia->execute();
															if ($stmUnidadeReferencia->rowCount() > 0) {
																$rsUnidadeReferencia	= $stmUnidadeReferencia->fetchAll(PDO::FETCH_ASSOC);
																foreach ($rsUnidadeReferencia as $fieldUnidadeReferencia) {
																	$idUnidadeReferencia			= $fieldUnidadeReferencia['id_unidadereferencia'];
																	$codigoUnidadeReferencia	= $fieldUnidadeReferencia['codigo_estabelecimento_referencia'];
																	$nomeUnidadeReferencia		= mb_strtoupper($fieldUnidadeReferencia['nfantasia_estabelecimento']);
																	$cnesUnidadeReferencia		= $fieldUnidadeReferencia['cnes_estabelecimento'];
																	$enderecoUnidade					= mb_strtoupper($fieldUnidadeReferencia['enderecoUnidade']);

																	$linkExcluirUnidade	= '"excluirUnidadeReferencia(' . "'$idUnidadeReferencia','$idEstabelecimento')" . '"';
																	echo "<tr>
																			<td align='center'>
																				<i class='icofont icofont-close-squared nova_fonte_delete' title='Bloquear setor.' onclick=$linkExcluirUnidade></i>
																			</td>
																			<td>$nomeUnidadeReferencia</td>
																			<td align='center'>$cnesUnidadeReferencia</td>
																			<td>$enderecoUnidade</td>
																		</tr>";
																}
															}
															?>
														</tbody>
													</table>
												</div>
											</div>
										</div>
									</div>
								</form>
							</div>
						</div>
					</div>
				</div>
			</div>
		</section>
	</div>
</div>
<div class="barra-flutuante">
	<button type='button' class='btn btn-danger' id='btnFechar' onClick='window.close()'>
		<i class='icofont icofont-exit'></i> Fechar
	</button>
</div>
<?php
include_once("footer.php");
?>
<script src="../app-assets/vendors/js/forms/extended/inputmask/jquery.inputmask.bundle.min.js"></script>
<script src="../app-assets/js/scripts/forms/extended/form-inputmask.min.js"></script>
<script src="../app-assets/vendors/js/tables/datatable/datatables.min.js"></script>
<script src="../app-assets/js/scripts/tables/datatables/datatable-basic.min.js"></script>
<script src="../app-assets/js/scripts/ui/jquery-ui/buttons-selects.min.js"></script>

<script>
	$('#dados_unidadesreferencia').DataTable({
		"paging": false,
		"filter": false,
		"lengthChange": false,
		"info": false
	});


	function excluirUnidadeReferencia(idUnidade, unidadeBase) {
		
		swal({
			title: "Excluir Unidade",
			text: "Confirma exclusão da unidade de referência?",
			icon: "../app-assets/images/question.png",

			buttons: {
				confirm: {
					text: "Sim, Confirmar!",
					value: true,
					visible: true,
					className: "btn-success",
					closeModal: false
				},
				cancel: {
					text: "Não, Foi engano!",
					value: null,
					visible: true,
					className: "btn-danger",
					closeModal: false,
				}
			}

		}).then((isConfirm) => {

			if (isConfirm) {
				$.ajax({
					url: 'action/excluir_registro',
					type: 'post',
					dataType: 'html',
					data: {
						'opcaoExclusao': 'excluir-unidade-referencia',
						'idRegistroExclusao': idUnidade,
						'idUnidadeBase': unidadeBase
					}
				}).done(function(resultadoRetorno) {

					$('#dados_unidadesreferencia').DataTable().destroy();
					$('#dados_unidadesreferencia tbody').empty().append(resultadoRetorno);
					$('#dados_unidadesreferencia').DataTable({
						"paging": false,
						"filter": false,
						"lengthChange": false,
						"info": false
					});
					$("#embacado").css("display", "none");
					swal("Excluir Unidade", "A unidade de referência foi excluída e não estará mais disponível para agendamento.", "success");

					$("#unidadeReferencia").val('');
					$("#enderecoUnidade").val('');
				});

			} else {
				swal("Operação Cancelada.", "A unidade não foi excluída.", "info");
			}

		});

	}

	function salvarUnidade() {

		if ($("#unidadeReferencia").val() == "") {
			swal("Dados Obrigatórios.", "Selecione a unidade de referência para realizar a inclusão.", "error");
			return false;
		}

		$("#embacado").css("display", "block");
		$.ajax({
			url: 'action/gravar_estabelecimento',
			type: 'post',
			dataType: 'html',
			data: {
				'opcaoCadastro': 'cadastrar-estabelecimento-unidadereferencia',
				'unidadeReferencia' : $("#unidadeReferencia").val(),
				'idUnidadeBase': "<?php echo $idEstabelecimento; ?>"
			}
		}).done(function(resultadoRetorno) {
			$("#embacado").css("display", "none");

			if (resultadoRetorno == "jáExiste") {
				swal("Cadastro Duplicado.", "Unidade de referência já cadastrada para este estabelecimento.", "error");
				return false;
			}
			$('#dados_unidadesreferencia').DataTable().destroy();
			$('#dados_unidadesreferencia tbody').empty().append(resultadoRetorno);
			$('#dados_unidadesreferencia').DataTable({
				"paging": false,
				"filter": false,
				"lengthChange": false,
				"info": false
			});
			$("#embacado").css("display", "none");			
			$("#unidadeReferencia").val('');
			$("#enderecoUnidade").val('');
			swal("Cadastro de Setor.", "Unidade cadastrada com sucesso.", "success");			
		});

	}

	$("#unidadeReferencia").change(function() {
		if(this.value!=""){
			$.ajax({
				url: 'filtros/filtrar_unidadesaude',
				type: 'post',
				dataType: 'html',
				data: {
					'opcaoFiltro' : 'unidade-referencia-endereco',
					'idUnidade': this.value
				}
			}).done(function(resultadoRetorno) {
				$("#enderecoUnidade").val(resultadoRetorno);
			});
		}else{
			$("#enderecoUnidade").val('');
		}
	})
</script>