<?php
session_start();
if (!isset($_SESSION['idUsuarioLogado']) || $_SESSION['idPerfilLogado'] != '1') {
	header("location: ./");
}
include_once("header-clean.php");
$dataHoje   = date("Y-m-d");

$idProcedimentoOCI  = $_GET['idoci'];
$sqlProcedimentoOCI	=	"SELECT reg_tb_procedimento_grupo.nome_grupo_procedimento,
reg_tb_procedimento.id_procedimento,
reg_tb_procedimento.nome_procedimento,
reg_tb_procedimento.codigo_sus
FROM reg_tb_procedimento_grupo
INNER JOIN reg_tb_procedimento ON (reg_tb_procedimento_grupo.id_grupo_procedimento = reg_tb_procedimento.id_grupo_procedimento)
WHERE id_procedimento='$idProcedimentoOCI'";
$stmProcedimentoOCI = $rsConexao->prepare($sqlProcedimentoOCI);
$stmProcedimentoOCI->execute();
$rsProcedimentoOCI  = $stmProcedimentoOCI->fetch(PDO::FETCH_OBJ);
$nomeGrupoProcedimento  = mb_strtoupper($rsProcedimentoOCI->nome_grupo_procedimento);
$nomeProcedimento = $rsProcedimentoOCI->codigo_sus.' - '.mb_strtoupper($rsProcedimentoOCI->nome_procedimento);
# --- --- --- --- --- --- --- --- --- --- --- --- --- --- --- --- --- --#
?>

<div class="app-content content" style="background-color: #e1e9e7;">
	<div class="content-wrapper" style="padding: 10px;">
		<section id="ordering">
			<div class="row">
				<div class="col-12">
					<div class="card" style="border: gray 1px solid;" id="card-tela">
						<div class="card-header titulo-telas">
							<i class="icofont icofont-building-alt" style='margin-top:-15px !important'></i>&nbsp;Cadastro de Executores de OCI
							<a class="heading-elements-toggle"><i class="fa fa-ellipsis-v font-medium-3"></i></a>
							<div class="heading-elements">
								<ul class="list-inline mb-0" style="margin-top: -12px; color: #fff;">
									<li>
										<a data-action="collapse"><i class="ft-minus"></i></a>
									</li>
									<li>
										<a data-action="expand"><i class="ft-maximize"></i></a>
									</li>
								</ul>
							</div>
						</div>
						<div class="card-content collapse show">
							<div class="card-body">
								<form class="form">
									<div class="form-body">
										<h4 class="form-section" style='margin-top:-10px'>
											<i class="icofont icofont-edit"></i><b>Dados do Procedimento OCI</b>
										</h4>
										<div class="row">
											<div class="col-md-4">
												<div class="form-group">
													<label for="grupoProcedimento">Nome do Grupo Procedimento:</label>
													<input type="text" id="grupoProcedimento" class="form-control text-uppercase" value="<?php echo $nomeGrupoProcedimento; ?>" disabled />
												</div>
											</div>
											<div class="col-md-8">
												<div class="form-group">
													<label for="nomeProcedimento">Nome do Procedimento:</label>
													<input type="text" id="nomeProcedimento" class="form-control" value="<?php echo $nomeProcedimento; ?>" disabled />
												</div>
											</div>
										</div>
										<div class="row" style="margin-top:-5px;">
											<div class="col-md-5">
												<div class="form-group">
													<label for="unidadeReferencia">Unidade de Referência:</label>
													<select type="text" id="unidadeReferencia" class="form-control">
														<option value=''>SELECIONE A UNIDADE DE SAÚDE...</option>
														<?php
														$sqlEstabelecimento = "SELECT * FROM tb_estabelecimento 
														WHERE (status_estabelecimento='A') 
														AND (codigoestabelecimento_cnes!='9999999999999')
														AND (perfil_estabelecimento='A' OR perfil_estabelecimento='E')
														ORDER BY nfantasia_estabelecimento";
														$stmUnidadeSaude  = $rsConexao->prepare($sqlEstabelecimento);
														$stmUnidadeSaude->execute();
														if ($stmUnidadeSaude->rowcount() > 0) {
															$rsUnidadeSaude   = $stmUnidadeSaude->fetchAll(PDO::FETCH_ASSOC);
															foreach ($rsUnidadeSaude as $fieldUnidade) {
																$idUnidade    = $fieldUnidade['codigoestabelecimento_cnes'];
																$nomeUnidade  = $fieldUnidade['nfantasia_estabelecimento'];
																echo "<option value='$idUnidade'>$nomeUnidade</option>";
															}
														}
														?>
													</select>
												</div>
											</div>
											<div class="col-md-7">
												<div class="form-group">
													<label for="enderecoUnidade">Endereço:</label>
													<input type="text" id="enderecoUnidade" class="form-control" disabled />
												</div>
											</div>
										</div>
										<div class="row" style="margin-top:-5px;">
											<div class="col-md-4">
												<div class="form-group">
													<button type="button" class="btn btn-blue" onClick="salvarUnidade()"><i class="icofont icofont-checked"></i> Incluir</button>
												</div>
											</div>
										</div>
										<hr style='margin-top:-10px'>
										<div class="row" style="margin-top:-15px;">
											<div class="col-md-12">
												<div class="form-group">
													<table class="table table-striped table-bordered default-ordering" id="dados_executoroci" style="font-size: 9pt !important;">
														<thead>
															<tr style="background-repeat: repeat-x; height: 30px !important;">
																<th style="text-align: center; width:5%">OPÇÃO</th>
																<th style="width:25%">NOME DA UNIDADE DE REFERÊNCIA</th>
																<th style="width:100px; text-align:center">CNES</th>
																<th>ENDEREÇO COMPLETO</th>
															</tr>
														</thead>
														<tbody style="background-color: #f6f6f6;">
															<?php															
															?>
														</tbody>
													</table>
												</div>
											</div>
										</div>
									</div>
								</form>
							</div>
						</div>
					</div>
				</div>
			</div>
		</section>
	</div>
</div>
<div class="barra-flutuante">
	<button type='button' class='btn btn-danger' id='btnFechar' onClick='window.close()'>
		<i class='icofont icofont-exit'></i> Fechar
	</button>
</div>
<?php
include_once("footer.php");
?>
<script src="../app-assets/vendors/js/forms/extended/inputmask/jquery.inputmask.bundle.min.js"></script>
<script src="../app-assets/js/scripts/forms/extended/form-inputmask.min.js"></script>
<script src="../app-assets/vendors/js/tables/datatable/datatables.min.js"></script>
<script src="../app-assets/js/scripts/tables/datatables/datatable-basic.min.js"></script>
<script src="../app-assets/js/scripts/ui/jquery-ui/buttons-selects.min.js"></script>

<script>
	$('#dados_executoroci').DataTable({
		"paging": false,
		"filter": false,
		"lengthChange": false,
		"info": false
	});


	function excluirUnidadeReferencia(idUnidade, unidadeBase) {
		
		swal({
			title: "Excluir Unidade",
			text: "Confirma exclusão da unidade de referência?",
			icon: "../app-assets/images/question.png",

			buttons: {
				confirm: {
					text: "Sim, Confirmar!",
					value: true,
					visible: true,
					className: "btn-success",
					closeModal: false
				},
				cancel: {
					text: "Não, Foi engano!",
					value: null,
					visible: true,
					className: "btn-danger",
					closeModal: false,
				}
			}

		}).then((isConfirm) => {

			if (isConfirm) {
				$.ajax({
					url: 'action/excluir_registro',
					type: 'post',
					dataType: 'html',
					data: {
						'opcaoExclusao': 'excluir-unidade-referencia',
						'idRegistroExclusao': idUnidade,
						'idUnidadeBase': unidadeBase
					}
				}).done(function(resultadoRetorno) {

					$('#dados_unidadesreferencia').DataTable().destroy();
					$('#dados_unidadesreferencia tbody').empty().append(resultadoRetorno);
					$('#dados_unidadesreferencia').DataTable({
						"paging": false,
						"filter": false,
						"lengthChange": false,
						"info": false
					});
					$("#embacado").css("display", "none");
					swal("Excluir Unidade", "A unidade de referência foi excluída e não estará mais disponível para agendamento.", "success");

					$("#unidadeReferencia").val('');
					$("#enderecoUnidade").val('');
				});

			} else {
				swal("Operação Cancelada.", "A unidade não foi excluída.", "info");
			}

		});

	}

	function salvarUnidade() {

		if ($("#unidadeReferencia").val() == "") {
			swal("Dados Obrigatórios.", "Selecione a unidade de referência para realizar a inclusão.", "error");
			return false;
		}

		$("#embacado").css("display", "block");
		$.ajax({
			url: 'action/gravar_estabelecimento',
			type: 'post',
			dataType: 'html',
			data: {
				'opcaoCadastro': 'cadastrar-estabelecimento-unidadereferencia',
				'unidadeReferencia' : $("#unidadeReferencia").val(),
				'idUnidadeBase': "<?php echo ''; ?>"
			}
		}).done(function(resultadoRetorno) {
			$("#embacado").css("display", "none");

			if (resultadoRetorno == "jáExiste") {
				swal("Cadastro Duplicado.", "Unidade de referência já cadastrada para este estabelecimento.", "error");
				return false;
			}
			$('#dados_unidadesreferencia').DataTable().destroy();
			$('#dados_unidadesreferencia tbody').empty().append(resultadoRetorno);
			$('#dados_unidadesreferencia').DataTable({
				"paging": false,
				"filter": false,
				"lengthChange": false,
				"info": false
			});
			$("#embacado").css("display", "none");			
			$("#unidadeReferencia").val('');
			$("#enderecoUnidade").val('');
			swal("Cadastro de Setor.", "Unidade cadastrada com sucesso.", "success");			
		});

	}

	$("#unidadeReferencia").change(function() {
		if(this.value!=""){
			$.ajax({
				url: 'filtros/filtrar_unidadesaude',
				type: 'post',
				dataType: 'html',
				data: {
					'opcaoFiltro' : 'unidade-referencia-endereco',
					'idUnidade': this.value
				}
			}).done(function(resultadoRetorno) {
				$("#enderecoUnidade").val(resultadoRetorno);
			});
		}else{
			$("#enderecoUnidade").val('');
		}
	})
</script>