p<?php

$servername_mysql   = "localhost";
$username_mysql     = "portalgsaude_gestor";
$password_mysql     = "CGm57KsElcsmagalhaes";
$database_mysql     = "portalgsaude_gsaude_candeias";

$conn_mysql = new mysqli($servername_mysql, $username_mysql, $password_mysql, $database_mysql);

if ($conn_mysql->connect_error) {
    die("Erro de conexão com o MySQL: " . $conn_mysql->connect_error);
}

if (!function_exists('formatarResultados')) {
    function formatarResultados($resultado) {
        $agendamentosParaJson = array();
        $agendamentosAguardando = array();
        $agendamentosAnalise = array();
        $agendamentosIndeferidos = array();
        $agendamentosDevolvidos = array();
        $agendamentosCancelado = array();
        $agendamentosEntregue = array();
        $agendamentosRealizou = array();
        $mensagem_formatada = "🗓️ AGENDADO:\n";
        $temAgendamentoNaoPoliclinica = false;
        $temAgendamento = false;
        $nome_paciente_unico = '';
        while ($row = $resultado->fetch_assoc()) {
            $agendamento = array(
                'nome_paciente' => $row['nome_paciente'],
                'nome_procedimento' => $row['nome_procedimento'],
                'data_atendimento' => $row['data_atendimento'],
                'horario_atendimento' => $row['horario_atendimento'],
                'dataprazo_retirada' => $row['dataprazo_retirada'],
                'id_agendamento' => $row['id_agendamento'],
                'tipo_vagaocupada' => $row['tipo_vagaocupada'],
                'status_agendamento_2' => $row['status_agendamento_2'],
                'id_procedimento' => $row['id_procedimento'],
                'id_solicitacao' => $row['id_solicitacao'],
                'numero_procotolo' => $row['numero_procotolo'],
                'justificativa_solicitacaocancelamento' => $row['justificativa_solicitacaocancelamento']
            );
            if ($nome_paciente_unico === '') {
                $nome_paciente_unico = $row['nome_paciente'];
            }
            switch ($row['status_agendamento_2']) {
                case 'AGENDADO':
                    $temAgendamento = true;
                    $mensagem_formatada .= "Encontrei a seguinte solicitação registrada no protocolo informado.\n";
                    $mensagem_formatada .= "\n";
                    $mensagem_formatada .= "▪️ Paciente: " . $nome_paciente_unico . "\n";
                    $mensagem_formatada .=  "🩺" . $row['nome_procedimento'] . "\n";
                    $mensagem_formatada .= "▪️Atendimento em: " . $row['data_atendimento'] . " às " . ($row['horario_atendimento'] ? $row['horario_atendimento'] : 'horário não especificado') . "\n";
                    $mensagem_formatada .= "▪️Prazo de Retirada: " . $row['dataprazo_retirada'] . "\n";
                    if (!in_array($row['tipo_vagaocupada'], ['PVEZ', 'RESERVA', 'RETORNO'])) {
                        $mensagem_formatada .= "Observação: O PDF do agendamento só poderá ser cancelado em um estabelecimento ou através do link: https://regulacaomunicipal.pmlf.ba.gov.br\n";
                        $mensagem_formatada .= "\n";
                        $agendamentosParaJson[] = array('nome_paciente' => $row['nome_paciente']);
                    } else {
                        $mensagem_formatada .= "\n";
                        $agendamentosParaJson[] = $agendamento;
                        $temAgendamentoNaoPoliclinica = true;
                    }
                    break;
                case 'AGUARDANDO AGENDAMENTO':
                    $agendamentosAguardando[] = $agendamento;
                    break;
                case 'CANCELADO':
                    $agendamentosCancelado[] = $agendamento;
                    break;
                case 'EM ANALISE':
                    $agendamentosAnalise[] = $agendamento;
                    break;
                case 'INDEFERIDO':
                    $agendamentosIndeferidos[] = $agendamento;
                    break;
                case 'DEVOLVIDO':
                    $agendamentosDevolvidos[] = $agendamento;
                    case 'ENTREGUE':
                        $agendamentosEntregue[] = $agendamento;
                        case 'JÁ REALIZOU':
                            $agendamentosRealizou[] = $agendamento;
                    break;
            }
        }

        return array(
            'mensagem' => $mensagem_formatada,
            'json' => $agendamentosParaJson,
            'aguardando' => $agendamentosAguardando,
            'emAnalise' => $agendamentosAnalise,
            'indeferidos' => $agendamentosIndeferidos,
            'devolvidos' => $agendamentosDevolvidos,
            'cancelado' => $agendamentosCancelado,
            'entregue' => $agendamentosEntregue,
            'realizou' => $agendamentosRealizou,
            'temAgendamentoNaoPoliclinica' => $temAgendamentoNaoPoliclinica,
            'nome_paciente_unico' => $nome_paciente_unico,
            'temAgendamento' => $temAgendamento
        );
    }
}

$resposta = array();

if (isset($_GET['protocolo'])) {
    $parametro = $_GET['protocolo'];
    $parametro = str_replace(['.', '-'], '', $parametro);

    $sql = "SELECT 
    id_paciente,
    nome_paciente,
    id_solicitacao,
    id_procedimento, 
    nome_procedimento, 
    cns_paciente,
    cpf_paciente,
    tipo_vagaocupada,
    id_agendamento,
    numero_procotolo,
    justificativa_solicitacaocancelamento,
    data_atendimento,
    horario_atendimento,
    dataprazo_retirada,
    status_agendamento_2
FROM (
    SELECT 
        t1.id_paciente,
        t2.nome_paciente,
        t1.id_solicitacao,
        t3.id_procedimento, 
        t3.nome_procedimento, 
        t2.cns_paciente,
        t2.cpf_paciente,
        t4.tipo_vagaocupada,
        t4.id_agendamento,
        t1.numero_procotolo,
        IFNULL(t1.justificativa_solicitacaocancelamento, 'Motivo não informado') AS justificativa_solicitacaocancelamento,
        DATE_FORMAT(t4.data_atendimento, '%d/%m/%Y') AS data_atendimento,
        t4.horario_atendimento,
        DATE_FORMAT(t4.dataprazo_retirada, '%d/%m/%Y') AS dataprazo_retirada,
        CASE
            WHEN t1.id_statussolicitacao = '1' THEN 'EM ANALISE'
            WHEN t1.id_statussolicitacao = '2' THEN 'AGUARDANDO AGENDAMENTO'
            WHEN t1.id_statussolicitacao = '5' THEN 'CANCELADO'
            WHEN t1.id_statussolicitacao = '6' THEN 'ENTREGUE'
            WHEN t1.id_statussolicitacao = '8' THEN 'JÁ REALIZOU'
            WHEN t1.id_statussolicitacao = '3' THEN 'AGENDADO'
            WHEN t1.id_statussolicitacao = '9' THEN 'INDEFERIDO'
            WHEN t1.id_statussolicitacao = '10' THEN 'DEVOLVIDO'
        END AS status_agendamento_2,
        null as status_agendamento  
    FROM
        reg_tb_solicitacoes t1
    LEFT JOIN 
        tb_paciente t2 ON t2.id_paciente = t1.id_paciente 
    LEFT JOIN 
        reg_tb_procedimento t3 ON t3.id_procedimento = t1.id_procedimento 
    LEFT JOIN 
        reg_tb_agendamentos t4 ON t4.id_solicitacao = t1.id_solicitacao 
    WHERE 
        (t1.id_statussolicitacao = '2' or t4.status_agendamento = 'A' or t1.id_statussolicitacao = '10' or t1.id_statussolicitacao = '1' or (t1.id_statussolicitacao = '6' AND t4.data_atendimento > CURDATE()))  
       AND t1.numero_procotolo = '$parametro'
    UNION ALL
    SELECT 
        t1.id_paciente,
        t2.nome_paciente,
        t1.id_solicitacao,
        t3.id_procedimento, 
        t3.nome_procedimento, 
        t2.cns_paciente,
        t2.cpf_paciente,
        t1.tipo_vagaocupada,
        t1.id_agendamento,
        null as numero_procotolo,  
        'Motivo não informado' as justificativa_solicitacaocancelamento,
        DATE_FORMAT(t1.data_atendimento, '%d/%m/%Y') AS data_atendimento,
        t1.horario_atendimento,
        DATE_FORMAT(t1.data_atendimento, '%d/%m/%Y') AS dataprazo_retirada,
        CASE
            WHEN t1.status_agendamento = 'A' THEN 'AGENDADO'
            WHEN t1.status_agendamento = 'C' THEN 'CANCELADO'
            WHEN t1.status_agendamento = 'E' THEN 'ENTREGUE'
        END AS status_agendamento_2,
        t1.status_agendamento
    FROM
        reg_tb_agendamentos t1
    LEFT JOIN 
        tb_paciente t2 ON t2.id_paciente = t1.id_paciente 
    LEFT JOIN 
        reg_tb_procedimento t3 ON t3.id_procedimento = t1.id_procedimento 
    LEFT JOIN 
        reg_tb_solicitacoes t4 ON t4.id_solicitacao = t1.id_solicitacao 
    WHERE 
         (t1.status_agendamento = 'A' or (t1.status_agendamento = 'E' AND t1.data_atendimento > CURDATE()))
        AND t1.protocolo_agendamento = '$parametro'
) AS combined_data
ORDER BY data_atendimento
LIMIT 1;
";

    $resultado = $conn_mysql->query($sql);

    if ($resultado->num_rows > 0) {
        $formatados = formatarResultados($resultado);
        $mensagem_formatada = $formatados['mensagem'];
        $agendamentosParaJson = $formatados['json'];
        $agendamentosAguardando = $formatados['aguardando'];
        $agendamentosAnalise = $formatados['emAnalise'];
        $agendamentosIndeferidos = $formatados['indeferidos'];
        $agendamentosCancelado = $formatados['cancelado'];
        $agendamentosDevolvidos = $formatados['devolvidos'];
        $agendamentosEntregue = $formatados['entregue'];
        $agendamentosRealizou = $formatados['realizou'];
        $temAgendamentoNaoPoliclinica = $formatados['temAgendamentoNaoPoliclinica'];
        $temAgendamento = $formatados['temAgendamento'];
        $nome_paciente_unico = $formatados['nome_paciente_unico'];

        if ($temAgendamentoNaoPoliclinica) {
            $mensagem_formatada .= "🚨Atenção! Ao confirmar o cancelamento, sua solicitação será cancelada e retirada da fila. Isto não poderá ser desfeito. Confirma?\n";
            $mensagem_formatada .= "Digite 1 para SIM ou 2 para NÃO. \n";
            $mensagem_formatada .= "\n";
        }



        if (!$temAgendamento) {
            if (!empty($agendamentosAnalise)) {
                $agendamento = $agendamentosAnalise[0];
                $mensagem_formatada = "🚨 Encontrei uma solicitação em análise.\n";
                $mensagem_formatada .= "▪️ Paciente: " . $nome_paciente_unico . "\n";
                $mensagem_formatada .= "🩺 Nome do Procedimento: " . $agendamento['nome_procedimento'] . "\n";
                $mensagem_formatada .= "Status da Solicitação: EM ANÁLISE\n";
                $mensagem_formatada .= "\n";
                $mensagem_formatada .= "🚨Atenção! Ao confirmar o cancelamento, sua solicitação será cancelada e retirada da fila. Isto não poderá ser desfeito. Confirma?\n";
                $mensagem_formatada .= "Digite 1 para SIM ou 2 para NÃO. \n";
                $mensagem_formatada .= "\n";

                $agendamentosParaJson[] = array('nome_paciente' => $agendamento['nome_paciente']);
                $agendamentosParaJson[] = array('numero_procotolo' => $agendamento['numero_procotolo']);
            } elseif (!empty($agendamentosAguardando)) {
                $agendamento = $agendamentosAguardando[0];
                $mensagem_formatada = "🚨 Encontrei uma solicitação aguardando agendamento.\n";
                $mensagem_formatada .= "▪️ Paciente: " . $nome_paciente_unico . "\n";
                $mensagem_formatada .= "🩺 Nome do Procedimento: " . $agendamento['nome_procedimento'] . "\n";
                $mensagem_formatada .= "Status da Solicitação: AGUARDANDO AGENDAMENTO\n";
                $mensagem_formatada .= "\n";
                $mensagem_formatada .= "🚨Atenção! Ao confirmar o cancelamento, sua solicitação será cancelada e retirada da fila. Isto não poderá ser desfeito. Confirma?\n";
                $mensagem_formatada .= "Digite 1 para SIM ou 2 para NÃO. \n";
                $mensagem_formatada .= "\n";

                $agendamentosParaJson[] = array('nome_paciente' => $agendamento['nome_paciente']);
                $agendamentosParaJson[] = array('numero_procotolo' => $agendamento['numero_procotolo']);
            } elseif (!empty($agendamentosIndeferidos)) {
                $agendamento = $agendamentosIndeferidos[0];
                $mensagem_formatada .= "Encontrei a seguinte solicitação registrada no protocolo informado.\n";
                $mensagem_formatada .= "\n";
                $mensagem_formatada = "🚨 Solicitação Indeferida.\n";
                $mensagem_formatada .= "▪️ Paciente: " . $nome_paciente_unico . "\n";
                $mensagem_formatada .= "🩺 Nome do Procedimento: " . $agendamento['nome_procedimento'] . "\n";
                $mensagem_formatada .= "Status da Solicitação: INDEFERIDO\n";
                $mensagem_formatada .= "Motivo do Indeferimento: " . $agendamento['justificativa_solicitacaocancelamento'] . "\n";
                $mensagem_formatada .= "\n";
                $mensagem_formatada .= "Para mais informações consulte o site: https://regulacaomunicipal.pmlf.ba.gov.br\n";
                $mensagem_formatada .= "\n";

                $agendamentosParaJson[] = array('nome_paciente' => $agendamento['nome_paciente']);
            } elseif (!empty($agendamentosCancelado)) {
                $agendamento = $agendamentosCancelado[0];
                $mensagem_formatada .= "Encontrei a seguinte solicitação registrada no protocolo informado.\n";
                $mensagem_formatada .= "\n";
                $mensagem_formatada = "🚨 Solicitação Cancelada.\n";
                $mensagem_formatada .= "▪️ Paciente: " . $nome_paciente_unico . "\n";
                $mensagem_formatada .= "🩺 Nome do Procedimento: " . $agendamento['nome_procedimento'] . "\n";
                $mensagem_formatada .= "Status da Solicitação: CANCELADA\n";
                $mensagem_formatada .= "Motivo do Cancelamento: " . $agendamento['justificativa_solicitacaocancelamento'] . "\n";
                $mensagem_formatada .= "\n";
                $mensagem_formatada .= "Para mais informações consulte o site: https://regulacaomunicipal.pmlf.ba.gov.br\n";
                $mensagem_formatada .= "\n";

                $agendamentosParaJson[] = array('nome_paciente' => $agendamento['nome_paciente']);
            } elseif (!empty($agendamentosEntregue)) {
                $agendamento = $agendamentosEntregue[0];
                $mensagem_formatada = "🚨 Encontrei uma solicitação entregue.\n";
                $mensagem_formatada .= "▪️ Paciente: " . $nome_paciente_unico . "\n";
                $mensagem_formatada .= "🩺 Nome do Procedimento: " . $agendamento['nome_procedimento'] . "\n";
                $mensagem_formatada .= "Status da Solicitação: ENTREGUE\n";
                $mensagem_formatada .= "\n";
                $mensagem_formatada .= "🚨Atenção! Ao confirmar o cancelamento, sua solicitação será cancelada e retirada da fila. Isto não poderá ser desfeito. Confirma?\n";
                $mensagem_formatada .= "Digite 1 para SIM ou 2 para NÃO. \n";
                $mensagem_formatada .= "\n";

                $agendamentosParaJson[] = array('nome_paciente' => $agendamento['nome_paciente']);
                $agendamentosParaJson[] = array('numero_procotolo' => $agendamento['numero_procotolo']);
            } elseif (!empty($agendamentosRealizou)) {
                $mensagem_formatada .= "Encontrei a seguinte solicitação registrada no protocolo informado.\n";
                $mensagem_formatada .= "\n";
                $agendamento = $agendamentosRealizou[0];
                $mensagem_formatada = "🚨 Solicitação Realizada.\n";
                $mensagem_formatada .= "▪️ Paciente: " . $nome_paciente_unico . "\n";
                $mensagem_formatada .= "🩺 Nome do Procedimento: " . $agendamento['nome_procedimento'] . "\n";
                $mensagem_formatada .= "Status da Solicitação: JÁ REALIZOU\n";
                $mensagem_formatada .= "\n";
                $mensagem_formatada .= "Para mais informações consulte o site: https://regulacaomunicipal.pmlf.ba.gov.br\n";
                $mensagem_formatada .= "\n";

                $agendamentosParaJson[] = array('nome_paciente' => $agendamento['nome_paciente']);
            } elseif (!empty($agendamentosDevolvidos)) {
                $mensagem_formatada .= "Encontrei a seguinte solicitação registrada no protocolo informado.\n";
                $mensagem_formatada .= "\n";
                $agendamento = $agendamentosDevolvidos[0];
                $mensagem_formatada = "🚨 Encontrei uma solicitação devolvida.\n";
                $mensagem_formatada .= "▪️ Paciente: " . $nome_paciente_unico . "\n";
                $mensagem_formatada .= "🩺 Nome do Procedimento: " . $agendamento['nome_procedimento'] . "\n";
                $mensagem_formatada .= "Status da Solicitação: DEVOLVIDO\n";
                $mensagem_formatada .= "Motivo da devolução: " . $agendamento['justificativa_solicitacaocancelamento'] . "\n";
                $mensagem_formatada .= "\n";
                $mensagem_formatada .= "🚨Atenção! Ao confirmar o cancelamento, sua solicitação será cancelada e retirada da fila. Isto não poderá ser desfeito. Confirma?\n";
                $mensagem_formatada .= "Digite 1 para SIM ou 2 para NÃO. \n";
                $mensagem_formatada .= "\n";

                $agendamentosParaJson[] = array('nome_paciente' => $agendamento['nome_paciente']);
                $agendamentosParaJson[] = array('numero_procotolo' => $agendamento['numero_procotolo']);
            } else {
                $mensagem_formatada = "Eu não encontrei nenhuma solicitação em aberto em nosso banco de dados para o documento informado. \n";
                $mensagem_formatada .= "\n";

            }
        }
    } else {
        $mensagem_formatada = "Eu não encontrei nenhuma solicitação em aberto em nosso banco de dados para o documento informado. \n";
        $mensagem_formatada .= "\n";

        $agendamentosParaJson = array();
    }

    $resposta['mensagem_formatada'] = $mensagem_formatada;
    $resposta['data'] = $agendamentosParaJson;

} else {
    $resposta['mensagem_formatada'] = 'Por favor, especifique um PROTOCOLO na URL.';
}

header('Content-Type: application/json');
echo json_encode($resposta);

$conn_mysql->close();
?>