<?php

// Verifica se a função limparTexto já foi declarada
if (!function_exists('limparTexto')) {
    function limparTexto($texto) {
        $texto_limpo = strip_tags($texto);
        $texto_limpo = str_replace('&NBSP;', ' ', $texto_limpo);
        $texto_limpo = trim(preg_replace('/\s+/', ' ', $texto_limpo));
        return $texto_limpo;
    }
}

// Verifica se a função formatarMensagem já foi declarada
if (!function_exists('formatarMensagem')) {
    function formatarMensagem($resultado) {
        $mensagem_formatada = ""; 
        $mensagem = "⚠️**Leia atentamente**\n\n";
        while ($row = $resultado->fetch_assoc()) {
            $mensagem .= "🔍 Segue as observações sobre seu procedimento: \n";
            $mensagem .= "🩺" . $row['nome_procedimento'] . "\n";
            $mensagem_formatada .= "\n";
            $mensagem_formatada .= "Digite **0** para retornar ao menu\n";
            if (!is_null($row['preparo_procedimento'])) {
                $mensagem .= "   ❗" . limparTexto($row['preparo_procedimento']) . "\n";
            } else {
                $mensagem .= "   ❗ Sem informações\n";
                $mensagem_formatada .= "\n";
                $mensagem_formatada .= "Digite **0** para retornar ao menu\n";
            }
            $mensagem .= "\n";
        }
        return $mensagem;
    }
}


$servername_mysql   = "localhost";
$username_mysql     = "portalgsaude_gestor";
$password_mysql     = "CGm57KsElcsmagalhaes";
$database_mysql     = "portalgsaude_gsaude_candeias";

$conn_mysql = new mysqli($servername_mysql, $username_mysql, $password_mysql, $database_mysql);

if ($conn_mysql->connect_error) {
    die("Erro de conexão com o MySQL: " . $conn_mysql->connect_error);
}

if (isset($_GET['id']) || isset($_GET['texto'])) {
    $where_clauses = [];

    if (isset($_GET['id'])) {
        $ids = $_GET['id'];

        // Verifica se é uma lista de IDs ou um único ID
        if (strpos($ids, ',') !== false) {
            // Se for uma lista de IDs, converte para um array
            $ids_array = json_decode($ids);
            $ids_str = implode(',', $ids_array);
            $where_clauses[] = "id_procedimento IN ($ids_str)";
        } else {
            // Se for um único ID
            $where_clauses[] = "id_procedimento = $ids";
        }
    }

    if (isset($_GET['texto'])) {
        $texto = $conn_mysql->real_escape_string($_GET['texto']);
        $where_clauses[] = "(nome_procedimento LIKE '%$texto%')";
    }

    $where_clause = implode(' AND ', $where_clauses);

    $sql = "SELECT 
        t1.id_procedimento,
        t1.nome_procedimento,
        t1.observacao_procedimento,
        t1.preparo_procedimento
    FROM 
        reg_tb_procedimento t1
    WHERE 
        $where_clause;";
    
    $resultado = $conn_mysql->query($sql);

    // Verifica se há resultados
    if ($resultado->num_rows > 0) {
        // Formata e exibe a mensagem com emojis
        $mensagem_formatada = formatarMensagem($resultado);
        echo $mensagem_formatada;
    } else {
        echo 'Nenhum procedimento encontrado.';
    }
    
} else {
    echo 'ERROR: Parâmetro "id" ou "texto" não encontrado na solicitação.';
}

$conn_mysql->close();

?>
