<?php
session_start();
require("../../database/dbConection.php");
$dataHoraImpressao  = date("d/m/Y H:i");

$totalGeral = 0;
ob_start();

    echo "<table class='tabela-dados-relatorio'>
        <thead>
          <tr>
            <th scope='col' style='text-align: left'>NOME DO GRUPO/PROCEDIMENTOS</th>
            <th scope='col' style='text-align: center' width='150px'>QUANTIDADE NA FILA</th>
          </tr>
        </thead>
      <tbody>";

    if ($_GET['tipo'] == "grupo") {
      $sqlRelatorio = "SELECT UCASE(reg_tb_procedimento_grupo.nome_grupo_procedimento) AS nomeGrupoProcedimento,
      COUNT(reg_tb_solicitacoes.id_solicitacao) AS quantidadeFila
      FROM reg_tb_procedimento_grupo INNER JOIN reg_tb_solicitacoes ON (reg_tb_procedimento_grupo.id_grupo_procedimento = reg_tb_solicitacoes.id_grupo_procedimento)
      WHERE (reg_tb_solicitacoes.id_statussolicitacao='2')
      GROUP BY reg_tb_procedimento_grupo.nome_grupo_procedimento
      ORDER BY COUNT(reg_tb_solicitacoes.id_solicitacao) DESC";
    } else {
      $sqlRelatorio = "SELECT UCASE(reg_tb_procedimento.nome_procedimento) AS nomeGrupoProcedimento,
      COUNT(reg_tb_solicitacoes.id_solicitacao) AS quantidadeFila
      FROM reg_tb_procedimento INNER JOIN reg_tb_solicitacoes ON (reg_tb_procedimento.id_procedimento = reg_tb_solicitacoes.id_procedimento)
      WHERE (reg_tb_solicitacoes.id_statussolicitacao='2')
      GROUP BY reg_tb_procedimento.nome_procedimento
      ORDER BY COUNT(reg_tb_solicitacoes.id_solicitacao) DESC";      
    }
    $stmRelatorio   = $rsConexao->prepare($sqlRelatorio);
    $stmRelatorio->execute();
    $rsRelatorio    = $stmRelatorio->fetchAll(PDO::FETCH_ASSOC);
    $totalRegistros = $stmRelatorio->rowCount();

    if ($totalRegistros > 0) {
      foreach ($rsRelatorio as $fieldRelatorio) {
        $nomeGrupoProcedimento  = $fieldRelatorio['nomeGrupoProcedimento'];
        $quantidadeFila         = number_format($fieldRelatorio['quantidadeFila'], 0, '', '.');
        $totalGeral             = $totalGeral + $fieldRelatorio['quantidadeFila'];
        echo "<tr>
            <td style='line-height:17px'>$nomeGrupoProcedimento</td>
            <td align='center'>$quantidadeFila</td>
          </tr>";
      }
      $exibirTotalGeral = number_format($totalGeral, 0, '', '.');

      $sqlPessoas = "SELECT reg_tb_solicitacoes.id_paciente,
        reg_tb_solicitacoes.id_statussolicitacao
        FROM reg_tb_solicitacoes
        WHERE (reg_tb_solicitacoes.id_statussolicitacao='2')
        GROUP BY reg_tb_solicitacoes.id_paciente";
      $stmPessoas = $rsConexao->prepare($sqlPessoas);
      $stmPessoas->execute();
      $totalPessoas = number_format($stmPessoas->rowCount(), 0, '', '.');

      $mediaProcedimentoPessoa = number_format($totalGeral / $stmPessoas->rowCount(), 1, ',', '');

      echo "<tr style='background-color:#f1f1f1'>
          <td style='line-height:25px'><b>TOTAL DE PROCEDIMENTOS:</b></td>
          <td align='center'><b>$exibirTotalGeral</b></td>
        </tr>
        <tr style='background-color:#dadada'>
          <td style='line-height:25px'><b>TOTAL DE PESSOAS:</b></td>
          <td align='center'><b>$totalPessoas</b></td>
        </tr>
        <tr style='background-color:#f1f1f1'>
          <td style='line-height:25px'><b>MÉDIA DE PROCEDIMENTOS POR PESSOA:</b></td>
          <td align='center'><b>$mediaProcedimentoPessoa</b></td>
        </tr>        ";
    }

    echo "</tbody>
      </table>";


require_once __DIR__ . '../../../../lib_sistemas/mpdf8/vendor/autoload.php';
$mpdf = new \Mpdf\Mpdf([
  'mode' => 'utf-8',
  'format' => 'A4',
  'orientation' => 'P',
  'margin_header' => 15,
  'margin_top' => 33,
  'default_font' => 'tahoma'
]);


$html = ob_get_clean();
$mpdf->mirrorMargins = 1;
$stylesheet = file_get_contents('../relatorios/relatorio.css');
$mpdf->WriteHTML($stylesheet, 1);

$header = "
  <table align='center' class='tb_header'>
    <tr>
      <td class='logo-rel'>
        <img src='../css/images/logo-dark.png' height='50px'>
      </td>
		  <td class='titulo_relatorio' align='center' style='font-size:10pt'>
        CANDEIAS-BA<br>
        RELATÓRIO DE DEMANDA REPRIMIDA
      </td>
      <td class='info-emissao-relatorio'>
        EMISSÃO : $dataHoraImpressao<br>
        IMPRESSO POR : Whatsapp Gestor<br>
      </td>
    </tr>
    </table>
	  <br>
  <div class='sub_titulo_rel'></div><br>";

$footer = "<table width='100%' style='font-size:8pt'><tr>
  <td align='left'><b>GSaúde - Regulação : Expansão Tecnologia e Consultoria</b></td>
  <td align='right'><b>Página {PAGENO}</b></td>
</tr></table>";

$mpdf->SetHTMLHeader($header);
$mpdf->SetFooter($footer);
$mpdf->SetTitle('G-SAUDE - Demanda Reprimida');
$mpdf->WriteHTML($html);
$mpdf->Output('GSaude_DemandaReprimida.pdf', 'F');
$mpdf->AddPage();

exit;
