<?php

if ($_SERVER["REQUEST_METHOD"] == "GET") {
    $nome = $_GET["nome"] ?? "";
    $nu_cns1 = $_GET["nu_cns"] ?? "";
    $sexo = $_GET["sexo"] ?? "";
    $data_nascimento = $_GET["data_nascimento"] ?? "";
    $imagePath = 'assets/img/1.png';  
    
    error_log("Received nu_cns: $nu_cns1");
    error_log("Received data_nascimento: $data_nascimento");
}

if (!function_exists('formataCNS')) {
    function formataCNS($numeroCNS) {
        if (strlen($numeroCNS) === 15) {
            $numeroInicio = substr($numeroCNS, 0, 3);
            $numeroMeio1  = substr($numeroCNS, 3, 4);
            $numeroMeio2  = substr($numeroCNS, 7, 4);
            $numeroMeio3  = substr($numeroCNS, 11, 4);
            return $numeroInicio . ' ' . $numeroMeio1 . ' ' . $numeroMeio2 . ' ' . $numeroMeio3;
        }
        return $numeroCNS; // Retorna o CNS original se não tiver 15 dígitos
    }
}

$nu_cns = formataCNS($nu_cns1);


if (!function_exists('formataDataNascimento')) {
    function formataDataNascimento($data) {
        $date = DateTime::createFromFormat('Y-m-d', $data);
        if ($date) {
            return $date->format('d/m/Y');
        }
        return ''; // Se a data não for válida, retornar uma string vazia
    }
}

$data_nascimento = formataDataNascimento($data_nascimento);

if (!function_exists('formataNome')) {
    function formataNome($nome, $limite) {
        // Verifica se o nome ultrapassa o limite
        if (strlen($nome) > $limite) {
            // Separa o nome em partes usando os espaços como delimitadores
            $partes = explode(" ", $nome);
            $abreviado = "";

            // Mantém o primeiro nome completo
            $abreviado .= $partes[0] . " ";

            // Itera sobre as partes do sobrenome
            for ($i = 1; $i < count($partes) - 1; $i++) {
                // Se a parte for menor ou igual a 2 caracteres, mantém ela completa
                if (strlen($partes[$i]) <= 2) {
                    $abreviado .= $partes[$i] . " ";
                } else {
                    // Caso contrário, abrevia apenas a primeira letra
                    $abreviado .= strtoupper($partes[$i][0]) . ". ";
                }
            }

            // Mantém o último sobrenome completo
            $abreviado .= $partes[count($partes) - 1];

            return trim($abreviado); // Remove espaços extras no início e no final
        } else {
            // Se o nome não ultrapassar o limite, retorna o nome original
            return $nome;
        }
    }
}

?>
<!DOCTYPE html>
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta charset="utf-8"/>
<meta name="generator" content="pdf2htmlEX"/>
<meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1"/>
<style>
    /* Definição do tamanho da página A4 */
    @page {
        size: A4;
        margin: 0;
    }

    /* Estilo para o corpo do documento */
    body {
        margin: 0;
        font-family: Arial, sans-serif;
    }

    /* Estilo para o container principal */
    .Body {
        width: 210mm; /* largura A4 em milímetros */
        height: 297mm; /* altura A4 em milímetros */
        position: relative;
    }

    /* Estilo para os elementos internos */
    .Background, .BackgroundShadow {
        width: 100%;
        height: 100%;
        position: absolute;
    }

    /* Outros estilos... */
</style>
</head>
<body>
<div class="Body" style="width: 1350px; height: 1px; position: relative;">
    <div class="ImageFill" style="width: 1366px; height: 688px; paddingBottom: 604px; paddingRight: 1361px; left: 0px; top: 0px; position: absolute; flexDirection: column; justifyContent: flex-start; alignItems: flex-start; display: inline-flex;">
      <div class="Image" style="width: 5px; height: 5px; position: relative;">
        <div class="Vector" style="width: 5px; height: 5px; left: 0px; top: 0px; position: absolute; background: #9E9E9E;"></div>
        <div class="Vector" style="width: 7px; height: 7px; left: -1px; top: -1px; position: absolute; background: black; border: 1px #888888 solid;"></div>
      </div>
    </div>
      <div class="Container" style="width: 892.50px; height: 1263px; left: 0px; top: 0px; position: absolute;">
      <img class="Image" style="width: 893.25px; height: 1263.75px; left: -0.25px; top: 0px; position: absolute;" src="data:image/png;base64,{{ base64_encode(file_get_contents($imagePath)) }}" />
        <div class="Container" style="width: 243.04px; height: 49.28px; left: 510px; top: 404.87px; position: absolute;"></div>
        <div class="006213856204" style="width: 400px; height: 80px; left: 475.75px; top: 404px; position: absolute; color: black; font-size: 22.50px; font-family: 'Maison Neue', sans-serif; font-weight: bold; line-height: 1; word-wrap: break-word;"><?php echo $nu_cns; ?></div>

<div class="Paragraph" style="width: 39.32px; height: 7.41px; left: 686px; top: 389.84px; position: absolute;">
    <div class="011988" style="width: 90px; height: 23px; left: -146.25px; top: 0.59px; position: absolute; color: black; font-size: 11px; font-family: 'Maison Neue', sans-serif; font-weight: 400; font-weight: bold; line-height: 1; word-wrap: break-word;"><?php echo $data_nascimento; ?></div>
</div>

<div class="M" style="width: 6.50px; height: 23px; left: 688.75px; top: 390px; position: absolute; color: black; font-size: 11px; font-family: 'Maison Neue', sans-serif; font-weight: 400;font-weight: bold; line-height: 1; word-wrap: break-word;"><?php echo $sexo; ?></div>

<div class="Container" style="width: 158.43px; height: auto; left: 469.50px; top: 364.53px; position: absolute; display: inline-flex; overflow: visible;">
    <div class="LeandroAlvesDaSilva" style="color: black; font-size: 13px; font-family: Inter; font-weight: bold; line-height: 1.2; overflow: visible; white-space: nowrap;"><?php echo $nome; ?></div>
</div>


        </div>
        <div class="Container" style="width: 69.32px; height: 23px; left: 508.50px; top: 389.84px; position: absolute; flexDirection: column; justifyContent: flex-start; alignItems: flex-start; display: inline-flex;">
        </div>
        <div class="Container" style="width: 560.31px; height: 58.24px; left: 73.50px; top: 152.23px; position: absolute; flexDirection: column; justifyContent: flex-start; alignItems: flex-start; display: inline-flex;">
          <div class="ParabNsSeusDadosJConstamNoSistemaNicoDeSaDeSus" style="color: black; fontSize: 17.16px; fontFamily: Inter; fontWeight: 400; lineHeight: 58.24px; wordWrap: break-word;">Parabéns! Seus dados já constam no Sistema Único de Saúde - SUS.</div>
        </div>
        <div class="Container" style="width: 685.39px; height: 58.24px; left: 73.50px; top: 173.18px; position: absolute; flexDirection: column; justifyContent: flex-start; alignItems: flex-start; display: inline-flex;">
          <div class="InformeSeuNMeroDeCnsQuandoUsarARedeDoSistemaNicoDeSaDeSus" style="color: black; fontSize: 17.16px; fontFamily: Inter; fontWeight: 400; lineHeight: 58.24px; wordWrap: break-word;">Informe, seu número de CNS quando usar a rede do Sistema Único de Saúde – SUS.</div>
        </div>
        <div class="Container" style="width: 677.36px; height: 58.24px; left: 73.50px; top: 194.12px; position: absolute; flexDirection: column; justifyContent: flex-start; alignItems: flex-start; display: inline-flex;">
          <div class="RecorteOCartOAbaixoEUseONormalmenteEleValeEmTodoOTerritRioNacional" style="color: black; fontSize: 16.88px; fontFamily: Inter; fontWeight: 400; lineHeight: 58.24px; wordWrap: break-word;">Recorte o Cartão abaixo e use-o normalmente. Ele vale em todo o território nacional.</div>
        </div>
        <div class="Container" style="width: 269.10px; height: auto; left: 73.50px; top: 126.73px; position: absolute; display: inline-flex; overflow: visible;">
    <div class="SrLeandroAlvesDaSilva" style="color: black; font-size: 18px; font-family: Inter; font-weight: 400; line-height: 1.2; overflow: visible; white-space: nowrap; word-wrap: normal;">Sr. <?php echo $nome; ?>,</div>
</div>

        </div>
        <div class="Container" style="width: 322.08px; height: 74.84px; left: 282.95px; top: 65.82px; position: absolute; flexDirection: column; justifyContent: flex-start; alignItems: flex-start; display: inline-flex;">
          <div class="CartONacionalDeSaDeCns" style="color: black; fontSize: 40.67px;  fontFamily: Inter; font-weight: bold; fontWeight: 400; lineHeight: 94.84px; wordWrap: break-word;">Cartão Nacional de Saúde - CNS</div>
        </div>
      </div>
    </div>
  </div>
</div>
</body>
</html>