<?php
$servername_mysql   = "localhost";
$username_mysql     = "portalgsaude_gestor";
$password_mysql     = "CGm57KsElcsmagalhaes";
$database_mysql     = "portalgsaude_gsaude_candeias";

$conn_mysql = new mysqli($servername_mysql, $username_mysql, $password_mysql, $database_mysql);

if ($conn_mysql->connect_error) {
    echo "Erro de conexão com o MySQL.";
}

if (!function_exists('formatarResultados')) {
    function formatarResultados($resultado) {
        $agendamentosParaJson = array();
        $agendamentosAguardando = array();
        $agendamentosanalise = array();
        $mensagem_formatada = "";
        $temAgendamentoNaoPoliclinica = false; // Variável para verificar se há agendamentos válidos que não sejam POLICLÍNICA
        $temAgendamento = false; // Variável para verificar se há algum agendamento
        $nome_paciente_unico = '';
        while ($row = $resultado->fetch_assoc()) {
            $agendamento = array(
                'nome_paciente' => $row['nome_paciente'],
                'nome_procedimento' => $row['nome_procedimento'],
                'data_atendimento' => $row['data_atendimento'],
                'horario_atendimento' => $row['horario_atendimento'],
                'dataprazo_retirada' => $row['dataprazo_retirada'],
                'id_agendamento' => $row['id_agendamento'],
                'tipo_vagaocupada' => $row['tipo_vagaocupada'],
                'status_agendamento_2' => $row['status_agendamento_2'],
                'cns_paciente' => $row['cns_paciente'],
                'id_procedimento' => $row['id_procedimento'],
                'id_solicitacao' => $row['id_solicitacao']
               
            );
            if ($nome_paciente_unico === '') {
                $nome_paciente_unico = $row['nome_paciente'];
            }
            if ($row['status_agendamento_2'] === 'AGENDADO') {
                $temAgendamento = true; // Indica que existe um agendamento
                $mensagem_formatada .= "Encontrei as seguintes solicitações registradas no CPF/CNS informado.\n";
                $mensagem_formatada .= "\n";
                $mensagem_formatada .= "▪️ Paciente: " . $nome_paciente_unico . "\n";
                $mensagem_formatada .= "🩺 " . $row['nome_procedimento'] . "\n";
                $mensagem_formatada .= "▪️ Atendimento em: " . $row['data_atendimento'] . " às " . ($row['horario_atendimento'] ? $row['horario_atendimento'] : 'horário não especificado') . "\n";
                $mensagem_formatada .= "▪️ Prazo de Retirada: " . $row['dataprazo_retirada'] . "\n";
                
                if (!in_array($row['tipo_vagaocupada'], ['PVEZ', 'RESERVA', 'RETORNO'])) {
                    //$mensagem_formatada .= "Observação: O PDF do agendamento só poderá ser retirado em um estabelecimento ou através do link: https://regulacaomunicipal.pmlf.ba.gov.br\n";
                    $mensagem_formatada .= "Digite 4 para que eu possoa enviar o arquivo do agendamento pra você.\n";
                    $temAgendamentoNaoPoliclinica = false;
                }
                $mensagem_formatada .= "\n";
                $agendamentosParaJson[] = $agendamento;
                if ($row['tipo_vagaocupada'] != 'POLICLÍNICA') {
                    $temAgendamentoNaoPoliclinica = true;
                }
            } elseif ($row['status_agendamento_2'] === 'AGUARDANDO AGENDAMENTO') {
                $agendamentosAguardando[] = $agendamento;
            } elseif ($row['status_agendamento_2'] === 'EM ANALISE') {
                $agendamentosanalise[] = $agendamento;
            }
        }

        return array(
            'mensagem' => $mensagem_formatada,
            'json' => $agendamentosParaJson,
            'aguardando' => $agendamentosAguardando,
            'emAnalise' => $agendamentosanalise,
            'temAgendamentoNaoPoliclinica' => $temAgendamentoNaoPoliclinica,
            'nome_paciente_unico' => $nome_paciente_unico,
            'temAgendamento' => $temAgendamento // Adiciona a verificação de agendamento
        );
    }
}

$resposta = array();
if (isset($_GET['cpf']) || isset($_GET['cns'])) {
    $parametro = isset($_GET['cpf']) ? $_GET['cpf'] : $_GET['cns'];
    $parametro = str_replace(['.', '-'], '', $parametro);

    $cpf_filter = isset($_GET['cpf']) ? "AND t2.cpf_paciente = '$parametro'" : "AND t2.cns_paciente = '$parametro'";

    $sql = "SELECT DISTINCT
        t1.id_paciente,
        t2.nome_paciente,
        t1.id_solicitacao,
        t3.id_procedimento, 
        t3.nome_procedimento, 
        t2.cns_paciente,
        t2.cpf_paciente,
        t1.tipo_vagaocupada,
        t1.id_agendamento,
        DATE_FORMAT(t1.data_atendimento, '%d/%m/%Y') AS data_atendimento,
        t1.horario_atendimento,
        DATE_FORMAT(t1.dataprazo_retirada, '%d/%m/%Y') AS dataprazo_retirada,
        CASE
            WHEN t4.id_statussolicitacao = '1' THEN 'EM ANALISE'
            WHEN t4.id_statussolicitacao = '2' THEN 'AGUARDANDO AGENDAMENTO'
            WHEN t4.id_statussolicitacao = '5' THEN 'CANCELADO'
            WHEN t1.status_agendamento = 'A' THEN 'AGENDADO'
            WHEN t4.id_statussolicitacao = '9' THEN 'INDEFERIDO'
            WHEN t4.id_statussolicitacao = '10' THEN 'DEVOLVIDO'
        END AS status_agendamento_2
    FROM
        reg_tb_agendamentos t1
    LEFT JOIN 
        tb_paciente t2 ON t2.id_paciente = t1.id_paciente 
    LEFT JOIN 
        reg_tb_procedimento t3 ON t3.id_procedimento = t1.id_procedimento 
    LEFT JOIN 
        reg_tb_solicitacoes t4 ON t4.id_solicitacao = t1.id_solicitacao 
    WHERE 
       t1.status_agendamento = 'A'
       $cpf_filter

    UNION

    SELECT DISTINCT
        t1.id_paciente,
        t2.nome_paciente,
        t1.id_solicitacao,
        t3.id_procedimento, 
        t3.nome_procedimento, 
        t2.cns_paciente,
        t2.cpf_paciente,
        t4.tipo_vagaocupada,
        t4.id_agendamento,
        DATE_FORMAT(t4.data_atendimento, '%d/%m/%Y') AS data_atendimento,
        t4.horario_atendimento,
        DATE_FORMAT(t4.dataprazo_retirada, '%d/%m/%Y') AS dataprazo_retirada,
        CASE
            WHEN t1.id_statussolicitacao = '1' THEN 'EM ANALISE'
            WHEN t1.id_statussolicitacao = '2' THEN 'AGUARDANDO AGENDAMENTO'
            WHEN t1.id_statussolicitacao = '5' THEN 'CANCELADO'
            WHEN t4.status_agendamento = 'A' THEN 'AGENDADO'
            WHEN t1.id_statussolicitacao = '9' THEN 'INDEFERIDO'
            WHEN t1.id_statussolicitacao = '10' THEN 'DEVOLVIDO'
        END AS status_agendamento_2
    FROM
        reg_tb_solicitacoes t1
    LEFT JOIN 
        tb_paciente t2 ON t2.id_paciente = t1.id_paciente 
    LEFT JOIN 
        reg_tb_procedimento t3 ON t3.id_procedimento = t1.id_procedimento 
    LEFT JOIN 
        reg_tb_agendamentos t4 ON t4.id_solicitacao = t1.id_solicitacao 
    WHERE 
       (t1.id_statussolicitacao = '2' OR t1.id_statussolicitacao = '1')
       $cpf_filter
    ORDER BY 
       data_atendimento;
    ";

    $resultado = $conn_mysql->query($sql);

    if ($resultado->num_rows > 0) {
        $formatados = formatarResultados($resultado);
        $mensagem_formatada = $formatados['mensagem'];
        $agendamentosParaJson = $formatados['json'];
        $agendamentosAguardando = $formatados['aguardando'];
        $agendamentosanalise = $formatados['emAnalise'];
        $temAgendamentoNaoPoliclinica = $formatados['temAgendamentoNaoPoliclinica'];
        $temAgendamento = $formatados['temAgendamento'];
        $nome_paciente_unico = $formatados['nome_paciente_unico'];

        if ($temAgendamentoNaoPoliclinica) {
            $mensagem_formatada .= "🙎🏽‍♀️ Você deseja receber o arquivo da marcação para o seu atendimento? Digite 1 para SIM ou 2 para NÃO!\n";
            $mensagem_formatada .= "\n";
            $mensagem_formatada .= "🙎🏽‍♀️ Olha! Se desejar cancelar um agendamendo, volte ao menu de opções e escola a opção 3!\n";
            $mensagem_formatada .= "\n";
            $mensagem_formatada .= "🙎🏽‍♀️ Ah! Não esqueça! Se você escolher NÃO receber o arquivo, e nem retirar sua marcação no sistema, ao vencer o prazo para retirada informado acima, seu agendamento será cancelado!\n";
            
        }

        // Exibir mensagem de solicitações em análise ou aguardando agendamento apenas se não houver agendamentos
        if (!$temAgendamento) {
            if (!empty($agendamentosAguardando) && !empty($agendamentosanalise)) {
                $countAgendamentosAguardando = count($agendamentosAguardando);
                $countAgendamentosAnalise = count($agendamentosanalise);
                
                $mensagem_formatada .= "Encontrei as seguintes solicitações registradas no CPF/CNS informado.\n";
                $mensagem_formatada .= "\n";
                $mensagem_formatada .= "▪️ Paciente: " . $nome_paciente_unico . "\n";
                $mensagem_formatada .= "🚨 Você possui " . $countAgendamentosAguardando . " solicitação" . ($countAgendamentosAguardando > 1 ? "es" : "") . " aguardando agendamento e " . $countAgendamentosAnalise . " solicitação" . ($countAgendamentosAnalise > 1 ? "es" : "") . " em análise. Para mais informações, consulte o site: https://regulacaomunicipal.pmlf.ba.gov.br\n";
            } elseif (!empty($agendamentosanalise)) {
                $countAgendamentosAnalise = count($agendamentosanalise);
                
                $mensagem_formatada .= "Encontrei as seguintes solicitações registradas no CPF/CNS informado.\n";
                $mensagem_formatada .= "\n";
                $mensagem_formatada .= "▪️ Paciente: " . $nome_paciente_unico . "\n";
                $mensagem_formatada .= "🚨 Você possui " . $countAgendamentosAnalise . " solicitação" . ($countAgendamentosAnalise > 1 ? "es" : "") . " em análise. Para mais informações, consulte o site: https://regulacaomunicipal.pmlf.ba.gov.br\n";
            } elseif (!empty($agendamentosAguardando)) {
                $countAgendamentosAguardando = count($agendamentosAguardando);
                
                $mensagem_formatada .= "Encontrei as seguintes solicitações registradas no CPF/CNS informado.\n";
                $mensagem_formatada .= "\n";
                $mensagem_formatada .= "▪️ Paciente: " . $nome_paciente_unico . "\n";
                $mensagem_formatada .= "🚨 Você possui " . $countAgendamentosAguardando . " solicitação" . ($countAgendamentosAguardando > 1 ? "es" : "") . " aguardando agendamento. Para mais informações, consulte o site: https://regulacaomunicipal.pmlf.ba.gov.br\n";
            } else {
                $mensagem_formatada .= "Não encontrei nenhum registro em nosso banco de dados para o documento informado.\n";
            }
        }
        
    } else {
        $mensagem_formatada = "Não encontrei nenhum registro em nosso banco de dados para o documento informado.\n";
        $agendamentosParaJson = array();
    }
    
    $resposta['mensagem_formatada'] = $mensagem_formatada;
    $resposta['data'] = $agendamentosParaJson;
} else {
    $resposta['mensagem_formatada'] = 'Por favor, especifique um CPF ou CNS na URL.';
}

//header('Content-Type: application/json');
echo json_encode($resposta);

$conn_mysql->close();
?>
