<?php
session_start();
if (!isset($_SESSION['idUsuarioLogado'])) {
  header("location: ./");
}
include_once("header.php");
require("../database/dbConection.php");

$idPerfilLogado = $_SESSION['idPerfilLogado'];
$idPacienteGet  = $_GET['idpac'];
$opcaoTela      = $_GET['op'];

$dataHoraAgendamento  = date("d/m/Y H:i");

$sqlPaciente  = "SELECT tb_paciente.*, date_format(tb_paciente.datanasc,'%d/%m/%Y') AS nascimentoPaciente, TIMESTAMPDIFF(YEAR, datanasc, NOW()) AS idadePaciente, tb_cidades.nome_cidade FROM tb_paciente INNER JOIN tb_cidades ON (tb_paciente.codigocidade=tb_cidades.codigoibge_cidade) WHERE tb_paciente.id_paciente='$idPacienteGet'";
$stmPaciente  = $rsConexao->prepare($sqlPaciente);
$stmPaciente->execute();
$rsPaciente    = $stmPaciente->fetch(PDO::FETCH_OBJ);

$idPaciente               = $rsPaciente->id_paciente;
$nomePaciente             = $rsPaciente->nome_paciente;
$idadePaciente            = $rsPaciente->idadePaciente;
$nascimentoPaciente       = $rsPaciente->nascimentoPaciente;
$sexoPaciente             = $rsPaciente->sexo;
$cnsPaciente              = $rsPaciente->cns_paciente;
$cpfPaciente              = $rsPaciente->cpf_paciente;
$municipioPaciente        = $rsPaciente->nome_cidade;
$bairrroPaciente          = $rsPaciente->bairro_paciente;
$ibgeCidade               = $rsPaciente->codigocidade;
$telefoneCelular1         = $rsPaciente->celular1;
$telefoneCelular1Whatsapp = $rsPaciente->celular1_whatsapp == "S" ? " checked" : "";
$telefoneCelular2         = $rsPaciente->celular2;
$telefoneCelular2Whatsapp = $rsPaciente->celular2_whatsapp == "S" ? " checked" : "";
$telefoneCelular3         = $rsPaciente->celular3;
$telefoneCelular3Whatsapp = $rsPaciente->celular3_whatsapp == "S" ? " checked" : "";

$formatarStatus = array(
  'A' => 'AGENDADO',
  'E' => 'AGENDADO/ENTREGUE',
  'C' => 'CANCELADO',
  'P' => 'PENDENTE',
  'V' => 'ATENDIDO',
  'X' => 'CANCELAR',
  'R' => 'AUT. REAGENDAR'
);

?>

<div class="app-content content" style="background-color: #e1e9e7;">
  <div class="content-wrapper" style="padding: 10px;">
    <section id="ordering">
      <div class="row">
        <div class="col-12">
          <div class="card" style="border: gray 1px solid;" id="card-tela">
            <div class="card-header titulo-telas">
              <i class="icofont icofont-checked" style='margin-top:-15px !important'></i>&nbsp;Realizar Agendamento
              <a class="heading-elements-toggle"><i class="fa fa-ellipsis-v font-medium-3"></i></a>
              <div class="heading-elements">
                <ul class="list-inline mb-0" style="margin-top: -12px; color: #fff;">
                  <li>
                    <a data-action="collapse"><i class="ft-minus"></i></a>
                  </li>
                  <li>
                    <a data-action="expand"><i class="ft-maximize"></i></a>
                  </li>
                </ul>
              </div>
            </div>
            <div class="card-content collapse show">
              <div class="card-body novo-padding-cardbody">
                <div class="row">
                  <div class="col-md-12">
                    <div class="form-group">
                      <ul class="nav nav-tabs nav-topline">
                        <li class="nav-item">
                          <a class="nav-link active" id="base-dadosSolicitacao" data-toggle="tab" aria-controls="dadosSolicitacao" href="#dadosSolicitacao" aria-expanded="true"><b><i class='icofont icofont-edit'></i> DADOS DO AGENDAMENTO&nbsp;&nbsp;</b></a>
                        </li>
                        <li class="nav-item">
                          <a class="nav-link" id="base-dadosAgendamentos" data-toggle="tab" aria-controls="dadosAgendamentos" href="#dadosAgendamentos" aria-expanded="true"><b><i class='icofont icofont-files'></i> AGENDAMENTOS EXISTENTES&nbsp;&nbsp;</b></a>
                        </li>
                      </ul>
                      <div class="tab-content px-1 pt-1 border-grey border-lighten-2 border-0-top">
                        <div role="tabpanel" class="tab-pane active" id="dadosSolicitacao" aria-expanded="true" aria-labelledby="base-dadosSolicitacao">
                          <form class="form" style='margin-top:-10px'>
                            <div class="form-body">
                              <h4 class="form-section"><i class="ft-user"></i><b>Informações do paciente</b>
                                <input type="hidden" id="idPaciente" value="<?php echo $idPaciente; ?>" disabled />
                              </h4>
                              <div class="row" style="margin-top: -10px;">
                                <div class="col-md-4">
                                  <div class="form-group">
                                    <label for="nomePaciente">Nome:</label>
                                    <input type="text" id="nomePaciente" class="form-control" value="<?php echo $nomePaciente; ?>" disabled />
                                  </div>
                                </div>
                                <div class="col-md-2">
                                  <div class="form-group">
                                    <label for="nascimentoPaciente">Nascimento:</label>
                                    <input type="text" id="nascimentoPaciente" class="form-control text-center" value="<?php echo $nascimentoPaciente; ?>" disabled />
                                  </div>
                                </div>
                                <div class="col-md-2">
                                  <div class="form-group">
                                    <label for="idadePaciente">Idade:</label>
                                    <input type="text" id="idadePaciente" class="form-control text-center" value="<?php echo $idadePaciente; ?>" disabled />
                                  </div>
                                </div>
                                <div class="col-md-2">
                                  <div class="form-group">
                                    <label for="cpfPaciente">CPF:</label>
                                    <input type="text" id="cpfPaciente" class="form-control text-center cpf-inputmask" value="<?php echo $cpfPaciente; ?>" disabled />
                                  </div>
                                </div>
                                <div class="col-md-2">
                                  <div class="form-group">
                                    <label for="cnsPaciente">Cartão SUS:</label>
                                    <input type="text" id="cnsPaciente" class="form-control text-center" value="<?php echo $cnsPaciente; ?>" disabled />
                                  </div>
                                </div>
                              </div>
                            </div>
                            <div class="form-body" style="margin-top: -15px;">
                              <h4 class="form-section"><i class="icofont icofont-architecture-alt"></i><b>Informações para Agendamento</b></h4>
                              <div class="row" style="margin-top:-17px;">
                                <div class="col-md-12">
                                  <div class="form-group">
                                    <div class="bs-callout-danger callout-square callout-bordered mt-1" style='margin-top:0px !important'>
                                      <div class="media align-items-stretch">
                                        <div class="media-left d-flex align-items-center bg-danger p-2" style='padding:7px !important;'>
                                          <i class="icofont icofont-info-circle white font-medium-5"></i>
                                        </div>
                                        <div class="media-body p-1" style="padding:7px !important; padding-left:10px !important; font-family: Calibri; font-size:14pt">
                                          <strong>
                                            <b>ATENÇÃO:</b> Ao selecionar mais de um procedimento, serão listados apenas os estabelecimentos de saúde que oferecem, em sua agenda, todos os procedimentos selecionados.
                                          </strong>
                                        </div>
                                      </div>
                                    </div>
                                  </div>
                                </div>
                              </div>
                              <div class="row" style='margin-top:-15px'>
                                <div class="col-md-4">
                                  <div class="form-group">
                                    <label for="grupoProcedimento">Grupo:</label>
                                    <select class="form-control" id="grupoProcedimento">
                                      <option value="">SELECIONE...</option>
                                      <?php
                                      $stmGrupoProcedimento = $rsConexao->prepare("SELECT * FROM reg_tb_procedimento_grupo  WHERE nome_grupo_procedimento!='NÃO AGRUPADOS' ORDER BY nome_grupo_procedimento");
                                      $stmGrupoProcedimento->execute();
                                      $rsGrupoProcedimento  = $stmGrupoProcedimento->fetchAll(PDO::FETCH_ASSOC);
                                      foreach ($rsGrupoProcedimento as $fieldGrupoProcedimento) {
                                        $idGrupoProcedimento    = $fieldGrupoProcedimento['id_grupo_procedimento'];
                                        $nomeGrupoProcedimento  = $fieldGrupoProcedimento['nome_grupo_procedimento'];
                                        if (strpos($nomeGrupoProcedimento, "LABORAT") !== false) {
                                          echo "<option value='$idGrupoProcedimento'>GRUPO - $nomeGrupoProcedimento</option>";
                                        }
                                      }
                                      ?>
                                    </select>
                                  </div>
                                </div>
                                <div class="col-md-4">
                                  <div class="form-group">
                                    <label>&nbsp;</label><br>
                                    <button type='button' class='btn btn-blue' onClick="filtrarProcedimentos()" style='width: 112px'>
                                      <i class='icofont icofont icofont-list'></i>&nbsp;&nbsp;Listar
                                    </button>&nbsp;&nbsp;
                                    <button type='button' class='btn btn-danger' onClick="limparListaProcedimentos()" style='width: 140px'>
                                      <i class='icofont icofont-refresh'></i>&nbsp;&nbsp;Limpar Listas
                                    </button>
                                  </div>
                                </div>
                                <div class="col-md-4">
                                  <div class="form-group" style='text-align:right;'>
                                    <label>&nbsp;</label><br>
                                    <table style='width:350px' align='right'>
                                      <tr>
                                        <td align='right'>
                                          <input type="text" class="form-control text-right form-control-novodisabled" id="totalProcedimentosSelecionados" value="Procedimentos selecionados: 0" disabled />
                                        </td>
                                      </tr>
                                    </table>
                                    </button>
                                  </div>
                                </div>
                              </div>
                              <hr style='margin-top:-12px; padding-top:5px'>
                              <div class="row" style="margin-top: -10px;">
                                <div class="col-md-6">
                                  <div class="form-group" style='border-bottom: 2px gray dashed; line-height: 8px; padding:10px; padding-left:5px; background-color: #8af3d9;'>
                                    <b>PROCEDIMENTOS DISPONÍVEIS:</b>
                                  </div>
                                </div>
                                <div class="col-md-6">
                                  <div class="form-group" style='border-bottom: 2px gray dashed; line-height: 8px; padding:10px; padding-left:5px; background-color:rgb(111, 205, 252);'>
                                    <b>PROCEDIMENTOS SELECIONADOS:</b>
                                  </div>
                                </div>
                              </div>
                              <div class="row" style="margin-top: -15px;">
                                <div class="col-md-12">
                                  <div class="form-group">
                                    <select multiple="multiple" size="15" class="duallistbox-multi-selection" id='listaProcedimentosAgendar'>
                                    </select>
                                  </div>
                                </div>
                              </div>
                              <hr style='margin-top:-12px; padding-top:5px'>
                              <div class="row" style='margin-top:-20px'>
                                <div class="col-sm-12" style="padding-top:5px;">
                                  <div class="form-group">
                                    <table>
                                      <tr>
                                        <td style='padding-top:22px'>
                                          <?php
                                          if ($idPerfilLogado == 1 || $idPerfilLogado == 11 || $idPerfilLogado == 12) {
                                          ?>
                                            <button type="button" class="btn btn-success" onClick="pesquisarVagaDisponivel('PVez')" id="btnPrimeiraVezA" disabled>
                                              <i class="icofont icofont-document-search"></i> Procurar Vagas - <b>1ª Vez</b>
                                            </button>
                                            <button type="button" class="btn btn-warning" onClick="pesquisarVagaDisponivel('reserva')" id="btnReservaA" disabled>
                                              <i class="icofont icofont-document-search"></i> Procurar Vagas - <b>Reserva</b>
                                            </button>
                                          <?php
                                          } else if ($idPerfilLogado == 4) {
                                          ?>
                                            <button type="button" class="btn btn-success" onClick="pesquisarVagaDisponivel('PVez')" id="btnPrimeiraVezB" disabled>
                                              <i class="icofont icofont-document-search"></i> Procurar Vagas - <b>1ª Vez</b>
                                            </button>
                                          <?php
                                          } else if ($idPerfilLogado == 14) {
                                          ?>
                                            <button type="button" class="btn btn-warning" onClick="pesquisarVagaDisponivel('reserva')" id="btnReservaB" disabled>
                                              <i class="icofont icofont-document-search"></i> Procurar Vagas - <b>Reserva</b>
                                            </button>
                                          <?php
                                          }
                                          ?>
                                        </td>
                                        <td width='20px'></td>
                                        <td>
                                          <label style='margin-top:-15px' for="dataPrazoRetirada">Prazo de Retirada:</label>
                                          <input type="date" class="form-control text-center" id="dataPrazoRetirada" style='margin-top:-6px; width:270px;' />
                                        </td>
                                      </tr>
                                    </table>
                                  </div>
                                </div>
                              </div>
                              <div class="row" style="margin-top: -15px; padding-right:10px; display:none" id='td-com-vagas'>
                                <div class="col-md-12">
                                  <div class="form-group">
                                    <div class="bs-callout-success callout-square callout-bordered mt-1" id='callout-vd' style='margin-top:0px !important'>
                                      <div class="media align-items-stretch">
                                        <div class="media-left d-flex align-items-center bg-success p-2" id='media-left-vd' style='padding:7px !important;'>
                                          <i class="icofont icofont-checked white font-medium-5"></i>
                                        </div>
                                        <div class="media-body p-1" style='padding:7px !important; padding-left:10px !important; font-size:13pt'>
                                          <strong id='strong-vagadisponivel'>VAGAS DISPONÍVEIS</strong>
                                        </div>
                                      </div>
                                    </div>
                                  </div>
                                </div>
                              </div>
                              <div class="row" style="margin-top: -15px; padding-right:10px;display:none" id='td-sem-vagas'>
                                <div class="col-md-12">
                                  <div class="form-group">
                                    <div class="bs-callout-danger callout-square callout-bordered mt-1" style='margin-top:0px !important'>
                                      <div class="media align-items-stretch">
                                        <div class="media-left d-flex align-items-center bg-danger p-2" style='padding:7px !important;'>
                                          <i class="icofont icofont-close-squared white font-medium-5"></i>
                                        </div>
                                        <div class="media-body p-1" style='padding:7px !important; padding-left:10px !important; font-size:13pt'>
                                          <strong>NÃO HÁ VAGAS DISPONÍVEIS (ou laboratório que realize todos os procedimentos selecionados).</strong>
                                        </div>
                                      </div>
                                    </div>
                                  </div>
                                </div>
                              </div>
                              <div class="row" style="margin-top:-18px;padding-right:10px">
                                <div class="col-md-12">
                                  <input type='hidden' class="form-control text-center" id="idVagaSelecionada" value="" disabled>
                                  <div class="form-group" id='exibirProcedimentoDisponiveis'>
                                  </div>
                                </div>
                              </div><br>
                            </div>
                        </div>
                        <div class="tab-pane" id="dadosAgendamentos" aria-labelledby="base-dadosAgendamentos">
                          <div class="row">
                            <div class='col-md-12'>
                              <table class="table table-striped table-bordered default-ordering table-responsive-xl2" id="agendamentos_existentes" style='width:100%'>
                                <thead>
                                  <tr>
                                    <th>PROCEDIMENTO</th>
                                    <th align='center'>STATUS</th>
                                    <th>PROFISSIONAL</th>
                                    <th>UNIDADE</th>
                                    <th style='text-align:center'>DATA</th>
                                    <th style='text-align:center'>HORÁRIO</th>
                                    <th>ORIGEM</th>
                                  </tr>
                                </thead>
                                <tbody style="background-color: #ececec;">
                                  <?php
                                  $sqlAgendamentos  = "SELECT reg_tb_procedimento.nome_procedimento,
                                  tb_estabelecimento.nfantasia_estabelecimento,
                                  tb_profissional.nome_profissional,
                                  reg_tb_agendamentos.id_agendamento,
                                  date_format(reg_tb_agendamentos.data_atendimento, '%d/%m/%Y') AS dataAtendmento,
                                  date_format(reg_tb_agendamentos.data_atendimento, '%Y%m%d') AS dataAtendmentoOrdem,
                                  reg_tb_agendamentos.data_atendimento,
                                  reg_tb_agendamentos.status_agendamento,
                                  reg_tb_agendamentos.horario_atendimento,
                                  reg_tb_agendamentos.tipo_vagaocupada
                                  FROM reg_tb_agenda
                                  INNER JOIN tb_profissional ON (reg_tb_agenda.codigoprofissional_cnes=tb_profissional.codigoprofissional_cnes)
                                  INNER JOIN tb_estabelecimento ON (reg_tb_agenda.codigoestabelecimento_cnes=tb_estabelecimento.codigoestabelecimento_cnes)
                                  RIGHT OUTER JOIN reg_tb_agendamentos ON (reg_tb_agendamentos.id_agenda = reg_tb_agenda.id_agenda)
                                  INNER JOIN reg_tb_procedimento ON (reg_tb_agendamentos.id_procedimento=reg_tb_procedimento.id_procedimento)
                                  WHERE (reg_tb_agendamentos.id_paciente='$idPaciente')
                                  ORDER BY reg_tb_agendamentos.data_atendimento ASC,
                                  reg_tb_agendamentos.horario_atendimento ASC";
                                  $stmAgendamentos  = $rsConexao->prepare($sqlAgendamentos);
                                  $stmAgendamentos->execute();
                                  if ($stmAgendamentos->rowCount() > 0) {
                                    $rsAgendamentos = $stmAgendamentos->fetchAll(PDO::FETCH_ASSOC);
                                    foreach ($rsAgendamentos as $fieldAgendamentos) {
                                      $idAgendamento          = $fieldAgendamentos['id_agendamento'];
                                      $nomeProcedimento       = mb_strtoupper($fieldAgendamentos['nome_procedimento']);
                                      $statusAgendamento      = $formatarStatus[$fieldAgendamentos['status_agendamento']];
                                      $nomeProfissional       = mb_strtoupper($fieldAgendamentos['nome_profissional']);
                                      $nomeUnidade            = mb_strtoupper($fieldAgendamentos['nfantasia_estabelecimento']);
                                      $dataAtendimento        = mb_strtoupper($fieldAgendamentos['dataAtendmento']);
                                      $validarDataCMD         = $fieldAgendamentos['data_atendimento'];
                                      $dataAtendmentoOrdem    = $fieldAgendamentos['dataAtendmentoOrdem'];
                                      $horaAtendimento        = mb_strtoupper($fieldAgendamentos['horario_atendimento']);
                                      $tipoVagaOcupada        = mb_strtoupper($fieldAgendamentos['tipo_vagaocupada']);
                                      $styleRegistroCancelado = $fieldAgendamentos['status_agendamento'] != "C" ? "" : "style='background-color: #ffadad;color: #860000;'";

                                      if ($tipoVagaOcupada == 'PVEZ' || $tipoVagaOcupada == "RETORNO" || $tipoVagaOcupada == "RESERVA") {
                                        if ($tipoVagaOcupada == 'PVEZ') {
                                          $origemAgendamento  = "VAGA DO SISTEMA<br><b><font style='color:#00509F; font-size:7pt'>AGENDA - (PRIMEIRA VEZ)</font></b>";
                                        } else {
                                          $origemAgendamento  = "VAGA DO SISTEMA<br><b><font style='color:#00509F; font-size:7pt'>AGENDA - ($tipoVagaOcupada)</font></b>";
                                        }
                                        # -- comando para impressão da marcação do sistema -- #
                                        if ($validarDataCMD >= date("Y-m-d") && ($statusAgendamento == "ENTREGUE")) {
                                          $comandoImprimirAgendamento = 'onClick="window.open(' . "'direcionar?opdir=imp-agendamento&idagendamento=$idAgendamento&origem=S-FG')" . '"';
                                          $botaoImprimirAgendamento   = "<i class='icofont icofont-printer nova_fonte' title='Imprimir agendamento.' $comandoImprimirAgendamento></i>";
                                        } else {
                                          $botaoImprimirAgendamento   = "";
                                        }
                                        # -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- #

                                        if (($statusAgendamento == "AGENDADO" || $statusAgendamento == "PENDENTE") && ($idPerfilLogado == '1' || $idPerfilLogado == '14')) {
                                          $linkAutorizaAgendamento  = 'onclick="autorizarAgendamento(' . "'$idAgendamento')" . '"';
                                          $autorizarAgendamento     = "<i class='icofont icofont-checked nova_fonte_blue' $linkAutorizaAgendamento title='Autorizar agendamento do procedimento.'></i>";
                                        } else {
                                          $autorizarAgendamento = "";
                                        }
                                        echo "<tr>
                                        <td style='padding:5px'>$botaoImprimirAgendamento&nbsp;&nbsp;&nbsp;$nomeProcedimento</td>
                                        <td $styleRegistroCancelado id='autoriza$idAgendamento'>
                                          $autorizarAgendamento
                                          <font style='font-size:9pt'><b>$statusAgendamento</b></font>
                                        </td>
                                        <td>$nomeProfissional</td>
                                        <td>$nomeUnidade</td>
                                        <td align='center'><font style='font-size:0.5px; color:#fff'>$dataAtendmentoOrdem</font>$dataAtendimento</td>
                                        <td align='center'>$horaAtendimento</td>
                                        <td align='center'>$origemAgendamento</td>
                                        </tr>";
                                      } else {
                                        $origemAgendamento  = "VAGA EXTERNA<br><b><font style='color:#00509F; font-size:7pt'>($tipoVagaOcupada)</font></b>";
                                        if ($validarDataCMD >= date("Y-m-d") && ($statusAgendamento == "ENTREGUE")) {
                                          # -- comando para impressão da marcação externa -- #
                                          $numeracaoArquivo   = str_pad($idAgendamento, 8, "0") . "AA";
                                          $stmArquivoExterno  = $rsConexao->prepare("SELECT * FROM reg_tb_solicitacoes_agendado WHERE id_agendamento_direto='$idAgendamento'");
                                          $stmArquivoExterno->execute();
                                          $rsArquivoExterno   = $stmArquivoExterno->fetch(PDO::FETCH_OBJ);
                                          $diretorioArquivo   = "docagendamentos/" . $rsArquivoExterno->pasta_documento . "/" . $numeracaoArquivo . "_" . $rsArquivoExterno->nomearquivo_documento;
                                          $comandoImprimirAgendamento  = 'onClick="window.open(' . "'$diretorioArquivo')" . '"';
                                          $botaoImprimirAgendamento    = "<i class='icofont icofont-printer nova_fonte' title='Imprimir agendamento.' $comandoImprimirAgendamento></i>";
                                          # -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- #
                                        } else {
                                          $origemAgendamento  = "VAGA EXTERNA<br><b><font style='color:#00509F; font-size:7pt'>($tipoVagaOcupada)</font></b>";
                                          $botaoImprimirAgendamento = "";
                                        }
                                        echo "<tr>
                                        <td style='padding:5px'>
                                          $botaoImprimirAgendamento
                                          $nomeProcedimento
                                          </td>
                                        <td $styleRegistroCancelado>
                                          $statusAgendamento
                                        </td>
                                        <td>NÃO INFORMADO</td>
                                        <td>NÃO INFORMADO</td>
                                        <td align='center'>NÃO INFORMADO</td>
                                        <td align='center'>NÃO INFORMADO</td>
                                        <td align='center'>$origemAgendamento</td>
                                        </tr>";
                                      }
                                    }
                                  }
                                  ?>
                                </tbody>
                              </table>
                            </div>
                          </div>
                        </div>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </section>
  </div>
</div>

<div class="barra-flutuante">
  <button type="button" class="btn btn-blue" id="btnConfirmarAgendamento" onClick="gravarAgendamento()" disabled>
    <i class="fa fa-check-square-o"></i> Confirmar
  </button>
  <button type='button' class='btn btn-green' onClick="window.location.href='paciente_buscar?op=<?php echo $opcaoTela; ?>'">
    <i class='icofont icofont icofont-medical'></i>&nbsp;&nbsp;Novo Agendamento
  </button>
</div>

<?php
include_once("footer.php");
include_once("include/box_obs_agendamento.php");

?>

<script src="../app-assets/vendors/js/forms/extended/inputmask/jquery.inputmask.bundle.min.js"></script>
<script src="../app-assets/js/scripts/forms/extended/form-inputmask.min.js"></script>
<script src="../app-assets/vendors/js/tables/datatable/datatables.min.js"></script>
<script src="../app-assets/js/scripts/tables/datatables/datatable-basic.min.js"></script>
<script src="../app-assets/js/scripts/ui/jquery-ui/buttons-selects.min.js"></script>

<script>
  $("#liLaboratorioAgendarDireto").attr('class', 'active');
  $("#liLaboratorioAgendarDireto").css("border-bottom", "2px solid #c4c8ca");

  $('#agendamentos_existentes').DataTable({
    "filter": false,
    "lengthChange": false,
    "info": false
  });

  $('#documentos_agendados').DataTable({
    "paging": false,
    "filter": false,
    "lengthChange": false,
    "info": false
  });


  function pegarIdVagaSelecionada(selId) {
    var registroSelecionado = selId.split("#")
    var dataVaga = registroSelecionado[4].substr(0, 10)
    $("#dataVagaReferencia").val(dataVaga);
    $("#idVagaSelecionada").val(selId);
    $("#btnConfirmarAgendamento").prop("disabled", false);
    $("#dataPrazoRetirada").val(dataVaga);
  }

  function filtrarProcedimentos() {

    var listaProcedimentosAgendar = $('#listaProcedimentosAgendar');

    if ($("#grupoProcedimento").val() == "") {
      swal("Grupo de Procedimentos", "Selecione o grupo de procedimentos.", "error");
      return false;
    }
    $("#embacado").css("display", "block");
    $.ajax({
      url: 'filtros/filtrar_procedimento',
      type: 'post',
      dataType: 'html',
      data: {
        'opcaoPesquisa': 'laboratorio-agendar',
        'grupoProcedimento': $("#grupoProcedimento").val()
      }
    }).done(function(resultadoRetorno) {
      listaProcedimentosAgendar.empty(), listaProcedimentosAgendar.bootstrapDualListbox("refresh", !0);
      listaProcedimentosAgendar.append(resultadoRetorno), listaProcedimentosAgendar.bootstrapDualListbox("refresh", !0);
      $("#embacado").css("display", "none");
    });

  }

  function limparListaProcedimentos() {
    var listaProcedimentosAgendar = $('#listaProcedimentosAgendar');
    listaProcedimentosAgendar.empty(), listaProcedimentosAgendar.bootstrapDualListbox("refresh", !0);
  }

  function pesquisarVagaDisponivel(tipoVaga) {
    const listaProcedimentosAgendar = document.getElementById('listaProcedimentosAgendar');
    var totalSelecionado = 0;
    $('#listaProcedimentosAgendar option:selected').each(function() {
      totalSelecionado = totalSelecionado + 1;
    });

    if (totalSelecionado == 0) {
      swal("Selecionar Procedimento", "Você não selecionou nenhum procedimento para agendamento.", "error");
      return false;
    }

    const procedimentoSelecionado = [];
    for (let contarLinhas = 0; contarLinhas < listaProcedimentosAgendar.options.length; contarLinhas++) {
      const tagOption = listaProcedimentosAgendar.options[contarLinhas];
      // Verifica se a opção está selecionada
      if (tagOption.selected) {
        procedimentoSelecionado.push(tagOption.value); // Adiciona o valor da opção
      }
    }

    $("#embacado").css("display", "block");
    $.ajax({
      url: 'filtros/filtrar_vagasdisponiveis_lab',
      type: 'post',
      dataType: 'html',
      data: {
        'opcaoPesquisa': 'agendar-laboratorio',
        'idGrupoProcedimento': $("#grupoProcedimento").val(),
        'idProcedimento': procedimentoSelecionado,
        'tipoVaga': tipoVaga
      }
    }).done(function(resultadoRetorno) {
      $("#embacado").css("display", "none");
      if (resultadoRetorno != "nenhumaVaga") {
        $("#td-sem-vagas").css('display', 'none');
        $("#td-com-vagas").css('display', 'block');
        if(tipoVaga=="PVez"){
          $("#media-left-vd").removeClass("bg-warning")
          $("#callout-vd").removeClass("bs-callout-warning")
          $("#callout-vd").addClass("bs-callout-success")
          $("#strong-vagadisponivel").html("VAGAS DISPONÍVEIS - PRIMEIRA VEZ");
        }
        if(tipoVaga=="reserva"){
          $("#media-left-vd").addClass("bg-warning")
          $("#callout-vd").addClass("bs-callout-warning")
          $("#callout-vd").removeClass("bs-callout-success")
          $("#strong-vagadisponivel").html("VAGAS DISPONÍVEIS - RESERVA");
        }
        $("#exibirProcedimentoDisponiveis").html(resultadoRetorno);
      } else {
        $("#td-com-vagas").css('display', 'none');
        $("#td-sem-vagas").css('display', 'block');
        $("#exibirProcedimentoDisponiveis").html("");
      }
    });

  }

  function gravarAgendamento() {

    var obtemDataHoje = new Date();
    var anoAtual = obtemDataHoje.getFullYear();
    var mesAtual = obtemDataHoje.getMonth() + 1;
    var diaAtual = obtemDataHoje.getDate();
    var dataHoje = anoAtual + '-' + ("00" + mesAtual).slice(-2) + '-' + ("00" + diaAtual).slice(-2);

    if ($("#dataPrazoRetirada").val() == "") {
      swal("Prazo de Retirada", "Você deve informar um prazo de retirada da marcação.", "error");
      return false;
    }

    var splitCodigos = $("#idVagaSelecionada").val().split("#");
    var idAgenda = splitCodigos[1];
    var idAgendaSub = splitCodigos[2];
    var tipoVagaOcupada = splitCodigos[3];

    const listaProcedimentosAgendar = document.getElementById('listaProcedimentosAgendar');
    const procedimentoSelecionado = [];
    for (let contarLinhas = 0; contarLinhas < listaProcedimentosAgendar.options.length; contarLinhas++) {
      const tagOption = listaProcedimentosAgendar.options[contarLinhas];
      // Verifica se a opção está selecionada
      if (tagOption.selected) {
        procedimentoSelecionado.push(tagOption.value); // Adiciona o valor da opção
      }
    }
    $("#embacado").css("display", "block");
    $.ajax({
      url: 'action/gravar_agendamento_laboratorio',
      type: 'post',
      dataType: 'html',
      data: {
        'opcaoAgendamento': 'LAB-D',
        'idPaciente': $("#idPaciente").val(),
        'idVaga': idAgenda,
        'idVagaSub': idAgendaSub,
        'tipoVagaOcupada': tipoVagaOcupada,
        'prazoRetirada': $("#dataPrazoRetirada").val(),
        'idGrupoProcedimento': $("#grupoProcedimento").val(),
        'procedimentoSelecionado': procedimentoSelecionado
      }
    }).done(function(resultadoRetorno) {

      if (resultadoRetorno == "JáExiste") {
        $("#embacado").css("display", "none");
        swal("Agendamento Existente", "Paciente com agendamento de laboratório pendente de atendimento.", "error");
        return false;
      }
      /* CARREGAR LISTA DE AGENDAMENTOS ATUALIZADA */
      $.ajax({
        url: 'filtros/filtrar_agendamentos',
        type: 'post',
        dataType: 'html',
        data: {
          'opcaoListagem': 'listar-agendamentos-paciente-tela-agendamento',
          'idPaciente': $("#idPaciente").val()
        }
      }).done(function(retornoResultado) {
        $('#agendamentos_existentes').DataTable().destroy();
        $('#agendamentos_existentes tbody').empty().append(retornoResultado);
        $('#agendamentos_existentes').DataTable({
          "filter": false,
          "lengthChange": false,
          "info": false
        });
        //notificarAgendamento(resultadoRetorno);
        $("#embacado").css("display", "none");
        swal("Registro de Agendamento", "Agendamento registrado com sucesso.", "success");
        setInterval(function() {
          window.location.href = 'agendamento_verimpressao?viewheader=backview&tpag=lab';
        }, 2000);
        $("#idVagaSelecionada").val('');
        $("#dataPrazoRetirada").val('');
        $("#grupoProcedimento").val('');
        $("#grupoProcedimento").trigger("change");
      });
    });
  }

  $("#grupoProcedimento").change(function() {
    limparListaProcedimentos();
    $("#td-com-vagas").css('display', 'none');
    $("#td-sem-vagas").css('display', 'none');
    $("#exibirProcedimentoDisponiveis").html("");
  });

  $("#listaProcedimentosAgendar").change(function() {

    const listaProcedimentosAgendar = document.getElementById('listaProcedimentosAgendar');
    var totalSelecionado = 0;
    $('#listaProcedimentosAgendar option:selected').each(function() {
      totalSelecionado = totalSelecionado + 1;
    });

    if (totalSelecionado == 0) {
      $("#btnPrimeiraVezA").prop("disabled", true);
      $("#btnReservaA").prop("disabled", true);
      $("#btnPrimeiraVezB").prop("disabled", true);
      $("#btnReservaB").prop("disabled", true);
    } else {
      $("#btnPrimeiraVezA").prop("disabled", false);
      $("#btnReservaA").prop("disabled", false);
      $("#btnPrimeiraVezB").prop("disabled", false);
      $("#btnReservaB").prop("disabled", false);
    }

    $("#td-com-vagas").css('display', 'none');
    $("#td-sem-vagas").css('display', 'none');
    $("#exibirProcedimentoDisponiveis").html("");

    $("#totalProcedimentosSelecionados").val("Procedimentos selecionados: " + totalSelecionado);

  });
</script>