<?php
session_start();

function formataCNS($numeroCNS){
  $numeroInicio = substr($numeroCNS,0,3);
  $numeroMeio1  = substr($numeroCNS,3,4);
  $numeroMeio2  = substr($numeroCNS,7,4);
  $numeroMeio3  = substr($numeroCNS,11,4);
  return $numeroInicio . ' ' . $numeroMeio1 . ' ' . $numeroMeio2 . ' ' . $numeroMeio3;
}

$dataHoraImpressao  = date("d/m/Y H:i");
/************************************************************************************/
require("../database/dbConection.php");
$idUsuarioLogado    = $_SESSION['idUsuarioLogado'];
$nomeUsuarioLogado  = $_SESSION['nomeUsuarioLogado'];
$idAgendamento      = $_SESSION['idAgendamento'];

$tamanhoEtiqueta    = [79, 150];
$sqlAgendamento = "SELECT reg_tb_agendamentos.*,
date_format(reg_tb_agendamentos.data_atendimento, '%d/%m/%Y') AS dataAtendimento,
tb_estabelecimento.nfantasia_estabelecimento,
tb_estabelecimento.endereco_estabelecimento,
tb_estabelecimento.numeroend_estabelecimento,
tb_estabelecimento.bairro_estabelecimento,
tb_estabelecimento.pontoreferencia_estabelecimento,
tb_cidades.nome_cidade,
tb_estabelecimento.telefone1_estabelecimento,
tb_profissional.nome_profissional,
tb_paciente.nome_paciente,
tb_paciente.nomemae,
tb_paciente.cns_paciente,
tb_paciente.cpf_paciente,
date_format(tb_paciente.datanasc, '%d/%m/%Y') AS nascimentoPaciente,
TIMESTAMPDIFF(YEAR, datanasc, NOW()) AS idadePaciente,
tb_paciente.sexo,
tb_paciente.datanasc,
tb_paciente.celular1,
tb_paciente.celular2,
tb_paciente.celular3
FROM reg_tb_agenda
INNER JOIN reg_tb_agendamentos ON (reg_tb_agenda.id_agenda = reg_tb_agendamentos.id_agenda)
INNER JOIN tb_estabelecimento ON (reg_tb_agenda.codigoestabelecimento_cnes = tb_estabelecimento.codigoestabelecimento_cnes)
INNER JOIN tb_cidades ON (tb_cidades.codigoibge_cidade = tb_estabelecimento.codigoibge_cidade)
INNER JOIN tb_profissional ON (reg_tb_agenda.codigoprofissional_cnes = tb_profissional.codigoprofissional_cnes)
INNER JOIN tb_paciente ON (tb_paciente.id_paciente = reg_tb_agendamentos.id_paciente) 
WHERE (reg_tb_agendamentos.id_agendamento='$idAgendamento')";

$stmAgendamento = $rsConexao->prepare($sqlAgendamento);
$stmAgendamento->execute();
$rsAgendamento  = $stmAgendamento->fetch(PDO::FETCH_OBJ);

$codigoChave          = $rsAgendamento->chave_confirmacao;
$numeroProtocolo      = $rsAgendamento->protocolo_agendamento;
$dataAtendimento      = $rsAgendamento->dataAtendimento;
$horaAtendimento      = $rsAgendamento->horario_atendimento;
$nomeUnidade          = mb_strtoupper($rsAgendamento->nfantasia_estabelecimento);
$enderecoUnidade      = mb_strtoupper($rsAgendamento->endereco_estabelecimento . ", " . $rsAgendamento->numeroend_estabelecimento . " - " . $rsAgendamento->pontoreferencia_estabelecimento);
$bairroUnidade        = mb_strtoupper($rsAgendamento->bairro_estabelecimento);
$nomeProfissional     = mb_strtoupper($rsAgendamento->nome_profissional);
$nomePaciente         = $rsAgendamento->nome_paciente;
$cnsPaciente          = formataCNS($rsAgendamento->cns_paciente);
$idadePaciente        = $rsAgendamento->nascimentoPaciente . " ($rsAgendamento->idadePaciente anos)";
$telefonePaciente     = $rsAgendamento->celular1 . ' - ' . $rsAgendamento->celular2 . ' - ' . $rsAgendamento->celular3;
$nomeMae              = $rsAgendamento->nomemae;
$textoCancelado       = ($rsAgendamento->status_agendamento == "A" || $rsAgendamento->status_agendamento == "E" || $rsAgendamento->status_agendamento == "P") ? "" : "text-decoration: line-through";

# -- pegar dados dos procedimentos agendados -- #
$nomeProcedimento = "";
$preparoProcedimento = "";
$sqlProcedimentoLab = "SELECT ucase(reg_tb_procedimento.nome_procedimento) AS nomeProcedimento
FROM reg_tb_agendamentos_laboratorio
INNER JOIN reg_tb_procedimento ON (reg_tb_agendamentos_laboratorio.id_procedimento_agendado = reg_tb_procedimento.id_procedimento)
WHERE reg_tb_agendamentos_laboratorio.id_agendamento='$idAgendamento'
ORDER BY reg_tb_procedimento.nome_procedimento ASC";
$stmProcedimento  = $rsConexao->prepare($sqlProcedimentoLab);
$stmProcedimento  ->execute();
if($stmProcedimento->rowCount()>0){
  $rsProcedimento = $stmProcedimento->fetchAll(PDO::FETCH_ASSOC);
  foreach($rsProcedimento AS $fieldProcedimento){
    if($stmProcedimento->rowCount()==1){
      $nomeProcedimento = "&bull; ".$fieldProcedimento['nomeProcedimento'];
    }else{
      $nomeProcedimento = $nomeProcedimento=="" ? "&bull; ".$fieldProcedimento['nomeProcedimento'] : $nomeProcedimento.'<br>'."&bull; ".$fieldProcedimento['nomeProcedimento'];
    }
  }
}
# -- ------------ -- #

ob_start();

include_once("include/php-qrcode/vendor/autoload.php");
$urlSiteCentralMarcacao = "https://regulacaomunicipal.pmlf.ba.gov.br";
$setQRCode      = (new \chillerlan\QRCode\QRCode())->render($urlSiteCentralMarcacao);

echo "
<table style='background-color:#e7e7e7; width:100%;'>
  <tr>
    <td style='font-size:12pt; font-weight: bold; padding:3px; text-align:center'>
      DADOS DO PACIENTE
    </td>
  </tr>
</table>
<div class='dados-agendamento-A4'>
  <table width='100%'>
    <tr>
      <td>
        <b>Nome:</b> $nomePaciente
      </td>
      <td align='right' width='190px'>
        <b>CNS:</b> $cnsPaciente
      </td>
    </tr>
  </table>
  <table width='100%'>
    <tr>
      <td>
        <b>Nascimento/Idade: </b> $idadePaciente
      </td>
      <td align='right'>
        <b>Mãe/Resp:</b> $nomeMae
      </td>
    </tr>
  </table> 
  <table width='100%'>
    <tr>
      <td>
        <b>Telefone(s) para contato:</b> $telefonePaciente
      </td>
    </tr>
  </table>    
</div>
<table style='background-color:#e7e7e7; width:100%;'>
  <tr>
    <td style='font-size:12pt; font-weight: bold; padding:3px; text-align:center'>
      DADOS DO AGENDAMENTO
    </td>
  </tr>
</table>
<table class='tb_protocolo'>
  <tr>
    <td class='dados_marcacao'>
      <font style='font-size:11pt; font-weight: bold;'>UNIDADE EXECUTANTE:</font><br>
      <font style='font-size:10pt; font-weight: normal;'>
        $nomeUnidade
      </font><br>
      <font style='font-size:10pt; font-weight: normal;'>
      <b>Endereço:</b> $enderecoUnidade, $bairroUnidade
      </font><br>
    </td>
  </tr>
  <tr>
    <td class='dados_marcacao'>
      <font style='font-size:11pt; font-weight: bold;'>PROFISSIONAL EXECUTANTE:</font><br>
      <font style='font-size:10pt; font-weight: normal;'>
        $nomeProfissional
      </font><br>
    </td>
  </tr>
  <tr>
    <td class='dados_marcacao'>
      <font style='font-size:11pt; font-weight: bold;'>PROCEDIMENTO AGENDADO:</font><br>
      <font style='font-size:10pt; font-weight: normal; $textoCancelado'>
        EXAMES DE LABORATÓRIO
      </font><br>
    </td>
  </tr>
</table><br>
<table style='width:100%; margin-top:-15px; border-bottom:2px dotted '>
  <tr>
    <td style='font-size:14pt; text-align:center'>
      <font style='font-size:14pt'><b>DATA DO ATENDIMENTO</b><br></font>
      <font style='$textoCancelado;font-size:14pt'>
        $dataAtendimento
      </font>    
    </td>
  </tr>
  <tr>
    <td style='font-size:14pt; text-align:center'>
      <font style='font-size:14pt'><b>HORÁRIO</b><br></font>
      <font style='$textoCancelado'>
        $horaAtendimento
      </font>        
    </td>        
  </tr>
</table>
<table style='width:100%; border-bottom:2px dotted '>
  <tr>
    <td style='font-size:12pt; padding:10px;'>
      <table>
        <tr>
          <td>
            <b>CHAVE:</b>
          </td>
          <td>
            <font style='$textoCancelado'>$codigoChave<br></font>
          </td>
        </tr>
        <tr>
          <td>
            <b>PROTOCOLO:</b>
          </td>
          <td>
            <font style='$textoCancelado'>$numeroProtocolo</font>
          </td>
        </tr>
      </table>
    </td>
  </tr>  
</table><br>
<table class='tb_protocolo' style='margin-top:-15px; border:0px'>
  <tr>
    <td style='font-size:11pt; padding:5px; background-color:#e7e7e7; border-bottom: 1px dotted'>
      <b>Preparo e outras informações:</b>
    </td>
  </tr>
  <tr>
    <td style='padding:5px; text-align:justify'>
      <font style='font-size:10pt; font-weight: normal;'>
        $preparoProcedimento
      </font>        
    </td>
  </tr>
</table>";
require_once '../../lib_sistemas/mpdf8/vendor/autoload.php';
$mpdf = new \Mpdf\Mpdf([
  'margin_left'   => 12,
  'margin_right'  => 12,
  'margin_top'    => 35,
  'margin_header' => 12,
  'margin_bottom' => 2.5,
  'mode'          => 'utf-8',
  'default_font'  => 'tahoma',
  'format'        => 'A4'
]);
$nomeMunicipioSede = $_SESSION['nomeMunicipioSede'];
$html = ob_get_clean();
$mpdf->mirrorMargins = 1;
$stylesheet = file_get_contents('relatorios/relatorio.css');
$mpdf->WriteHTML($stylesheet, 1);

$header = "
  <table align='center' class='tb_protocolo'>
    <tr>
      <td style='text-align:center; width:100px'>
        <img src='../app-assets/images/brasao-prefeitura.png' height='80px'>
      </td>
		  <td class='titulo_protocolo' style='border-left:0px; border-right:0px; text-align:left; font-size:13pt'>
        PREFEITURA DE $nomeMunicipioSede<br>
        SECRETARIA DE SAÚDE<br>
        REGULAÇÃO MUNICIPAL
      </td>
      <td style='text-align:center; width:100px; padding-right:10px'>
        <img src='css/images/logo-dark.jpg' height='60px'>
      </td>      
    </tr>
    </table>";

$footer = "<table style='width:100%; font-size:8pt; font-weight: bold;'>
  <tr>
    <td>G-Saúde</td>
    <td align='right'>Impresso em: $dataHoraImpressao</td>
  </tr>
</table>";
$mpdf->SetHTMLHeader($header);
$mpdf->SetFooter($footer);
$mpdf->SetTitle('Impressão de Agendamento');
$mpdf->WriteHTML($html);
$mpdf->Output("ImpressaoAgendamento$numeroProtocolo.pdf", 'I');
exit;
?>