<?php
session_start();
if (!isset($_SESSION['idUsuarioLogado'])) {
  header("location: ./");
}
$idPerfilLogado = $_SESSION['idPerfilLogado'];
include_once("header.php");

$setDisabled              = $idPerfilLogado == 13 ? " disabled" : "";
$statusAgendamento        = $idPerfilLogado == 13 ? " selected" : "";
$setEnableData            = $idPerfilLogado != 13 ? " disabled" : "";
$exibirBotaoGerarExcel    = $idPerfilLogado != 13 ? " style='display:inline'" : " style='display:none'";
$esibirAvisoConfirmacapo  = $idPerfilLogado == 13 ? " display:block" : " display:none";
$idUnidadeLogada          = $_SESSION['unidadeLogada'];

?>
<div class="app-content content" style='background-color:#e1e9e7;'>
  <div class="content-wrapper" style='padding:10px;'>
    <section id="ordering">
      <div class="row">
        <div class="col-12">
          <div class="card" style='border:gray 1px solid;' id="card-tela">
            <div class="card-header titulo-telas">
              <i class="icofont icofont-search" style='margin-top:-15px !important'></i>&nbsp;Consultar Agendamento
              <a class="heading-elements-toggle"><i class="fa fa-ellipsis-v font-medium-3"></i></a>
              <div class="heading-elements">
                <ul class="list-inline mb-0" style="margin-top: -12px; color: #fff;">
                  <li>
                    <a data-action="collapse"><i class="ft-minus"></i></a>
                  </li>
                  <li>
                    <a data-action="expand"><i class="ft-maximize"></i></a>
                  </li>
                </ul>
              </div>
            </div>
            <div class="card-content collapse show">
              <div class="card-body">
                <form class="form" style='margin-top:-10px'>
                  <div class="form-body">
                    <h4 class="form-section"><i class="ft-user"></i> <b>Informações para pesquisa</b></h4>
                    <div class="row" style='margin-top:-10px;'>
                      <div class="col-md-5">
                        <div class="form-group">
                          <label for="unidadeSaude">Unidade Executante:</label>
                          <select type="text" id="unidadeSaude" class="form-control" <?php echo $setDisabled; ?>>
                            <option value=''>SELECIONE...</option>
                            <?php
                            $stmUnidadeSaude  = $rsConexao->prepare("SELECT * FROM tb_estabelecimento WHERE (status_estabelecimento='A' AND codigoestabelecimento_cnes!='9999999999999') ORDER BY nfantasia_estabelecimento");
                            $stmUnidadeSaude->execute();
                            if ($stmUnidadeSaude->rowcount() > 0) {
                              $rsUnidadeSaude   = $stmUnidadeSaude->fetchAll(PDO::FETCH_ASSOC);
                              foreach ($rsUnidadeSaude as $fieldUnidade) {
                                $idUnidade    = $fieldUnidade['codigoestabelecimento_cnes'];
                                $nomeUnidade  = $fieldUnidade['nfantasia_estabelecimento'];
                                echo "<option value='$idUnidade'>$nomeUnidade</option>";
                              }
                            }
                            ?>
                          </select>
                        </div>
                      </div>
                      <div class="col-md-7">
                        <div class="form-group">
                          <label for="profissinoalSaude">Profissional Executante:</label>
                          <select type="text" id="profissinoalSaude" class="form-control">
                            <option value=''>SELECIONE...</option>
                          </select>
                        </div>
                      </div>
                    </div>
                    <div class="row" style="margin-top:-10px;">
                      <div class="col-md-5">
                        <div class="form-group">
                          <label for="grupoProcedimento">Grupo:</label>
                          <select class="form-control" id="grupoProcedimento" onchange="filtrarProcedimentos()">
                            <option value="">TODOS...</option>
                          </select>
                        </div>
                      </div>
                      <div class="col-md-7">
                        <div class="form-group">
                          <label for="nomeProcedimento">Nome do Procedimento:</label>
                          <select class="form-control" id="nomeProcedimento">
                            <option value="">TODOS...</option>
                          </select>
                          <input type="hidden" id="procedimentoSelecionado" class="form-control" />
                        </div>
                      </div>
                    </div>
                    <div class="row" style='margin-top:-10px;'>
                      <div class="col-md-4">
                        <div class="form-group">
                          <label for="statusAgendamento">Status do Agendamento:</label>
                          <select id="statusAgendamento" class="form-control">
                            <option value=''>TODOS...</option>
                            <?php
                            if ($idPerfilLogado != 13) {
                              echo "<option value='A'>AGENDADO</option>
															<option value='E'>ENTREGE</option>
															<option value='C'>CANCELADO</option>
															<option value='V'>CONFIRMADO</option>
															<option value='P'>PENDENTE DE CONFIRMAÇÃO</option>";
                            } else {
                              echo "<option value='A' selected>AGENDADO</option>
                              <option value='C'>CANCELADO</option>
															<option value='V'>CONFIRMADO</option>
															<option value='P'>PENDENTE DE CONFIRMAÇÃO</option>";
                            }
                            ?>
                          </select>
                        </div>
                      </div>
                      <div class="col-md-4">
                        <div class="form-group">
                          <label for="numeroCNSCPF">Cartão SUS/CPF:</label>
                          <input type="text" id="numeroCNSCPF" class="form-control text-center">
                        </div>
                      </div>
                      <div class="col-md-4">
                        <div class="form-group">
                          <label for="numeroProtocolo">Nº Protocolo:</label>
                          <input type="text" id="numeroProtocolo" class="form-control text-center">
                        </div>
                      </div>
                    </div>
                    <div class="row" style="margin-top:-10px;">
                      <div class="col-md-4">
                        <div class="form-group">
                          <label for="opcaoPeriodo">Opção de Periodo:</label>
                          <select id="opcaoPeriodo" class="form-control" <?php echo $setDisabled; ?>>
                            <option value="">INDIFERENTE...</option>
                            <option value="data_atendimento" <?php echo $statusAgendamento; ?>>DATA DE ATENDIMENTO</option>
                            <option value="datahora_agendamento">DATA DE AGENDAMENTO</option>
                            <option value="dataprazo_retirada">DATA DE RETIRADA</option>
                          </select>
                        </div>
                      </div>
                      <div class="col-md-4">
                        <div class="form-group">
                          <label for="dataInicialPesquisa">Data Inicial:</label>
                          <input type="date" id="dataInicialPesquisa" class="form-control text-center" <?php echo $setEnableData; ?>>
                        </div>
                      </div>
                      <div class="col-md-4">
                        <div class="form-group">
                          <label for="dataFinalPesquisa">Data Final:</label>
                          <input type="date" id="dataFinalPesquisa" class="form-control text-center" <?php echo $setEnableData; ?>>
                        </div>
                      </div>
                    </div>
                    <div class="row" style="margin-top:-15px;">
                      <div class="col-md-12">
                        <div class="form-group">
                          <button type="button" class="btn btn-info" onClick="buscarAgendamento('gerar-listagem')">
                            <i class="fa fa-search"></i> Pesquisar
                          </button>
                          <button type="button" class="btn btn-success" onClick="buscarAgendamento('gerar-arquivo-pdf')" disabled id="btnImprimir">
                            <i class="icofont icofont-printer"></i> Imprimir
                          </button>
                          <button type="button" class="btn btn-warning" onClick="buscarAgendamento('gerar-arquivo-pdf-laboratorio')" disabled id="btnImprimirLab">
                            <i class="icofont icofont-print"></i> Imprimir Laboratório
                          </button>
                          <button type="button" class="btn btn-warning" onClick="buscarAgendamento('gerar-arquivo-excel')" id="btnGerarExcel" <?php echo $exibirBotaoGerarExcel; ?> disabled>
                            <i class="icofont icofont-file-excel"></i> Salvar em Excel
                          </button>
                        </div>
                      </div>
                    </div>
                    <div class="row" style="margin-top:-17px; <?php echo $esibirAvisoConfirmacapo; ?>">
                      <div class="col-md-12">
                        <div class="form-group">
                          <div class="bs-callout-danger callout-square callout-bordered mt-1" style='margin-top:0px !important'>
                            <div class="media align-items-stretch">
                              <div class="media-left d-flex align-items-center bg-danger p-2" style='padding:7px !important;'>
                                <i class="icofont icofont-exclamation-tringle white font-medium-5"></i>
                              </div>
                              <div class="media-body p-1" style='padding:7px !important; padding-left:10px !important'>
                                <strong>
                                  ATENÇÃO! O sistema considerará para efeito de confirmação do atendimento, apenas chaves válidas compatíveis com o agendamento. Qualquer chave identificada como inválida ou incompatível com a fornecida no agendamento será desconsiderada e o atendimento continuará como pendente.
                                </strong>
                              </div>
                            </div>
                          </div>
                        </div>
                      </div>
                    </div>
                  </div>
                  <div class="form-actions" style="margin-top:-15px !important"></div>
                </form>
              </div>
            </div>
            <div class="card-content collapse show" style="margin-top:-65px !important">
              <div class="card-body card-dashboard">
                <?php
                if ($idPerfilLogado == 1 || $idPerfilLogado == 14 || $idPerfilLogado == 4) { // se for administrador
                ?>
                  <table class="table table-striped table-bordered default-ordering table-responsive-xl2 listagem-resultado" id='dados_agendamentos_adm'>
                    <thead>
                      <tr>
                        <th style="text-align:center; width:100px">
                          <div style='margin-top:-22px'>OPÇÕES</div>
                        </th>
                        <th>
                          <div style='margin-top:-22px'>NOME DO PACIENTE</div>
                        </th>
                        <th style="text-align:center; width:80px">
                          <div style='margin-top:-22px'>CNS</div>
                        </th>
                        <th>
                          <div style='margin-top:-22px'>PROCEDIMENTO</div>
                        </th>
                        <th style="text-align:center; width:70px">DATA<br>AGENDAMENTO</th>
                        <th style="text-align:center; width:70px">DATA<br>ATENDIMENTO</th>
                        <th style="text-align:center; width:70px">PRAZO<br>RETIRADA</th>
                        <th style="text-align:center; width:60px">
                          <div style='margin-top:-22px'>PROTOCOLO</div>
                        </th>
                        <th style="text-align:center; width:60px">CHAVE<br>VALIDAÇÃO</th>
                        <th style="text-align:center; width:70px">
                          <div style='margin-top:-22px'>STATUS</div>
                        </th>
                        <th style="text-align:center; width:70px">QUEM<BR>MARCOU</th>
                      </tr>
                    </thead>
                    <tbody style="background-color:#ececec">
                    </tbody>
                  </table>
                <?php
                } else if ($idPerfilLogado == 13) { // se for executante
                ?>
                  <table class="table table-striped table-bordered default-ordering table-responsive-xl2 listagem-resultado" id='dados_agendamentos_executante'>
                    <thead>
                      <tr>
                        <th style="text-align:center; width:60px">
                          <div style='margin-top:-22px'>CHAVE</div>
                        </th>
                        <th style="text-align:center; width:80px">
                          <div style='margin-top:-22px'>PROTOCOLO</div>
                        </th>
                        <th>
                          <div style='margin-top:-22px'>NOME DO PACIENTE</div>
                        </th>
                        <th style="text-align:center; width:80px">
                          <div style='margin-top:-22px'>CNS</div>
                        </th>
                        <th style="text-align:center; width:70px">DATA<br>NASCIMENTO</th>
                        <th style="text-align:center; width:100px">
                          <div style='margin-top:-22px'>TELEFONE</div>
                        </th>
                        <th>
                          <div style='margin-top:-22px'>PROCEDIMENTO</div>
                        </th>
                        <th style="text-align:center; width:70px">DATA<br>ATENDIMENTO</th>
                        <th style="text-align:center; width:70px">
                          <div style='margin-top:-22px'>STATUS</div>
                        </th>
                        <th style="text-align:center; width:80px">
                          <div style='margin-top:-22px'>HORÁRIO</div>
                        </th>
                      </tr>
                    </thead>
                    <tbody style="background-color:#ececec">
                    </tbody>
                  </table>
                <?php
                }
                ?>
              </div>
            </div>
          </div>
        </div>
    </section>
  </div>
</div>


<div class='barra-flutuante' style='display: none'>
  <button type='button' class='btn btn-green' onClick='confirmarChave()' id='btnConfirmarChave'>
    <i class='icofont icofont-checked'></i> Confirmar Chave
  </button>
</div>
<?php
include_once("footer.php");
?>
<script src="../app-assets/vendors/js/forms/extended/inputmask/jquery.inputmask.bundle.min.js"></script>
<script src="../app-assets/js/scripts/forms/extended/form-inputmask.min.js"></script>
<script src="../app-assets/vendors/js/tables/datatable/datatables.min.js"></script>
<script src="../app-assets/js/scripts/tables/datatables/datatable-basic.min.js"></script>
<script src="../app-assets/js/scripts/ui/jquery-ui/buttons-selects.min.js"></script>

<script>
  setClassTable("dados_agendamentos_adm");
  $("#liAgendamentoConsultar").attr('class', 'active');
  $("#liAgendamentoConsultar").css("border-bottom", "2px solid #c4c8ca");

  $("#unidadeSaude").change(function() {

    if (this.value != "") {
      $.ajax({
        url: 'filtros/filtrar_profissionalagenda',
        type: 'post',
        dataType: 'html',
        data: {
          'opcaoFiltro': 'agendamento-consultar',
          'idUnidadeSaude': this.value
        }
      }).done(function(resultadoRetorno) {
        $("#profissinoalSaude").html(resultadoRetorno);
        $("#profissinoalSaude").trigger("change");
      });

    } else {
      $("#profissinoalSaude").html("<option value=''>SELECIONE...</option>");
    }

  })

  function filtrarProcedimentos() {

    if ($("#grupoProcedimento").val() != "") {

      $("#embacado").css("display", "block");

      $.ajax({
        url: 'filtros/filtrar_procedimento',
        type: 'post',
        dataType: 'html',
        data: {
          'opcaoPesquisa': 'consultar-agendamento',
          'codigoEstabelecimento': $("#unidadeSaude").val(),
          'codigoProfissional': $("#profissinoalSaude").val(),
          'grupoProcedimento': $("#grupoProcedimento").val()
        }
      }).done(function(resultadoRetorno) {
        $("#procedimentoSelecionado").val("");
        $("#nomeProcedimento").html("");
        $("#nomeProcedimento").html(resultadoRetorno);
        $("#embacado").css("display", "none");
      });

    } else {
      $("#nomeProcedimento").html("<option value=''>TODOS...</option>");
    }

  }

  $("#opcaoPeriodo").change(function() {

    if (this.value != "") {
      $("#dataInicialPesquisa").prop("disabled", false);
      $("#dataFinalPesquisa").prop("disabled", false);
    } else {
      $("#dataInicialPesquisa").prop("disabled", true);
      $("#dataFinalPesquisa").prop("disabled", true);
      $("#dataInicialPesquisa").val("");
      $("#dataFinalPesquisa").val("");
    }

  })

  function buscarAgendamento(opcaoListagem) {

    var perfilLogado = "<?php echo $idPerfilLogado; ?>";

    if (($("#unidadeSaude").val() == "") && ($("#numeroCNSCPF").val() == "" && $("#numeroProtocolo").val() == "")) {
      swal("Informações Obrigatórias", "Você deve selecionara unidade executante o profissional para gerar a lista.", "error");
      return false;
    }

    /*if ($("#statusAgendamento").val() == "") {
    	swal("Informações Obrigatórias", "Você deve selecionara o status do agendamento que deseja pesquisar.", "error");
    	return false;
    }*/

    if (($("#opcaoPeriodo").val() != "" && ($("#dataInicialPesquisa").val() == "" || $("#dataFinalPesquisa").val() == "")) && ($("#numeroCNSCPF").val() == "" && $("#numeroProtocolo").val() == "")) {
      swal("Período Obrigatório", "Você selecionou uma opção para informar o preíodo. Digite data inicial e final.", "error");
      return false;
    }
    if ($("#dataInicialPesquisa").val() > $("#dataFinalPesquisa").val()) {
      swal("Período Inválido", "A data inicial não pode ser maio que a data final.", "error");
      return false;
    }

    switch (opcaoListagem) {
      case "gerar-listagem":
        $("#embacado").css("display", "block");
        switch (perfilLogado) {
          case "1":
          case "14":
          case "4":
            $.ajax({
              url: 'filtros/filtrar_agendamentos',
              type: 'post',
              dataType: 'html',
              data: {
                'opcaoListagem': "buscar-agendamentos-filaG-admin",
                'unidadeSaude': $("#unidadeSaude").val(),
                'profissinoalSaude': $("#profissinoalSaude").val(),
                'grupoProcedimento': $("#grupoProcedimento").val(),
                'nomeProcedimento': $("#nomeProcedimento").val(),
                'statusAgendamento': $("#statusAgendamento").val(),
                'numeroCNSCPF': $("#numeroCNSCPF").val(),
                'numeroProtocolo': $("#numeroProtocolo").val(),
                'opcaoPeriodo': $("#opcaoPeriodo").val(),
                'dataInicialPesquisa': $("#dataInicialPesquisa").val(),
                'dataFinalPesquisa': $("#dataFinalPesquisa").val()
              }
            }).done(function(resultadoRetorno) {
              $("#embacado").css("display", "none");
              if (resultadoRetorno == "NaoExiste") {
                $('#dados_agendamentos_adm').DataTable().destroy();
                $('#dados_agendamentos_adm tbody').empty().append();
                $('#dados_agendamentos_adm').DataTable();
                $("#btnImprimir").prop("disabled", true);
                $("#btnImprimirLab").prop("disabled", true);
                $("#btnGerarExcel").prop("disabled", true);
                swal("Agendamento não Encontrato", "Nenhum agendamento foi encontrado com os dados inforados.", "info");
                return false;
              } else {
                $('#dados_agendamentos_adm').DataTable().destroy();
                $('#dados_agendamentos_adm tbody').empty().append(resultadoRetorno);
                $('#dados_agendamentos_adm').DataTable();
                if ($("#dados_agendamentos_adm").dataTable().fnSettings().fnRecordsTotal() > 0) {
                  $("#btnImprimir").prop("disabled", false);
                  $("#btnImprimirLab").prop("disabled", false);
                  $("#btnGerarExcel").prop("disabled", false);
                } else {
                  $("#btnImprimir").prop("disabled", true);
                  $("#btnImprimirLab").prop("disabled", false);
                  $("#btnGerarExcel").prop("disabled", true);
                }
              }
            });
            break;
          case "13":
            $.ajax({
              url: 'filtros/filtrar_agendamentos',
              type: 'post',
              dataType: 'html',
              data: {
                'opcaoListagem': "buscar-agendamentos-filaG-executante",
                'unidadeSaude': $("#unidadeSaude").val(),
                'profissinoalSaude': $("#profissinoalSaude").val(),
                'grupoProcedimento': $("#grupoProcedimento").val(),
                'nomeProcedimento': $("#nomeProcedimento").val(),
                'statusAgendamento': $("#statusAgendamento").val(),
                'numeroCNSCPF': $("#numeroCNSCPF").val(),
                'numeroProtocolo': $("#numeroProtocolo").val(),
                'opcaoPeriodo': $("#opcaoPeriodo").val(),
                'dataInicialPesquisa': $("#dataInicialPesquisa").val(),
                'dataFinalPesquisa': $("#dataFinalPesquisa").val()
              }
            }).done(function(resultadoRetorno) {
              $("#embacado").css("display", "none");
              if (resultadoRetorno == "NaoExiste") {
                $('#dados_agendamentos_executante').DataTable().destroy();
                $('#dados_agendamentos_executante tbody').empty().append();
                $('#dados_agendamentos_executante').DataTable();
                $("#btnImprimir").prop("disabled", true);
                $("#btnImprimirLab").prop("disabled", true);
                $(".barra-flutuante").css("display", "none");
                swal("Agendamento não Encontrato", "Nenhum agendamento foi encontrado com os dados inforados.", "info");
                return false;
              } else {
                $('#dados_agendamentos_executante').DataTable().destroy();
                $('#dados_agendamentos_executante tbody').empty().append(resultadoRetorno);
                $('#dados_agendamentos_executante').DataTable();
                if ($("#dados_agendamentos_executante").dataTable().fnSettings().fnRecordsTotal() > 0) {
                  $("#btnImprimir").prop("disabled", false);
                  $("#btnImprimirLab").prop("disabled", false);
                  if ($("#statusAgendamento").val() == "A" || $("#statusAgendamento").val() == "P") {
                    $(".barra-flutuante").css("display", "block");
                  } else {
                    $(".barra-flutuante").css("display", "none");
                  }
                } else {
                  if ($("#statusAgendamento").val() == "A" || $("#statusAgendamento").val() == "P") {
                    $(".barra-flutuante").css("display", "block");
                  } else {
                    $(".barra-flutuante").css("display", "none");
                  }
                  $("#btnImprimir").prop("disabled", true);
                  $("#btnImprimirLab").prop("disabled", true);
                }
              }
            });
            break
        }
        break;
      case "gerar-arquivo-pdf":
        var dataCripto = new Date();
        var stringAutorization = btoa(dataCripto + '#' + $("#unidadeSaude").val() + '#' + $("#profissinoalSaude").val() + '#' + $("#grupoProcedimento").val() + '#' + $("#nomeProcedimento").val() + '#' + $("#statusAgendamento").val() + '#' + $("#numeroCNSCPF").val() + '#' + $("#numeroProtocolo").val() + '#' + $("#opcaoPeriodo").val() + '#' + $("#dataInicialPesquisa").val() + '#' + $("#dataFinalPesquisa").val());
        var urlArquivoPDF = "relatorios/imprimir_agendamentos?authorization=" + stringAutorization;
        window.open(urlArquivoPDF);
        break;
      case "gerar-arquivo-pdf-laboratorio":
        var dataCripto = new Date();
        var stringAutorization = btoa(dataCripto + '#' + $("#unidadeSaude").val() + '#' + $("#profissinoalSaude").val() + '#' + $("#grupoProcedimento").val() + '#' + $("#nomeProcedimento").val() + '#' + $("#statusAgendamento").val() + '#' + $("#numeroCNSCPF").val() + '#' + $("#numeroProtocolo").val() + '#' + $("#opcaoPeriodo").val() + '#' + $("#dataInicialPesquisa").val() + '#' + $("#dataFinalPesquisa").val());
        var urlArquivoPDF = "relatorios/imprimir_agendamentos_laboratorio?authorization=" + stringAutorization;
        window.open(urlArquivoPDF);
        break;
      case "gerar-arquivo-excel":
        var dataCripto = new Date();
        var stringAutorization = btoa(dataCripto + '#' + $("#unidadeSaude").val() + '#' + $("#profissinoalSaude").val() + '#' + $("#grupoProcedimento").val() + '#' + $("#nomeProcedimento").val() + '#' + $("#statusAgendamento").val() + '#' + $("#numeroCNSCPF").val() + '#' + $("#numeroProtocolo").val() + '#' + $("#opcaoPeriodo").val() + '#' + $("#dataInicialPesquisa").val() + '#' + $("#dataFinalPesquisa").val());
        var urlArquivoPDF = "action/gerar_listaagendamento_excel?authorization=" + stringAutorization;
        window.location.href = urlArquivoPDF;
        break;
    }
  }

  function confirmarChave() {

    var temChaveDigitada = false;
    var arrayChaveDigitada = new Array();

    //criar array de id e chaves digitadas
    $("input[name='chaveValidarPresenta[]']").each(function() {
      if ($(this).val() != '' && $(this).val() != 0) {
        arrayChaveDigitada.push($(this).attr('id') + '#' + $(this).val());
        temChaveDigitada = true;
      }
    });

    if (temChaveDigitada == false) {
      swal("Chave Obrigatória", "Não foi digitada nenhuma chave para confirmação de atendimento.", "error");
      return false;
    }

    $.ajax({
      url: 'action/gravar_chaveconfirmacao',
      type: 'post',
      dataType: 'html',
      data: {
        'opcaoConfirmacao': 'confirmar-embloco',
        'opcaoFiltro': 'array-chave',
        'chaveDigitada': arrayChaveDigitada
      }
    }).done(function(resultadoRetorno) {
      swal("Confirmação de Atendimento", "As informações digitadas foram processadas. Mas apenas chaves válidas são confirmadas", "success");
      return false;
    });

  }

  /** SETAR UNIDADE LOGADA */
  var idPerfilLogado = "<?php echo $idPerfilLogado; ?>";
  var idUnidadeLogada = "<?php echo $idUnidadeLogada; ?>";
  if (idPerfilLogado == 13) {
    $("#unidadeSaude").val(idUnidadeLogada)
    $("#unidadeSaude").trigger("change");
  }

  $("#profissinoalSaude").change(function() {

    $.ajax({
      url: 'filtros/filtrar_grupoprocedimento',
      type: 'post',
      dataType: 'html',
      data: {
        'opcaoFiltro': 'agendamentos-profissional-grupo',
        'codigoProfissional': this.value,
        'codigoEstabelecimento': $("#unidadeSaude").val()
      }
    }).done(function(resultadoRetorno) {
      $("#grupoProcedimento").html(resultadoRetorno);
      $("#grupoProcedimento").trigger("change");
    });

  });
</script>