<?php
session_start();
if (!isset($_SESSION['idUsuarioLogado'])) {
	header("location: ./");
}
$idPerfilLogado = $_SESSION['idPerfilLogado'];
include_once("header.php");
include_once("include/funcoes_gsaudereg.php");

?>

<div class="app-content content" style='background-color:#e1e9e7;'>
	<div class="content-wrapper" style='padding:10px;'>
		<section id="ordering">
			<div class="row">
				<div class="col-12">
					<div class="card" style='border:gray 1px solid;' id="card-tela">
						<div class="card-header titulo-telas">
							<i class="icofont icofont-gears" style='margin-top:-15px !important'></i>&nbsp;Configuração de Parâmetros
							<a class="heading-elements-toggle"><i class="fa fa-ellipsis-v font-medium-3"></i></a>
							<div class="heading-elements">
								<ul class="list-inline mb-0" style="margin-top: -12px; color: #fff;">
									<li>
										<a data-action="collapse"><i class="ft-minus"></i></a>
									</li>
									<li>
										<a data-action="expand"><i class="ft-maximize"></i></a>
									</li>
								</ul>
							</div>
						</div>
						<div class="card-content collapse show">
							<div class="card-body">
								<form class="form" style='margin-top:-10px'>
									<div class="form-body">
										<h4 class="form-section">
											<i class="icofont icofont-doctor"></i><b>Perfil de atendimento do profissional</b>
											<input type="hidden" id="idParametroProfissional" />
										</h4>
										<div class="row" style='margin-top:-10px;'>
											<div class="col-md-5">
												<div class="form-group">
													<label for="unidadeSaude">Unidade de Saúde:</label>
													<select type="text" id="unidadeSaude" class="form-control">
														<option value=''>SELECIONE A UNIDADE DE SAÚDE...</option>
														<?php
														$stmUnidadeSaude  = $rsConexao->prepare("SELECT * FROM tb_estabelecimento WHERE (status_estabelecimento='A' AND codigoestabelecimento_cnes!='9999999999999') ORDER BY nfantasia_estabelecimento");
														$stmUnidadeSaude->execute();
														if ($stmUnidadeSaude->rowcount() > 0) {
															$rsUnidadeSaude   = $stmUnidadeSaude->fetchAll(PDO::FETCH_ASSOC);
															foreach ($rsUnidadeSaude as $fieldUnidade) {
																$idUnidade    = $fieldUnidade['codigoestabelecimento_cnes'];
																$nomeUnidade  = $fieldUnidade['nfantasia_estabelecimento'];
																echo "<option value='$idUnidade'>$nomeUnidade</option>";
															}
														}
														?>
													</select>
												</div>
											</div>
											<div class="col-md-7">
												<div class="form-group">
													<label for="profissionalSaude">Profissional:</label>
													<select type="text" id="profissionalSaude" class="form-control">
														<option value=''>SELECIONE PRIMEIRO A UNIDADE...</option>
													</select>
												</div>
											</div>
										</div>
										<div class="row" style='margin-top:-10px;'>
											<div class="col-md-4">
												<div class="form-group">
													<label for="sexoPermitido">Sexo Permitido:</label>
													<select id="sexoPermitido" class="form-control">
														<option value='A'>AMBOS</option>
														<option value='M'>MASCULINO</option>
														<option value='F'>FEMININO</option>
													</select>
												</div>
											</div>
											<div class="col-md-4">
												<div class="form-group">
													<label for="">Idade Mínima:</label>
													<input type="text" id="idadeMinima" class="form-control text-center" value="0" onkeypress='return somenteNumero()'>
												</div>
											</div>
											<div class="col-md-4">
												<div class="form-group">
													<label for="">Idade Máxima:</label>
													<input type="text" id="idadeMaxima" class="form-control text-center"  value="130" onkeypress='return somenteNumero()'>
												</div>
											</div>
										</div>
										<div class="row" style='margin-top:-10px;'>
											<div class="col-md-12">
												<div class="form-group">
													<button type="button" class="btn btn-success" onClick="salvarParametro()" id="btnSalvarParametro" style='width:120px'>
														<i class="icofont icofont-checked"></i> Confirmar
													</button>
													<button type="button" class="btn btn-danger" id="btnCancelarEdicao" style='width:120px' disabled>
														<i class="fa fa-times"></i> Cancelar
													</button>
												</div>
											</div>
										</div>
									</div>
									<div class="form-actions" style="margin-top:-15px !important"></div>
								</form>
							</div>
						</div>
						<div class="card-content collapse show" style="margin-top:-65px !important">
							<div class="card-body card-dashboard">
								<table class="table table-striped table-bordered default-ordering table-responsive-x" id='dados_parametro'>
									<thead>
										<tr>
											<th style="text-align:center; width:110px">
												OPÇÕES
											</th>
											<th>
												PROFISSIONAL
											</th>
											<th style="text-align:center; width:100px">
												SEXO PERMITIDO
											</th>
											<th style="text-align:center; width:100px">
												IDADE MÍNIMA
											</th>
											<th style="text-align:center; width:100px">
												IDADE MÁXIMA
											</th>
										</tr>
									</thead>
									<tbody style="background-color:#f5f5f5">
									</tbody>
								</table>
							</div>
						</div>
					</div>
				</div>
			</div>
		</section>
	</div>
</div>

<?php
include_once("footer.php");
?>
<script src="../app-assets/vendors/js/forms/extended/inputmask/jquery.inputmask.bundle.min.js"></script>
<script src="../app-assets/js/scripts/forms/extended/form-inputmask.min.js"></script>
<script src="../app-assets/vendors/js/tables/datatable/datatables.min.js"></script>
<script src="../app-assets/js/scripts/tables/datatables/datatable-basic.min.js"></script>
<script src="../app-assets/js/scripts/ui/jquery-ui/buttons-selects.min.js"></script>

<script>
	
	setClassTable("dados_solicitacoes");
	$("#liAgendaParametros").attr('class', 'active');
	$("#liAgendaParametros").css("border-bottom", "2px solid #c4c8ca");
  
  function somenteNumero(getEvento) {
    var oEvento = getEvento || window.event;
    var chaveEvento = oEvento.keyCode || oEvento.which;
    chaveEvento = String.fromCharCode(chaveEvento);

    var expressaoEvento = /^[0-9.]+$/;
    if (!expressaoEvento.test(chaveEvento)) {
      expressaoEvento.returnValue = false;
      if (oEvento.preventDefault) oEvento.preventDefault();
    }
  }

	
	function filtrarParametros(idUnidade){

		$.ajax({
			url: 'filtros/filtrar_parametros',
			type: 'post',
			dataType: 'html',
			data: {
				'opcaoFiltro'	: 'profissional',
				'idUnidade'		: idUnidade
			}
		}).done(function(resultadoRetorno) {
			$('#dados_parametro').DataTable().destroy();
			$('#dados_parametro tbody').empty().append(resultadoRetorno);
			$('#dados_parametro').DataTable();
		});

	}

	$("#unidadeSaude").change(function() {
		
		if (this.value != "") {
			$.ajax({
				url: 'filtros/filtrar_profissionalagenda',
				type: 'post',
				dataType: 'html',
				data: {
					'opcaoFiltro': 'agenda-configuracao-profissional',
					'idUnidadeSaude': this.value
				}
			}).done(function(resultadoRetorno) {
				$("#profissionalSaude").html(resultadoRetorno);
			});

		} else {
			$("#profissionalSaude").html("<option value=''>SELECIONE PRIMEIRO A UNIDADE</option>");
		}
		$("#profissionalSaude").trigger("change");		
		filtrarParametros(this.value);
	})


	function salvarParametro() {

		if ($("#unidadeSaude").val() == "" || $("#profissionalSaude").val() == "" || $("#sexoPermitido").val() == "" || $("#idadeMinima").val() == "" || $("#idadeMaxima").val() == ""){
			swal("Dados Obrigatórios", "Você deve preencher todas as informações para registrar o parâmetro.", 'error');
			return false;
		}

		$("#embacado").css("display", "block");
		$.ajax({
			url: 'action/gravar_parametro',
			type: 'post',
			dataType: 'html',
			data: {
				'opcaoParametro'	: 'profissional',
				'idParametro'			: $("#idParametroProfissional").val(),
				'idUnidade'				: $("#unidadeSaude").val(),
				'idProfissional'	: $("#profissionalSaude").val(),
				'sexoPermitido'		: $("#sexoPermitido").val(),
				'idadeMinima'			: $("#idadeMinima").val(),
				'idadeMaxima'			: $("#idadeMaxima").val()
			}
		}).done(function(resultadoRetorno) {
			$("#embacado").css("display", "none");
			if (resultadoRetorno == "JaExistePP") {
				swal('Parâmetro Existente', "Já existe uma configuração de parâmetro deste profissional na mesma unidade.", 'error');
				return false;
			}

			$('#dados_parametro').DataTable().destroy();
			$('#dados_parametro tbody').empty().append(resultadoRetorno);
			$('#dados_parametro').DataTable();

			$("#idParametroProfissional").val('');
			$("#profissionalSaude").val('');
			$("#sexoPermitido").val('A');
			$("#idadeMinima").val('0');
			$("#idadeMaxima").val('130');

		});

	}

	function editarParametro(dadosEdicao) {
		var splitDados = dadosEdicao.split("#");
		$("#idParametroProfissional").val(splitDados[0]);
		$("#profissionalSaude").val(splitDados[1]);
		$("#sexoPermitido").val(splitDados[2]);
		$("#idadeMinima").val(splitDados[3]);
		$("#idadeMaxima").val(splitDados[4]);
		$("#btnCancelarEdicao").prop("disabled",false);
	}

	$("#btnCancelarEdicao").click(function() {
		$("#idParametroProfissional").val('');
		$("#unidadeSaude").val('');
		$("#profissionalSaude").val('');
		$("#sexoPermitido").val('A');
		$("#idadeMinima").val('0');
		$("#idadeMaxima").val('130');
		$("#btnCancelarEdicao").prop("disabled",true);
	})

	function excluirParametro(idParametro, idUnidade){

		swal({		
		title: "Exclusão de Parâmetro",
    text: "Confirma exclusão do parâmetro selecionado?",
    icon: "../app-assets/images/question.png",
  
		buttons:{
			confirm: {
       	text: "Sim, Confirmar!",
        value: true,
        visible: true,
        className: "btn-success",
        closeModal: false
      },
      cancel:{
       	text: "Não, Foi engano!",
        value: null,
        visible: true,
        className: "btn-danger",
        closeModal: false,
      }								
	  }

	}).then((isConfirm) => {

	  if (isConfirm) {	
			$.ajax({				
				url: 'action/excluir_registro',
				type: 'post',
				dataType: 'html',
				data: {
					'opcaoExclusao'				: 'parametro-profissional',
					'idUnidade'						: idUnidade,
          'idRegistroExclusao'	: idParametro
				}
			}).done(function(resultadoRetorno){   
				$("#embacado").css("display", "none");
				$('#dados_parametro').DataTable().destroy();
				$('#dados_parametro tbody').empty().append(resultadoRetorno);
				$('#dados_parametro').DataTable();
				swal("Exclusão de Parâmetro.", "O parâmetro selecionado foi excluído com sucesso.", "success");
			});

	  } else {
	    swal("Operação Cancelada.", "O parâmetro selecionado não foi excluído.", "info");
	  }

	}); 
	}
</script>