<?php
session_start();
if (!isset($_SESSION['idUsuarioLogado'])) {
	header("location: ./");
}
$idPerfilLogado = $_SESSION['idPerfilLogado'];
include_once("header.php");
include_once("include/funcoes_gsaudereg.php");

?>

<div class="app-content content" style='background-color:#e1e9e7;'>
	<div class="content-wrapper" style='padding:10px;'>
		<section id="ordering">
			<div class="row">
				<div class="col-12">
					<div class="card" style='border:gray 1px solid;' id="card-tela">
						<div class="card-header titulo-telas">
							<i class="icofont icofont-ui-block" style='margin-top:-15px !important'></i>&nbsp;Afastrar Unidade
							<a class="heading-elements-toggle"><i class="fa fa-ellipsis-v font-medium-3"></i></a>
							<div class="heading-elements">
								<ul class="list-inline mb-0" style="margin-top: -12px; color: #fff;">
									<li>
										<a data-action="collapse"><i class="ft-minus"></i></a>
									</li>
									<li>
										<a data-action="expand"><i class="ft-maximize"></i></a>
									</li>
								</ul>
							</div>
						</div>
						<div class="card-content collapse show">
							<div class="card-body">
								<form class="form" style='margin-top:-10px'>
									<div class="form-body">
										<h4 class="form-section">
											<i class="icofont icofont-edit"></i><b>Informações para pesquisa</b>
											<input type="hidden" id="idAfastamento" />
										</h4>
										<div class="row" style='margin-top:-10px;'>
											<div class="col-md-6">
												<div class="form-group">
													<label for="unidadeSaude">Unidade de Saúde:</label>
													<select type="text" id="unidadeSaude" class="form-control">
														<option value=''>SELECIONE A UNIDADE DE SAÚDE...</option>
														<?php
														$stmUnidadeSaude  = $rsConexao->prepare("SELECT * FROM tb_estabelecimento WHERE (status_estabelecimento='A' AND codigoestabelecimento_cnes!='9999999999999') ORDER BY nfantasia_estabelecimento");
														$stmUnidadeSaude->execute();
														if ($stmUnidadeSaude->rowcount() > 0) {
															$rsUnidadeSaude   = $stmUnidadeSaude->fetchAll(PDO::FETCH_ASSOC);
															foreach ($rsUnidadeSaude as $fieldUnidade) {
																$idUnidade    = $fieldUnidade['codigoestabelecimento_cnes'];
																$nomeUnidade  = $fieldUnidade['nfantasia_estabelecimento'];
																echo "<option value='$idUnidade'>$nomeUnidade</option>";
															}
														}
														?>
													</select>
												</div>
											</div>
											<div class="col-md-3">
												<div class="form-group">
													<label for="dataInicial">Início:</label>
													<input type="date" id="dataInicial" class="form-control text-center" />
												</div>
											</div>
											<div class="col-md-3">
												<div class="form-group">
													<label for="dataFinal">Fim:</label>
													<input type="date" id="dataFinal" class="form-control text-center" />
												</div>
											</div>
										</div>
										<div class="row" style='margin-top:-10px;'>
											<div class="col-md-2">
												<div class="form-group">
													<label for="horaInicial">Hora Inicial:</label>
													<input type="time" id="horaInicial" class="form-control text-center" />
												</div>
											</div>
											<div class="col-md-2">
												<div class="form-group">
													<label for="horaFinal">Hora Final:</label>
													<input type="time" id="horaFinal" class="form-control text-center" />
												</div>
											</div>
											<div class="col-md-8">
												<div class="form-group">
													<label for="motivoAfastamento">Motivo do Afastamento:</label>
													<input type="text" id="motivoAfastamento" class="form-control" />
												</div>
											</div>
										</div>
										<div class="row" style='margin-top:-10px;'>
											<div class="col-md-12">
												<div class="form-group">
													<button type="button" class="btn btn-success" onClick="salvarAfastamento()" id="btnSalvarAfastamento" style='width:120px'>
														<i class="icofont icofont-checked"></i> Confirmar
													</button>
													<button type="button" class="btn btn-danger" id="btnCancelarEdicao" style='width:120px' disabled>
														<i class="fa fa-times"></i> Cancelar
													</button>
												</div>
											</div>
										</div>
									</div>
									<div class="form-actions" style="margin-top:-15px !important"></div>
								</form>
							</div>
						</div>
						<div class="card-content collapse show" style="margin-top:-65px !important">
							<div class="card-body card-dashboard">
								<table class="table table-striped table-bordered default-ordering table-responsive-x" id='dados_afastamento'>
									<thead>
										<tr>
											<th style="text-align:center; width:90px">
												OPÇÕES
											</th>
											<th style="text-align:center; width:120px">
												INÍCIO
											</th>
											<th style="text-align:center; width:120px">
												FIM
											</th>
											<th style="text-align:center; width:120px">
												INTERVALO
											</th>
											<th>
												MOTIVO
											</th>
											<th style="text-align:center; width:70px">
												REGISTRO EM
											</th>
										</tr>
									</thead>
									<tbody style="background-color:#f5f5f5">
									</tbody>
								</table>
							</div>
						</div>
					</div>
				</div>
			</div>
		</section>
	</div>
</div>

<?php
include_once("footer.php");
?>
<script src="../app-assets/vendors/js/forms/extended/inputmask/jquery.inputmask.bundle.min.js"></script>
<script src="../app-assets/js/scripts/forms/extended/form-inputmask.min.js"></script>
<script src="../app-assets/vendors/js/tables/datatable/datatables.min.js"></script>
<script src="../app-assets/js/scripts/tables/datatables/datatable-basic.min.js"></script>
<script src="../app-assets/js/scripts/ui/jquery-ui/buttons-selects.min.js"></script>

<script>
	setClassTable("dados_solicitacoes");
	$("#liUnidadeAfastar").attr('class', 'active');
	$("#liUnidadeAfastar").css("border-bottom", "2px solid #c4c8ca");

	$("#unidadeSaude").change(function() {

		//$("#embacado").css("display", "block");
		$.ajax({
			url: 'filtros/filtrar_afastamento',
			type: 'post',
			dataType: 'html',
			data: {
				'opcaoAfastammento': 'unidade',
				'idUnidade': this.value
			}
		}).done(function(resultadoRetorno) {
			$("#embacado").css("display", "none");
			$('#dados_afastamento').DataTable().destroy();
			$('#dados_afastamento tbody').empty().append(resultadoRetorno);
			$('#dados_afastamento').DataTable();
		});

	})

	function salvarAfastamento() {

		if ($("#unidadeSaude").val() == "" || $("#dataInicial").val() == "" || $("#dataFinal").val() == "" || $("#motivoAfastamento").val() == "") {
			swal("Dados Obrigatórios", "Você deve preencher todas as informações para registrar o afastamento", 'error');
			return false;
		}

		if ($("#dataInicial").val() > $("#dataFinal").val()) {
			swal("Período Inválido", "A data inicial não pode ser posterior a data final.", 'error');
			return false;
		}

		$("#embacado").css("display", "block");
		$.ajax({
			url: 'action/gravar_afastamento',
			type: 'post',
			dataType: 'html',
			data: {
				'opcaoAfastammento': 'unidade-saude',
				'idAfastamento': $("#idAfastamento").val(),
				'idUnidade': $("#unidadeSaude").val(),
				'dataInicial': $("#dataInicial").val(),
				'dataFinal': $("#dataFinal").val(),
				'horaInicial': $("#horaInicial").val(),
				'horaFinal': $("#horaFinal").val(),				
				'motivoAfastamento': $("#motivoAfastamento").val()
			}
		}).done(function(resultadoRetorno) {

			var retornoResultado = resultadoRetorno.split("&&&");
			$("#embacado").css("display", "none");
			if (retornoResultado[0] == "JaExiste") {
				swal('Afastamento Existente', "Já existe um afastamento desta unidade dentro do período ou parâmetros informados.", 'error');
				return false;
			}

			if (retornoResultado[0] == "existeAgendamento") {
				swal('Agendamento Existente', "ATENÇÃO! Existe paciente agendado para este profissional no intervalo de datas informado.", 'warning');
			}
			$('#dados_afastamento').DataTable().destroy();
			$('#dados_afastamento tbody').empty().append(retornoResultado[1]);
			$('#dados_afastamento').DataTable();

			$("#idAfastamento").val('');
			$("#dataInicial").val('');
			$("#dataFinal").val('');
			$("#horaInicial").val('');
			$("#horaFinal").val('');
			$("#horaInicial").val('');
			$("#horaFinal").val('');
			$("#motivoAfastamento").val('');
			$("#btnCancelarEdicao").prop("disabled", true);

		});

	}


	function editarAfastamento(dadosEdicao) {
		var splitDados = dadosEdicao.split("%%");
		$("#idAfastamento").val(splitDados[0]);
		$("#dataInicial").val(splitDados[1]);
		$("#dataFinal").val(splitDados[2]);
		$("#horaInicial").val(splitDados[3]);
		$("#horaFinal").val(splitDados[4]);		
		$("#motivoAfastamento").val(splitDados[5]);
		$("#btnCancelarEdicao").prop("disabled", false);
	}

	$("#btnCancelarEdicao").click(function() {
		$("#idAfastamento").val('');
		$("#dataInicial").val('');
		$("#dataFinal").val('');
		$("#motivoAfastamento").val('');
		$("#btnCancelarEdicao").prop("disabled", true);
	})

	function excluirAfastamento(idAfastamento, idUnidade) {

    Swal.fire({
      title: "Excluir Afastamento",
      html: "<p style='text-align:justify'>Ao excluir um afastamento, as agendas da unidade nesta data estarão liberadas para marcação. <b>Confirma?</b></p>",
      type: "question",
      showCancelButton: !0,
      confirmButtonText: "<i class='icofont icofont-checked'></i> SIM",
      confirmButtonClass: "btn btn-blue botao-confirmacao-swal",
      cancelButtonText: "<i class='fa fa-times'></i> Não",
      cancelButtonClass: "btn btn-danger ml-1 botao-negacao-swal",
      buttonsStyling: !1,
    }).then(function(retornoComando) {
      if (retornoComando.value) {
        $("#embacado").css("display", "block");
				$.ajax({
					url: 'action/excluir_registro',
					type: 'post',
					dataType: 'html',
					data: {
						'opcaoExclusao': 'afastamento-unidade',
						'idUnidade': idUnidade,
						'idRegistroExclusao': idAfastamento
					}
				}).done(function(resultadoRetorno) {
					$("#embacado").css("display", "none");
					$('#dados_afastamento').DataTable().destroy();
					$('#dados_afastamento tbody').empty().append(resultadoRetorno);
					$('#dados_afastamento').DataTable();
					swal("Excluir Afastamento.", "O afastamento selecionado foi excluído com sucesso.", "success");
				});
      }
    });
	}
</script>