<?php
session_start();
require("../../database/dbConection.php");
$usuarioLogado        = $_SESSION['idUsuarioLogado'];
$dataHoraRegistro     = date("Y-m-d H:i");
$idTetoMensal         = $_POST['idTetoMensal'];
$unidadeSaude         = $_POST['unidadeSaude'];
$opcaoGravacao        = $_POST['opcaoGravacao'];

switch ($opcaoGravacao) {

  case "registro-principal":
    $idProcedimentoGrupo  = $_POST['grupoProcedimento'] != 1 ? $_POST['grupoProcedimento'] : $_POST['idProcedimento'];
    $tipoApuracaoTeto     = $_POST['tipoApuracaoTeto'];
    $quantidadeTeto       = $tipoApuracaoTeto == "fisico" ? $_POST['quantidadeTeto'] : null;
    $tetoFinanceiro       = str_replace(".","",$_POST['valorTeto']);
    $tetoFinanceiro       = str_replace(",",".",$tetoFinanceiro);
    $valorTeto            = $tipoApuracaoTeto == "financeiro" ? $tetoFinanceiro : null;

    $grupoProcedimento        = $_POST['grupoProcedimento'];
    $idProcedimento           = $_POST['idProcedimento'] != "" ? $_POST['idProcedimento'] : null;
    $setGrupoOuProcedimento   = ($grupoProcedimento==1 || $grupoProcedimento==14) ? "procedimento" : "grupo";

    if ($idTetoMensal == "") {

      if ($grupoProcedimento == "1" || $grupoProcedimento == "14") {
        $complementoWhere = "id_procedimento='$idProcedimento'";
      } else {
        $complementoWhere = "id_grupo_procedimento='$grupoProcedimento'";
      }
      $sqlExiste = "SELECT id_tetounidade
      FROM reg_tb_tetounidade 
      WHERE (codigoestabelecimento_cnes='$unidadeSaude') AND ($complementoWhere)";
      $stmTetoExiste  = $rsConexao->prepare($sqlExiste);
      $stmTetoExiste->execute();

      if ($stmTetoExiste->rowCount() > 0) {
        echo "JaExiste";
        exit;
      }
    }

    if ($idTetoMensal == "") {
      $sqlTetoMensal  = "INSERT INTO reg_tb_tetounidade(
        codigoestabelecimento_cnes,
        id_grupo_procedimento,
        id_procedimento,
        quantidade_programada,
        valor_programado,
        grupo_ou_procedimento,
        tipo_apuracao,
        id_usuario_cadastrou,
        data_cadastro
      )VALUES(
        :setCodigoEstabelecimento,
        :setIdGrupoProcedimento,
        :setIdProcedimento,
        :setQuantidadeProgramada,
        :setValorProgramado,
        '$setGrupoOuProcedimento',
        :setTipoApuracaoTeto,
        '$usuarioLogado',
        '$dataHoraRegistro'
      )";
    } else {
      $sqlTetoMensal  = "UPDATE reg_tb_tetounidade SET
      codigoestabelecimento_cnes=:setCodigoEstabelecimento,
      id_grupo_procedimento=:setIdGrupoProcedimento,
      id_procedimento=:setIdProcedimento,
      quantidade_programada=:setQuantidadeProgramada,
      valor_programado=:setValorProgramado,
      grupo_ou_procedimento='$setGrupoOuProcedimento',
      tipo_apuracao=:setTipoApuracaoTeto,
      id_usuario_alterou='$usuarioLogado',
      data_ultimaalteracao='$dataHoraRegistro'
      WHERE id_tetounidade='$idTetoMensal'";
    }
    $stmSalvarTeto  = $rsConexao->prepare($sqlTetoMensal);
    $stmSalvarTeto->bindParam(":setCodigoEstabelecimento", $unidadeSaude, PDO::PARAM_STR);
    $stmSalvarTeto->bindParam(":setIdGrupoProcedimento", $grupoProcedimento, PDO::PARAM_STR);
    $stmSalvarTeto->bindParam(":setIdProcedimento", $idProcedimento, PDO::PARAM_STR);
    $stmSalvarTeto->bindParam(":setQuantidadeProgramada", $quantidadeTeto, PDO::PARAM_STR);
    $stmSalvarTeto->bindParam(":setValorProgramado", $valorTeto, PDO::PARAM_STR);
    $stmSalvarTeto->bindParam(":setTipoApuracaoTeto", $tipoApuracaoTeto, PDO::PARAM_STR);
    $stmSalvarTeto->execute();


    //******* carregar lista atualizada */  
    $sqlTetoUnidade = "SELECT reg_tb_tetounidade.id_tetounidade,
    reg_tb_procedimento_grupo.id_grupo_procedimento,
    reg_tb_procedimento_grupo.nome_grupo_procedimento,
    reg_tb_procedimento.id_procedimento,
    reg_tb_procedimento.nome_procedimento,
    reg_tb_procedimento.codigo_sus,
    format(reg_tb_procedimento.valor_vigente, 2, 'de_DE') AS valorVigente,
    ucase(reg_tb_tetounidade.tipo_apuracao) AS tipoApuracao,
    reg_tb_tetounidade.quantidade_programada,
    format(reg_tb_tetounidade.valor_programado, 2, 'de_DE') AS valorProgramado
    FROM reg_tb_tetounidade
    LEFT OUTER JOIN reg_tb_procedimento ON (reg_tb_tetounidade.id_procedimento = reg_tb_procedimento.id_procedimento)
    LEFT OUTER JOIN reg_tb_procedimento_grupo ON (reg_tb_tetounidade.id_grupo_procedimento=reg_tb_procedimento_grupo.id_grupo_procedimento)
    WHERE codigoestabelecimento_cnes='$unidadeSaude' ORDER BY nome_procedimento, nome_grupo_procedimento";

    $stmTetoUnidade = $rsConexao->prepare($sqlTetoUnidade);
    $stmTetoUnidade->execute();

    $rsTetoUnidade  = $stmTetoUnidade->fetchAll(PDO::FETCH_ASSOC);
    foreach ($rsTetoUnidade as $fieldTetoUnidade) {
      $idTetoUnidade          = $fieldTetoUnidade['id_tetounidade'];
      $nomeProcedimentoGrupo  = $fieldTetoUnidade['nome_procedimento'] != "" ? $fieldTetoUnidade['nome_procedimento'] : "GRUPO - " . $fieldTetoUnidade['nome_grupo_procedimento'];
      $codigoProcedimento     = $fieldTetoUnidade['codigo_sus'] != "" ? $fieldTetoUnidade['codigo_sus'] : "GRUPO";
      $tipoApuracao           = $fieldTetoUnidade['tipoApuracao'] == "FISICO"  ? "FÍSICO" : "FINANCEIRO";
      $tipoApuracaoEditar     = mb_strtolower($fieldTetoUnidade['tipoApuracao']);
      $quantidadeValor        = $tipoApuracao=="FÍSICO" ? $fieldTetoUnidade['quantidade_programada'] : $fieldTetoUnidade['valorProgramado'];
      $idGrupoProcedimento    = $fieldTetoUnidade['id_grupo_procedimento'];
      $idProcedimento         = $fieldTetoUnidade['id_procedimento'];
      $valorVigente           = $fieldTetoUnidade['valorVigente'];
      $alinhaQuantidadeValor  = $tipoApuracao == "FÍSICO" ? "center" : "right";

      $linkEditarTeto   = '"editarTeto(' . "'$idTetoUnidade--$idGrupoProcedimento--$valorVigente##$idProcedimento--$tipoApuracaoEditar--$quantidadeValor')" . '"';
      $linkExcluirTeto  = '"excluirTeto(' . "'$idTetoUnidade')" . '"';

      if ($codigoProcedimento == "GRUPO") {
        $linkSelProcedimentosGrupo  = '"selecionarProcedimentosTeto(' . "'$idTetoUnidade')" . '"';
        $iconeCmdSelProcedimento    = "<i class='icofont icofont-prescription nova_fonte_blue' title='Atribuir procedimentos ao grupo.'  onclick=$linkSelProcedimentosGrupo></i>";
      } else {
        $iconeCmdSelProcedimento    = "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";
      }

      echo "<tr>
        <td align='center'>
          $iconeCmdSelProcedimento
          <i class='icofont icofont-edit nova_fonte' title='Editar registro de teto.'  onclick=$linkEditarTeto></i>&nbsp;
          <i class='icofont icofont-close-squared nova_fonte_delete' title='Excluir registro de teto.'  onclick=$linkExcluirTeto></i>&nbsp;
        </td>
        <td>$nomeProcedimentoGrupo</td>
        <td align='center'>$codigoProcedimento</td>
        <td>$tipoApuracao</td>
        <td align='center'>$quantidadeValor</td>
      </tr>";
    }
    //**************************************************** */
    break;


  case "registro-procedimento-grupo":
    $grupoProcedimento  = $_POST['grupoProcedimento'];
    $arrayProcedimento  = $_POST['arrayProcedimento'];

    # -- deletar procedimentos anteriores --#
    $stmExclusao  = $rsConexao->prepare("DELETE FROM reg_tb_tetounidade_grupoprocedimento WHERE id_tetounidade='$idTetoMensal'");
    $stmExclusao->execute();
    $stmRenumera  = $rsConexao->prepare("ALTER TABLE reg_tb_tetounidade_grupoprocedimento AUTO_INCREMENT=1;");
    $stmRenumera->execute();

    $arrayProcedimento    = $_POST['arrayProcedimento'];
    $contarRegistros      =  count($arrayProcedimento);
    $idProcedimentoArray  = 0;

    for ($idRegistro = 1; $idRegistro <= $contarRegistros; $idRegistro++) {
      $idProcedimentoArray = $arrayProcedimento[$idRegistro - 1];

      $sqlAddProcedimento = "INSERT INTO reg_tb_tetounidade_grupoprocedimento(
      id_tetounidade,
      codigoestabelecimento_cnes,
      id_grupo_procedimento,
      id_procedimento
    )VALUES(
      :setIdTetoUnidade,
      :setCodigoEstabelecimento,
      :setIdGrupoProcedimento,
      :setIdProcedimento
    )";
      $stmAddProcedimento = $rsConexao->prepare($sqlAddProcedimento);
      $stmAddProcedimento->bindParam(":setIdTetoUnidade", $idTetoMensal, PDO::PARAM_STR);
      $stmAddProcedimento->bindParam(":setCodigoEstabelecimento", $unidadeSaude, PDO::PARAM_STR);
      $stmAddProcedimento->bindParam(":setIdGrupoProcedimento", $grupoProcedimento, PDO::PARAM_STR);
      $stmAddProcedimento->bindParam(":setIdProcedimento", $idProcedimentoArray, PDO::PARAM_STR);
      $stmAddProcedimento->execute();
    }
    break;
}
