<?php
session_start();
require("../../database/dbConection.php");
require("../../app-assets/phpoffice/vendor/autoload.php");
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;

    $spreadsheet  = new Spreadsheet();
    $spreadsheet  ->getActiveSheet()->getColumnDimension('A')->setWidth(250, 'pt');
    $spreadsheet  ->getActiveSheet()->getColumnDimension('B')->setWidth(100, 'pt');
    $spreadsheet  ->getActiveSheet()->getColumnDimension('C')->setWidth(200, 'pt');
    $spreadsheet  ->getActiveSheet()->getColumnDimension('D')->setWidth(250, 'pt');
    $spreadsheet  ->getActiveSheet()->getColumnDimension('E')->setWidth(150, 'pt');
    $spreadsheet  ->getActiveSheet()->getColumnDimension('F')->setWidth(150, 'pt');
    $spreadsheet  ->getActiveSheet()->getColumnDimension('G')->setWidth(150, 'pt');
    $spreadsheet  ->getActiveSheet()->getColumnDimension('H')->setWidth(150, 'pt');
    $spreadsheet  ->getActiveSheet()->getColumnDimension('I')->setWidth(150, 'pt');
    $spreadsheet  ->getActiveSheet()->getColumnDimension('J')->setWidth(150, 'pt');
    $spreadsheet  ->getActiveSheet()->getColumnDimension('K')->setWidth(150, 'pt');
    $spreadsheet  ->getActiveSheet()->getColumnDimension('L')->setWidth(200, 'pt');
    $spreadsheet  ->getActiveSheet()->getStyle('B3:L3')->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER);
    $spreadsheet  ->getActiveSheet()->getStyle('A3:L3')->getAlignment()->setVertical(\PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER);
    $spreadsheet  ->getActiveSheet()->getRowDimension('3')->setRowHeight(25, 'pt');
    $spreadsheet  ->getActiveSheet()->mergeCells('A1:L1');
    $spreadsheet  ->getActiveSheet()->getStyle('A1:L1')->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER);
    $sheet  = $spreadsheet->getActiveSheet();
    $sheet  -> setCellValue('A1','RELATÓRIO DE AGENDAMENTOS');  
    $sheet  -> setCellValue('A3','NOME DO PACIENTE');
    $sheet  -> setCellValue('B3','CNS');
    $sheet  -> setCellValue('C3','PROCEDIMENTO');
    $sheet  -> setCellValue('D3','UNIDADE EXECUTANTE');
    $sheet  -> setCellValue('E3','PROFISSIONAL');
    $sheet  -> setCellValue('F3','DATA AGENDAMENTO');
    $sheet  -> setCellValue('G3','DATA ATENDIMENTO');
    $sheet  -> setCellValue('H3','PRAZO RETIRADA');
    $sheet  -> setCellValue('I3','STATUS');
    $sheet  -> setCellValue('J3','PROTOCOLO');
    $sheet  -> setCellValue('K3','CHAVE');
    $sheet  -> setCellValue('L3','QUEM MARCOU');
    $estilizarTitulo = [
      'font' => [
        'bold' => true,
        'size' => 14,
      ],    
    ];

    $estilizarRotulos = [
      'font' => [
        'bold' => true,
        'size' => 12,
      ],
      'borders' => [
        'allBorders' => [
          'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
        ]
      ],    
      'fill' => [
        'fillType' => \PhpOffice\PhpSpreadsheet\Style\Fill::FILL_GRADIENT_LINEAR,
        'rotation' => 90,
        'startColor' => [
            'argb' => 'FFE1E1E1',
        ],
        'endColor' => [
            'argb' => 'FFE1E1E1',
        ],
      ],    
    ];  

    $estilizarDados = [
      'font' => [
        'size' => 10
      ],
      'borders' => [
        'allBorders' => [
          'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
        ]
      ], 
    ];

    $sheet->getStyle('A1')->applyFromArray($estilizarTitulo);
    $sheet->getStyle('A3:L3')->applyFromArray($estilizarRotulos);

    $authorizationCode    = explode("#", base64_decode($_GET['authorization']));
    $unidadeSaude         = $authorizationCode[1];
    $profissinoalSaude    = $authorizationCode[2];
    $grupoProcedimento    = $authorizationCode[3];
    $nomeProcedimento     = $authorizationCode[4];
    $statusAgendamento    = $authorizationCode[5];
    $numeroCNSCPF         = $authorizationCode[6];
    $numeroProtocolo      = $authorizationCode[7];
    $opcaoPeriodo         = $authorizationCode[8];
    $dataInicialPesquisa  = $authorizationCode[9];
    $dataFinalPesquisa    = $authorizationCode[10];

# --- pegar unidade e profissional do atendiment -- ##
$formatarStatus = array(
  'A' => 'AGENDADO',
  'C' => 'CANCELADO',
  'V' => 'CONFIRMADO',
  'P' => 'PENDENTE',
  'E' => 'AGENDADO/ENTREGUE',
  'X' => 'CANCELAR'
);

$sqlUnidadeProfissonal = "SELECT 
tb_estabelecimento.nfantasia_estabelecimento,
tb_profissional.nome_profissional
FROM tb_profissional_vinculo
INNER JOIN tb_estabelecimento ON (tb_profissional_vinculo.codigoestabelecimento_cnes=tb_estabelecimento.codigoestabelecimento_cnes)
INNER JOIN tb_profissional ON (tb_profissional_vinculo.codigoprofissional_cnes=tb_profissional.codigoprofissional_cnes)
WHERE (tb_estabelecimento.codigoestabelecimento_cnes='$unidadeSaude') AND (tb_profissional.codigoprofissional_cnes='$profissinoalSaude')";
$stmUnidadeProfissonal    = $rsConexao->prepare($sqlUnidadeProfissonal);
$stmUnidadeProfissonal    -> execute();
$rsUnidadeProfissonal     = $stmUnidadeProfissonal->fetch(PDO::FETCH_OBJ);
$unidadeSelecionada       = mb_strtoupper($rsUnidadeProfissonal->nfantasia_estabelecimento);
$profissionalSelecionado  = mb_strtoupper($rsUnidadeProfissonal->nome_profissional);
# ------------------------------------------------ ##

$whereSQL = " WHERE id_agendamento>0 ";
$whereSQL = $unidadeSaude         == "" ? $whereSQL : $whereSQL . " AND (tb_estabelecimento.codigoestabelecimento_cnes='$unidadeSaude')";
$whereSQL = $profissinoalSaude    == "" ? $whereSQL : $whereSQL . " AND (reg_tb_agenda.codigoprofissional_cnes='$profissinoalSaude')";
$whereSQL = $grupoProcedimento    == "" ? $whereSQL : $whereSQL . " AND (reg_tb_agendamentos.id_grupo_procedimento='$grupoProcedimento')";
$whereSQL = $nomeProcedimento     == "" ? $whereSQL : $whereSQL . " AND (reg_tb_agendamentos.id_procedimento='$nomeProcedimento')";
if($statusAgendamento=="A"){
  $whereSQL = $statusAgendamento    == "" ? $whereSQL : $whereSQL . " AND (reg_tb_agendamentos.status_agendamento='A' OR reg_tb_agendamentos.status_agendamento='E')";
}else{
  $whereSQL = $statusAgendamento    == "" ? $whereSQL : $whereSQL . " AND (reg_tb_agendamentos.status_agendamento='$statusAgendamento')";
}
$whereSQL = $numeroCNSCPF         == "" ? $whereSQL : $whereSQL . " AND (tb_paciente.cns_paciente='$numeroCNSCPF' OR tb_paciente.cpf_paciente='$numeroCNSCPF')";
$whereSQL = $numeroProtocolo      == "" ? $whereSQL : $whereSQL . " AND (reg_tb_agendamentos.protocolo_agendamento='$numeroProtocolo')";
$whereSQL = $opcaoPeriodo         == "" ? $whereSQL : $whereSQL . " AND (reg_tb_agendamentos.$opcaoPeriodo BETWEEN '$dataInicialPesquisa' AND '$dataFinalPesquisa')";

$sqlAgendamentos  = "SELECT reg_tb_agendamentos.id_agendamento,
reg_tb_agendamentos.protocolo_agendamento,
reg_tb_agendamentos.id_paciente,
reg_tb_agendamentos.id_solicitacao,
tb_paciente.nome_paciente,
tb_paciente.cns_paciente,
date_format(tb_paciente.datanasc,'%d/%m/%Y') AS dataNascimento,
tb_paciente.celular1,
tb_paciente.celular2,
tb_paciente.celular3,
reg_tb_procedimento.nome_procedimento,
tb_estabelecimento.nfantasia_estabelecimento,
tb_profissional.nome_profissional,
date_format(reg_tb_agendamentos.datahora_agendamento,'%d/%m/%Y') AS dataAgendamento,
date_format(reg_tb_agendamentos.data_atendimento,'%d/%m/%Y') AS dataAtendimento,
date_format(reg_tb_agendamentos.dataprazo_retirada,'%d/%m/%Y') AS dataRetirada,
reg_tb_usuario.nome_usuario,
reg_tb_agendamentos.status_agendamento,
reg_tb_agendamentos.horario_atendimento,
reg_tb_agendamentos.chave_confirmacao
FROM reg_tb_agenda 
INNER JOIN tb_estabelecimento ON (reg_tb_agenda.codigoestabelecimento_cnes= tb_estabelecimento.codigoestabelecimento_cnes)
INNER JOIN tb_profissional ON (reg_tb_agenda.codigoprofissional_cnes= tb_profissional.codigoprofissional_cnes)
INNER JOIN reg_tb_agendamentos ON (reg_tb_agendamentos.id_agenda = reg_tb_agenda.id_agenda)
INNER JOIN reg_tb_procedimento ON (reg_tb_agendamentos.id_procedimento = reg_tb_procedimento.id_procedimento)
LEFT OUTER JOIN reg_tb_solicitacoes ON (reg_tb_agendamentos.id_solicitacao = reg_tb_solicitacoes.id_solicitacao)
INNER JOIN tb_paciente ON (reg_tb_agendamentos.id_paciente = tb_paciente.id_paciente)
INNER JOIN reg_tb_usuario ON (reg_tb_usuario.id_usuario = reg_tb_agendamentos.id_usuario_agendou)
INNER JOIN reg_tb_agenda_sub ON (reg_tb_agenda_sub.id_agenda = reg_tb_agenda.id_agenda)
$whereSQL
GROUP BY reg_tb_usuario.nome_usuario, reg_tb_agendamentos.id_agendamento
ORDER BY reg_tb_usuario.nome_usuario ASC";
$stmAgendamentos  = $rsConexao->prepare($sqlAgendamentos);
$stmAgendamentos  -> execute();

    if($stmAgendamentos->rowCount()>0){
      $rsAgendamentos = $stmAgendamentos->fetchAll(PDO::FETCH_ASSOC);
      $contadorLinhas     = 3;
      foreach($rsAgendamentos AS $fieldAgendamento){
        $contadorLinhas     = $contadorLinhas+1;
        $nomePaciente       = mb_strtoupper($fieldAgendamento['nome_paciente']);
        $cnsPaciente        = number_format($fieldAgendamento['cns_paciente'],0,"","");
        $dataNascimento     = $fieldAgendamento['dataNascimento'];
        $numerosTelefone    = $fieldAgendamento['celular1'].', '.$fieldAgendamento['celular2'].', '.$fieldAgendamento['celular3'];
        $nomeProcedimento   = mb_strtoupper($fieldAgendamento['nome_procedimento']);
        $nomeUnidade        = mb_strtoupper($fieldAgendamento['nfantasia_estabelecimento']);
        $nomeProfissional   = mb_strtoupper($fieldAgendamento['nome_profissional']);
        $dataAgendamento    = $fieldAgendamento['dataAgendamento'];
        $dataAtendimento    = $fieldAgendamento['dataAtendimento'];
        $dataRetirada       = $fieldAgendamento['dataRetirada'];
        $quemAgendou        = mb_strtoupper($fieldAgendamento['nome_usuario']);
        $horarioAtendimento = $fieldAgendamento['horario_atendimento'];
        $exibirProtocolo    = $fieldAgendamento['protocolo_agendamento'];
        $chaveConfirmacao   = $fieldAgendamento['chave_confirmacao'];
        $statusAgendamento  = $formatarStatus[$fieldAgendamento['status_agendamento']];

        $sheet  -> setCellValue("A$contadorLinhas","$nomePaciente");
        $sheet  -> setCellValue("B$contadorLinhas","$cnsPaciente");
        $sheet  -> setCellValue("C$contadorLinhas","$nomeProcedimento");
        $sheet  -> setCellValue("D$contadorLinhas","$nomeUnidade");
        $sheet  -> setCellValue("E$contadorLinhas","$nomeProfissional");
        $sheet  -> setCellValue("F$contadorLinhas","$dataAgendamento");
        $sheet  -> setCellValue("G$contadorLinhas","$dataAtendimento");
        $sheet  -> setCellValue("H$contadorLinhas","$dataRetirada");
        $sheet  -> setCellValue("I$contadorLinhas","$statusAgendamento");
        $sheet  -> setCellValue("J$contadorLinhas","$exibirProtocolo");
        $sheet  -> setCellValue("K$contadorLinhas","$chaveConfirmacao");
        $sheet  -> setCellValue("L$contadorLinhas","$quemAgendou");
      }
    }

    $spreadsheet  ->getActiveSheet()->getStyle("B4:L$contadorLinhas")->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER);
    $sheet        ->getStyle("A4:L$contadorLinhas")->applyFromArray($estilizarDados);    
    $writer = new Xlsx($spreadsheet);
    $writer -> save('PlanilhaAgendamentos.xls');
  

    header("Content-type: application/vnd.ms-excel");
    header("Content-Length: ".filesize("PlanilhaAgendamentos.xls"));
    header("Content-Disposition: attachment; filename=".basename("PlanilhaAgendamentos.xls"));
    readfile("PlanilhaAgendamentos.xls");


?>