<?php
session_start();
require("../../database/dbConection.php");
require("../include/funcoes_controledr.php");
$usuarioLogado = $_SESSION['idUsuarioLogado'];

$arquivoParaImportacao  = $_FILES['arquivoParaImportacao'];

// Pegar características do arquivo anexado
$tipoArquivo  = $arquivoParaImportacao["type"];
$arquivoTemp  = $arquivoParaImportacao["tmp_name"];
$arquivoImportado = "temp/".$arquivoParaImportacao["name"];
$htmlRetorno = "";

if($tipoArquivo!="text/plain" && $tipoArquivo!="text/csv"){
  echo "erro#Tipo de arquivo inválido. Você deve carregar o arquivo de agendamentos em formato TXT ou CSV.#0";
  exit;
}

$converteNumeroDia = array(
	'SEG'=>1,
	'TER'=>2,
	'QUA'=>3,
	'QUI'=>7,
  'SEX'=>5,
  'SAB'=>6,
  'DOM'=>7
);

  if(move_uploaded_file($arquivoTemp,$arquivoImportado)){
    
    $lerArquivo       = fopen ($arquivoImportado, 'r');
    $contadorLinhas   = 0;
    $resultadoRetorno = "";
    
    # -- IMPORTAR LISTA -- #
    while (($linhaArquivo = fgets($lerArquivo)) !== false) {
      $contadorLinhas = $contadorLinhas+1;
      $fieldRegistro  = explode(';',$linhaArquivo); 
      
      if($contadorLinhas==1){
        if($fieldRegistro[0]!="COD. ESCALA AMBULATORIAL"){
          echo "erro#Arqivo Inválido. Este arquivo não parece ter sido gerado na opção de exportação de escalas do SISREG.#0";
          exit;
        }
      }
      
      if($contadorLinhas>1 && mb_strtoupper($fieldRegistro[29])=="ATIVA"){
        $idEscala               = $fieldRegistro[0];
        $documentoProfissional  = $fieldRegistro[3];
        $nomeProfissional       = $fieldRegistro[4];
        $cnesUnidade            = $fieldRegistro[7];
        $nomeUnidades           = $fieldRegistro[8];
        $diaSemana              = $fieldRegistro[12];
        $diaSemanaNumero        = $converteNumeroDia[$fieldRegistro[12]];
        $vagasPrimeiraVez       = $fieldRegistro[13];
        $minutosPrimeiraVez     = $fieldRegistro[14];
        $vagasRetorno           = $fieldRegistro[15];
        $minutosRetorno         = $fieldRegistro[16];
        $vagasReserva           = $fieldRegistro[17];
        $minutosReserva         = $fieldRegistro[18];
        $quebraAutomatica       = $fieldRegistro[19]=="SIM" ? "S" : "N";
        $dataInicioEscala       = explode("/",$fieldRegistro[21]);
        $dataInicioEscala       = $dataInicioEscala[2]."-".$dataInicioEscala[1]."-".$dataInicioEscala[0];
        $dataFinalEscala        = explode("/",$fieldRegistro[22]);
        $dataFinalEscala        = $dataFinalEscala[2]."-".$dataFinalEscala[1]."-".$dataFinalEscala[0];
        $horaInicioEscala       = $fieldRegistro[23];
        $horaFinalEscala        = $fieldRegistro[24];
        
        # --- INCLUSÃO DAS ESCALAS --- #
        $sqlCarregaEscala = "INSERT IGNORE INTO reg_tb_escala(
          id_escala,
          documento_profissional,
          nome_profissional,
          cnes_unidade,
          nome_unidade,
          dia_semana,
          dia_semana_numero,
          vagas_primeiravez,
          minutos_primeiravez,
          vagas_retorno,
          minutos_retorno,
          vagas_reserva,
          minutos_reserva,
          quebra_automatica,
          datainicio_escala,
          datafinal_escala,
          horainicio_escala,
          horafinal_escala
        )VALUES(
          :setIdEscala,
          :setDocumentoProfissional,
          :setNomeProfissional,
          :setCnesUnidade,
          :setNomeUnidades,
          :setDiaSemana,
          :setDiaSemanaNumero,
          :setVagasPrimeiraVez,
          :setMinutosPrimeiraVez,
          :setVagasRetorno,
          :setMinutosRetorno,
          :setVagasReserva,
          :setMinutosReserva,
          :setQuebraAutomatica,
          :setDataInicioEscala,
          :setDataFinalEscala,
          :setHoraInicioEscala,
          :setHoraFinalEscala
        )";

        $stmCarregaEscala = $rsConexao->prepare($sqlCarregaEscala);
        $stmCarregaEscala -> bindParam(":setIdEscala",$idEscala,PDO::PARAM_STR);
        $stmCarregaEscala -> bindParam(":setDocumentoProfissional",$documentoProfissional,PDO::PARAM_STR);
        $stmCarregaEscala -> bindParam(":setNomeProfissional",$nomeProfissional,PDO::PARAM_STR);
        $stmCarregaEscala -> bindParam(":setCnesUnidade",$cnesUnidade,PDO::PARAM_STR);
        $stmCarregaEscala -> bindParam(":setNomeUnidades",$nomeUnidades,PDO::PARAM_STR);
        $stmCarregaEscala -> bindParam(":setDiaSemana",$diaSemana,PDO::PARAM_STR);
        $stmCarregaEscala -> bindParam(":setDiaSemanaNumero",$diaSemanaNumero,PDO::PARAM_STR);
        $stmCarregaEscala -> bindParam(":setVagasPrimeiraVez",$vagasPrimeiraVez,PDO::PARAM_STR);
        $stmCarregaEscala -> bindParam(":setMinutosPrimeiraVez",$minutosPrimeiraVez,PDO::PARAM_STR);
        $stmCarregaEscala -> bindParam(":setVagasRetorno",$vagasRetorno,PDO::PARAM_STR);
        $stmCarregaEscala -> bindParam(":setMinutosRetorno",$minutosRetorno,PDO::PARAM_STR);
        $stmCarregaEscala -> bindParam(":setVagasReserva",$vagasReserva,PDO::PARAM_STR);
        $stmCarregaEscala -> bindParam(":setMinutosReserva",$minutosReserva,PDO::PARAM_STR);
        $stmCarregaEscala -> bindParam(":setQuebraAutomatica",$quebraAutomatica,PDO::PARAM_STR);
        $stmCarregaEscala -> bindParam(":setDataInicioEscala",$dataInicioEscala,PDO::PARAM_STR);
        $stmCarregaEscala -> bindParam(":setDataFinalEscala",$dataFinalEscala,PDO::PARAM_STR);
        $stmCarregaEscala -> bindParam(":setHoraInicioEscala",$horaInicioEscala,PDO::PARAM_STR);
        $stmCarregaEscala -> bindParam(":setHoraFinalEscala",$horaFinalEscala,PDO::PARAM_STR);
        $stmCarregaEscala -> execute();

        # -- ATUALIZAR LISTA -- #
        $sqlAtualizaEscala = "UPDATE reg_tb_escala SET
        documento_profissional=:setDocumentoProfissional,
        nome_profissional=:setNomeProfissional,
        cnes_unidade=:setCnesUnidade,
        nome_unidade=:setNomeUnidades,
        dia_semana=:setDiaSemana,
        dia_semana_numero=:setDiaSemanaNumero,
        vagas_primeiravez=:setVagasPrimeiraVez,
        minutos_primeiravez=:setMinutosPrimeiraVez,
        vagas_retorno=:setVagasRetorno,
        minutos_retorno=:setMinutosRetorno,
        vagas_reserva=:setVagasReserva,
        minutos_reserva=:setMinutosReserva,
        quebra_automatica=:setQuebraAutomatica,
        datainicio_escala=:setDataInicioEscala,
        datafinal_escala=:setDataFinalEscala,
        horainicio_escala=:setHoraInicioEscala,
        horafinal_escala=:setHoraFinalEscala WHERE id_escala='$idEscala'";

        $stmAtualizaEscala = $rsConexao->prepare($sqlAtualizaEscala);
        $stmAtualizaEscala -> bindParam(":setDocumentoProfissional",$documentoProfissional,PDO::PARAM_STR);
        $stmAtualizaEscala -> bindParam(":setNomeProfissional",$nomeProfissional,PDO::PARAM_STR);
        $stmAtualizaEscala -> bindParam(":setCnesUnidade",$cnesUnidade,PDO::PARAM_STR);
        $stmAtualizaEscala -> bindParam(":setNomeUnidades",$nomeUnidades,PDO::PARAM_STR);
        $stmAtualizaEscala -> bindParam(":setDiaSemana",$diaSemana,PDO::PARAM_STR);
        $stmAtualizaEscala -> bindParam(":setDiaSemanaNumero",$diaSemanaNumero,PDO::PARAM_STR);        
        $stmAtualizaEscala -> bindParam(":setVagasPrimeiraVez",$vagasPrimeiraVez,PDO::PARAM_STR);
        $stmAtualizaEscala -> bindParam(":setMinutosPrimeiraVez",$minutosPrimeiraVez,PDO::PARAM_STR);
        $stmAtualizaEscala -> bindParam(":setVagasRetorno",$vagasRetorno,PDO::PARAM_STR);
        $stmAtualizaEscala -> bindParam(":setMinutosRetorno",$minutosRetorno,PDO::PARAM_STR);
        $stmAtualizaEscala -> bindParam(":setVagasReserva",$vagasReserva,PDO::PARAM_STR);
        $stmAtualizaEscala -> bindParam(":setMinutosReserva",$minutosReserva,PDO::PARAM_STR);
        $stmAtualizaEscala -> bindParam(":setQuebraAutomatica",$quebraAutomatica,PDO::PARAM_STR);
        $stmAtualizaEscala -> bindParam(":setDataInicioEscala",$dataInicioEscala,PDO::PARAM_STR);
        $stmAtualizaEscala -> bindParam(":setDataFinalEscala",$dataFinalEscala,PDO::PARAM_STR);
        $stmAtualizaEscala -> bindParam(":setHoraInicioEscala",$horaInicioEscala,PDO::PARAM_STR);
        $stmAtualizaEscala -> bindParam(":setHoraFinalEscala",$horaFinalEscala,PDO::PARAM_STR);
        $stmAtualizaEscala -> execute();
      }
    }

  }else{
    echo "erro#Impossível carredar dados do arquivo.#0";
  }
  
  #************ CARREGAR LISTA ATUALIZADA ************#
  $htmlRetorno  = "";
  $sqlEscala    = "SELECT nome_unidade, nome_profissional, dia_semana, date_format(datainicio_escala,'%d/%m/%Y') AS dataInicioEscala,date_format(datafinal_escala,'%d/%m/%Y') AS dataFinalEscala, horainicio_escala, horafinal_escala, (vagas_primeiravez+vagas_retorno+vagas_reserva) AS totalVagas FROM reg_tb_escala";
  $stmEscala  = $rsConexao->prepare($sqlEscala);
  $stmEscala  -> execute();
  $rsEscala   = $stmEscala->fetchAll(PDO::FETCH_ASSOC);
  
  if($stmEscala->rowCount()>0){
    foreach($rsEscala AS $fieldEscala){
      $nomeUnidade      = mb_strtoupper($fieldEscala['nome_unidade']);
      $nomeProfissional = mb_strtoupper($fieldEscala['nome_profissional']);
      $diaSemana        = mb_strtoupper($fieldEscala['dia_semana']);
      $dataInicioEscala = $fieldEscala['dataInicioEscala'];
      $dataFinalEscala  = $fieldEscala['dataFinalEscala'];
      $horaInicioEscala = $fieldEscala['horainicio_escala'];
      $horaFinalEscala  = $fieldEscala['horafinal_escala'];
      $totalVagas       = number_format($fieldEscala['totalVagas'],0,'','.');

      $htmlRetorno  .= "<tr>
        <td>$nomeUnidade</td>
        <td>$nomeProfissional</td>
        <td align='center'>$diaSemana</td>
        <td align='center'>$dataInicioEscala</td>
        <td align='center'>$dataFinalEscala</td>
        <td align='center'>$horaInicioEscala</td>
        <td align='center'>$horaFinalEscala</td>
        <td align='center'>$totalVagas</td>
      </tr>";
    }    
  }
  echo "sucesso#Informações importadas com sucesso. Veja na lista abaixo os itens importados.#$htmlRetorno";
  unlink($arquivoImportado);

?>