<?php
$servername_mysql   = "localhost";
$username_mysql     = "portalgsaude_gestor";
$password_mysql     = "CGm57KsElcsmagalhaes";
$database_mysql     = "portalgsaude_gsaude_candeias";


try {
    $pdo = new PDO("mysql:host=$servername_mysql;dbname=$database_mysql", $username_mysql, $password_mysql);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    $telefoneUsuarioWhatsApp = $_GET['telefone_usuario_whatsapp'] ?? '';
    $explodeTelefone = explode("@", $telefoneUsuarioWhatsApp);
    $telefoneDocumentoUsuario = $explodeTelefone[0] ?? '';
    $nomePerfilWhatsApp = $_GET['nome_perfil_whatsapp'] ?? '';

    if (isset($_GET['explode']) && $_GET['explode'] === 's') {
        $response = [
            'telefone_formatado' => $telefoneDocumentoUsuario
        ];
        echo json_encode($response);
        exit;
    }

    if (isset($_GET['cpf'])) {
        $cpf_raw = $_GET['cpf'];
        $cpf_raw = stripslashes($cpf_raw);
        $cpf = trim($cpf_raw ?? '');

        if (empty($cpf)) {
            throw new Exception('cpf está vazio ou inválido.');
        }

        $query = "SELECT id_paciente, nome_paciente FROM tb_paciente WHERE cpf_paciente = :cpf";
        $stmt = $pdo->prepare($query);
        $stmt->bindParam(':cpf', $cpf, PDO::PARAM_STR);
        $stmt->execute();
    } elseif (isset($_GET['cns'])) {
        $cns_raw = $_GET['cns'];
        $cns_raw = stripslashes($cns_raw);
        $cns = trim($cns_raw ?? '');

        if (empty($cns)) {
            throw new Exception('cns está vazio ou inválido.');
        }

        $query = "SELECT id_paciente, nome_paciente FROM tb_paciente WHERE cns_paciente = :cns";
        $stmt = $pdo->prepare($query);
        $stmt->bindParam(':cns', $cns, PDO::PARAM_STR);
        $stmt->execute();
    } else {
        throw new Exception('Parâmetro cpf ou cns não fornecido.');
    }

    $paciente = $stmt->fetch(PDO::FETCH_ASSOC);
    if (!$paciente) {
        throw new Exception('Paciente não encontrado.');
    }

    $idPaciente = $paciente['id_paciente'];
    $nomePaciente = $paciente['nome_paciente'];

    if (isset($_GET['consulta']) && $_GET['consulta'] === 's') {
        $response = [
            'id_paciente' => $idPaciente,
            'nome_paciente' => $nomePaciente
        ];
        echo json_encode($response);
    } else {
        $updateQuery = "
            UPDATE tb_paciente SET
                telefone_notificacao = :telefone_usuario_whatsapp
            WHERE id_paciente = :id_paciente
        ";
        $stmt = $pdo->prepare($updateQuery);
        $stmt->bindParam(':telefone_usuario_whatsapp', $telefoneDocumentoUsuario, PDO::PARAM_STR);
        $stmt->bindParam(':id_paciente', $idPaciente, PDO::PARAM_INT);
        $stmt->execute();

        $insertQuery = "
            INSERT INTO reg_tb_validacaotelefone (
                id_paciente, numero_protocolo, nome_cidadaovalidou, telefone_validado, datahora_validacao
            ) VALUES (
                :id_paciente, :numero_protocolo, :nome_cidadaovalidou, :telefone_validado, NOW()
            )
        ";
        $dataHoraAtual = new DateTime();
        $protocolo = $dataHoraAtual->format('YmdHis');

        $stmt = $pdo->prepare($insertQuery);
        $stmt->bindParam(':id_paciente', $idPaciente, PDO::PARAM_INT);
        $stmt->bindParam(':numero_protocolo', $protocolo, PDO::PARAM_STR);
        $stmt->bindParam(':nome_cidadaovalidou', $nomePerfilWhatsApp, PDO::PARAM_STR);
        $stmt->bindParam(':telefone_validado', $telefoneDocumentoUsuario, PDO::PARAM_STR);
        $stmt->execute();
        $query = "SELECT datahora_validacao FROM reg_tb_validacaotelefone WHERE numero_protocolo = :numero_protocolo";
        $stmt = $pdo->prepare($query);
        $stmt->bindParam(':numero_protocolo', $protocolo, PDO::PARAM_STR);
        $stmt->execute();
        $dataHoraBanco = $stmt->fetch(PDO::FETCH_ASSOC)['datahora_validacao'];

        $dataHoraBanco = new DateTime($dataHoraBanco);

        $response = [
            'nome_paciente' => $nomePaciente,
            'protocolo' => $protocolo,
            'data_confirmacao' => $dataHoraBanco->format('d/m/Y'),
            'hora_confirmacao' => $dataHoraBanco->format('H:i')
        ];

        echo json_encode($response);
    }
} catch (PDOException $e) {
    echo json_encode(['error' => 'Erro: ' . $e->getMessage()]);
} catch (Exception $e) {
    echo json_encode(['error' => 'Erro: ' . $e->getMessage()]);
}
?>
